package CompAnalResult::BSFAMutantsResult;

use strict;

@CompAnalResult::BSFAMutantsResult::ISA=qw(CompAnalResult);

BEGIN {
    $CompAnalResultFactory::Factory{BSFAMUTANTS}=sub { return new CompAnalResult::BSFAMutantsResult };
}

sub new {
    my $class=shift;
    my $self=new CompAnalResult('BSFAMUTANTS');

    bless $self,$class;

    $self->{start}=1e38;
    $self->{end}=-1;
    $self->{strains}=[];
    return $self;
}

sub _start_tagged_data {
    my $self=shift;
    my $tag=shift;
    my $attributes=shift;

    if (lc $tag eq 'strain') {
	my $name=$attributes->{'name'};
	my $start=$attributes->{'start'};
	my $end=$attributes->{'end'};
	my $strand=$attributes->{'strand'};
	$self->{start}=$start
	    if ($start<$self->{start});
	$self->{end}=$end
	    if ($end>$self->{end});
	push @{$self->{strains}},{name=>$name,start=>$start,end=>$end,
				  strand=>$strand,essential=>0};
    }
}

1
