package CompAnalResult::ColorHandler; 

use strict;

@CompAnalResult::ColorHandler::ISA=qw(CompAnalResult);


BEGIN {
    $CompAnalResultFactory::Factory{COLORS}=sub { return new CompAnalResult::ColorHandler @_};
}

sub new {
    my $class=shift;
    my $self=new CompAnalResult('COLORS');

    bless $self,$class;

    $self->{colors}={};
    $self->{in_sync}=1;

    $self->{start}=-1e38;
    $self->{end}=1e38;
	
    return $self;
}

sub _start_tagged_data {
    my $self=shift;
    my $tag=shift;
    my $attributes=shift;

    if (lc $tag eq 'color') {
	my $name=$attributes->{'name'};
	my $red=$attributes->{'red'};
	my $green=$attributes->{'green'};
	my $blue=$attributes->{'blue'};
	$self->{colors}->{$name}={red=>$red,green=>$green,blue=>$blue};
	$self->{in_sync}=0;
    }

}

1
