use strict;


print "Checking for avalaible modules.\n";

my %modules = (
	       'SOAP::Lite' => {type => 'optional',
				functionality => 'XEMBL access'},
	       'CORBA::ORBit' => {type => 'optional',
				  functionality => 'EMBL access'},
	       'DBI' => {type => 'optional', 
			 functionality => 'Micado access'},
	       'DBD::Pg' => {type => 'optional',
			     functionality => 'Micado access'},
	       'Error' => {type => 'required'},
	       'File::Basename' => {type => 'required'},
	       'FindBin' => {type=> 'required'},
	       'GD' => {type => 'required'},
	       'Getopt::Long' => {type=> 'required'},
	       'Gtk' => {type => 'optional',
		     functionality => 'Interactive viewing with mugenv'},
	       'HTTP::Request' => {type => 'optional',
				  functionality => 'EMBL access'},
	       'IO::File' => {type => 'required'},
	       'IO::String' => {type => 'optional',
				functionality => 'Micado access'},
	       'LWP::UserAgent' =>  {type => 'optional',
				  functionality => 'EMBL access'},
	       'Pod::Parser' => {type => 'required'},
	       'Pod::Usage' => {type => 'required'},
	       'XML::Parser::PerlSAX' => {type => 'required'},
	       'XML::Writer' => {type => 'required'},
	       'Bio::DB::GenBank' => {type => 'required'},
	       'Bio::Seq' => {type => 'required'},
	       'Bio::SeqIO' => {type => 'required'},
	       'Bio::SeqFeature::Generic' => {type => 'required'},
	       'Bio::Tools::CodonTable' => {type => 'required'},
	       );

foreach my $module (sort keys %modules) {
    $|=1;
    print "\t$module...";
    
    if ( eval "require $module"  ) {
	print "ok.\n";
    } else {
	print "not found.\n";
	print "Error message : \n\t$@\n";
	if ($modules{$module}->{type} eq 'required') {
	    print "MuGeN WILL NOT WORK AT ALL !\n";
	    exit -1;
	} else {
	    print "\t",$modules{$module}->{functionality}," will not work.\n";
	}
    }
    $|=0;
}

my $DEFAULTPERLPATH="PERLPATH";
my $REALPERLPATH=`which perl`;
chomp($REALPERLPATH);

print "Subsituting path to Perl executable ($REALPERLPATH).\n";

$DEFAULTPERLPATH=~ s/\//\\\//g;
$REALPERLPATH=~ s/\//\\\//g;
my @scripts=qw(mugenb mugenv) ;

foreach my $script (@scripts) {
    $|=1;
    print "\t$script...";
    `perl -i -pe 's/$DEFAULTPERLPATH/$REALPERLPATH/' $script`;
    print "done.\n";
    $|=0;
}

__END__

=head1 NAME

MuGeN

=head1 SYNOPSIS


MuGeN, which stands for Multi-Genome Navigator, is a bioinformatics software package providing two tools. The first one, B<mugenb> can be used to interactively navigate through annotated genomes, whereas the second one, B<mugenb>, can be run in batch mode to generate image files of these genomes. It is capable of importing annotation information from various sources such as local files (in GenBank, EMBL, fasta or BSML format) or remote databases (GenBank, EMBL or Micado).

A major feature of MuGeN is it's ability to mix genome annotations with in silico analysis results as shown in . Analysis results may be drawn on top of features or on dedicated areas below feature lines. They are stored in XML-formatted files having a straightforward grammar (or DTD) which makes it easy to write filters that generate result files from analysis packages.

MuGeN is also capable of displaying multiple interleaved genomes (i.e. when viewing two genomes simultaneously, feature lines will alternate between the first and the second genome). By providing the possibility to define an anchor for each displayed genome, they can be aligned on a specific position or gene offering a view of the surrounding context.

Three levels of visual detail are available: a bird's eye view fit for large genome portions (more than 50 to 100 kb per line), a feature view showing specific representations for the lost frequent feature types (CDS, tRNA, promoter, terminator...). Finally, a sequence view adds the sequence of nucleotides and their translations in the six reading frames to the feature display. The threshold at which views switch from one mode to another is user-definable.


=head1 USAGE

B<Options common to mugenb and mugenv>

=over
=item B<-d source:id>

Specifies a resource from which to load annotated genome maps. Each resource consists of two parts, a source and an id. The source can be one of file, genbank, embl, xembl or micado. When no source is specified, file is taken as default. The id points to the specific map in the source. When the latter is a file, the id is simply the filename (in GenBank, EMBL, BSML or fasta format). When the source is a database (genbank, embl, xembl, micado) the id is the access number of the database entry. Maps will be displayed from top to bottom in the order they are entered on the command line. If the id start with a "!" the map will be flipped.

=item B<-f firstbase>

Specifies the starting point of the image to build. In the absence of any reference points, this is the first base of the map that will be located in the upper left corner of the image. If a reference point is given, the upper left corner will be the reference point offset by the amount specified by this option.

=item B<-l lastbase>

Specifies the ending point of the image to build. In the absence of any reference points, this is the last base of the map that will be located in the upper lower right corner of the image. If a reference point is given, the lower right corner will be the reference point offset by the amount specified by this option.

=item B<-s step>

Specifies the number of bases per display line.

=item B<-r refpos>

Specifies a reference position or anchor for a genome map. If the reference position is an integer, the start of the displayed image will be computed by adding the value of the -f option to the integer. If the reference position is a string, MuGeN will look for a CDS feature having a gene qualifier whose value equals the given string. If such a CDS is found, it's start base will be used to compute the start of de displayed image as explained above. Moreover, if the gene is on the reverse strand, the map will be flipped. The genome map for which the reference position is defined is determined by the index of the -r option wrt. the -d option (i.e. the first -r option will be applied to the map defined by the first -doption, the second -r applies to the second -d and so on).

=item B<-c filename[,index]>

Specifies a computational analysis results file to display with a genome map. If a comma and an index are appended to the filename, the result will be applied to the genome map of the corresponding index. Index 1 is the genome map loaded by the first -d option, index 2 the map corresponding to the second -d and so on.

=item B<-e filename>

Specifes a file containing a color scheme to apply to displayed features.

=item B<-w n>

Specifes the width in pixels of the drawing area

=item B<-p filename>

Specifes the preferences file to load. If no -p option is given, the preferenes file will be set to ${HOME}/.mugenrc.


=back


B<Options specific to mugenb>

=over
=item B<-o format>

Specifies the output format of the image file to be generated. Valid formats are : PNG, IMAP, PS, EPS, XFIG.

=item B<-m mediatype>

Specifies the media type, for PS or EPS output files. Valid types are : a7, a6, a5, a4, a3, a2, a1, a0, b7, b6, b7, b4, b3, b2, b1, b0, lettern legal, executive, ledger.

=item B<-u urlprefix>

Specifies the root URL for client-side image maps in IMAP format. Parameters relative to dislayed features will be appended to this root URL. For instance, given a root URL of http://www.somewhere.org/cgi-bin/myscript.pl?myid=xyz&, and an image containing a CDS feature, whose name is abcX positioned from base 1234 to base 5678, the URL generated for it's clickable area will be http://www.somewhere.org/cgi-bin/myscript.pl?myid=xyz&tag=CDS&name=abcX&start=1234&end=5678.


=back



=head1 CONTACT

Mark Hoebeke (hoebeke@versailles.inra.fr)
__END__

=head1 NAME

MuGeN

=head1 SYNOPSIS


The Multi-Genome Navigator, or MuGeN, is a bioinformatics software package providing tools for exploring multiple annotated genomes along with in silico analysis results. It offers two distinct programs, one for interactive vizualization and navigation and another for the generation of images in various formats. Both programs can load annotated sequence data from a local file or retrieve it from databases across the network. Most of the parameters governing the way annotations and analysis results are displayed are customizable, either through the the graphical user interface or with command-line parameters. The following sections show how to install and to use MuGeN before describing how to format home-made analysis results in order to integrate them in MuGeN.


=head1 USAGE

B<Options common to mugenb and mugenv>

=over
=item B<-d source:id>

Specifies a resource from which to load annotated genome maps. Each resource consists of two parts, a source and an id. The source can be one of file, genbank, embl, xembl or micado. When no source is specified, file is taken as default. The id points to the specific map in the source. When the latter is a file, the id is simply the filename (in GenBank, EMBL, BSML or fasta format). When the source is a database (genbank, embl, xembl, micado) the id is the access number of the database entry. Maps will be displayed from top to bottom in the order they are entered on the command line. If the id start with a "!" the map will be flipped.

=item B<-f firstbase>

Specifies the starting point of the image to build. In the absence of any reference points, this is the first base of the map that will be located in the upper left corner of the image. If a reference point is given, the upper left corner will be the reference point offset by the amount specified by this option.

=item B<-l lastbase>

Specifies the ending point of the image to build. In the absence of any reference points, this is the last base of the map that will be located in the upper lower right corner of the image. If a reference point is given, the lower right corner will be the reference point offset by the amount specified by this option.

=item B<-s step>

Specifies the number of bases per display line.

=item B<-r refpos>

Specifies a reference position or anchor for a genome map. If the reference position is an integer, the start of the displayed image will be computed by adding the value of the -f option to the integer. If the reference position is a string, MuGeN will look for a CDS feature having a gene qualifier whose value equals the given string. If such a CDS is found, it's start base will be used to compute the start of de displayed image as explained above. Moreover, if the gene is on the reverse strand, the map will be flipped. The genome map for which the reference position is defined is determined by the index of the -r option wrt. the -d option (i.e. the first -r option will be applied to the map defined by the first -doption, the second -r applies to the second -d and so on).

=item B<-c filename[,index]>

Specifies a computational analysis results file to display with a genome map. If a comma and an index are appended to the filename, the result will be applied to the genome map of the corresponding index. Index 1 is the genome map loaded by the first -d option, index 2 the map corresponding to the second -d and so on.

=item B<-e filename>

Specifes a file containing a color scheme to apply to displayed features.

=item B<-w n>

Specifes the width in pixels of the drawing area

=item B<-p filename>

Specifes the preferences file to load. If no -p option is given, the preferenes file will be set to ${HOME}/.mugenrc.


=back


B<Options specific to mugenb>

=over
=item B<-o format>

Specifies the output format of the image file to be generated. Valid formats are : PNG, IMAP, PS, EPS, XFIG.

=item B<-m mediatype>

Specifies the media type, for PS or EPS output files. Valid types are : a7, a6, a5, a4, a3, a2, a1, a0, b7, b6, b7, b4, b3, b2, b1, b0, lettern legal, executive, ledger.

=item B<-u urlprefix>

Specifies the root URL for client-side image maps in IMAP format. Parameters relative to dislayed features will be appended to this root URL. For instance, given a root URL of http://www.somewhere.org/cgi-bin/myscript.pl?myid=xyz&, and an image containing a CDS feature, whose name is abcX positioned from base 1234 to base 5678, the URL generated for it's clickable area will be http://www.somewhere.org/cgi-bin/myscript.pl?myid=xyz&tag=CDS&name=abcX&start=1234&end=5678.


=back



=head1 CONTACT

Mark Hoebeke (mhoebeke@jouy.inra.fr)
