package ColorHandler;

use strict;

sub _new {
    my $class=shift;
    my $name=shift;
    my $self={};

    bless $self,$class;

    $self->{name}=$name;

    return $self;
}

sub name {
    my $self=shift;

    return $self->{name};
}

%ColorHandler::color_scheme=();

sub get_colors_for {
    my $self=shift;
    my $feature=shift;
    
    my $name=lc $feature->primary_tag();

    my ($color,$filled)=('black',0);
    if (defined $ColorHandler::color_scheme{$name}) {
	($color,$filled)=&{$ColorHandler::color_scheme{$name}}($self,$feature);
    }
    return ($color,$filled);
}

package ColorHandlerFactory;

use strict;

BEGIN {
    my $subdir=$FindBin::Bin;
    %ColorHandlerFactory::Factory=();
    my @modules=<$subdir/ColorHandler/*.pm>;

    foreach my $module (@modules) {
	eval {
	    require $module;
	}
    }
}


1
