package CompAnalResultWidget::BSFAMutantsWidget;

use strict;

@CompAnalResultWidget::BSFAMutantsWidget::ISA=qw(CompAnalResultWidget);


BEGIN {
    $CompAnalResultWidgetFactory::Factory{BSFAMUTANTS}=sub { return new CompAnalResultWidget::BSFAMutantsWidget @_ };
}

sub new  {
    my $class=shift;
    my $companalresult=shift;
    my $self=new CompAnalResultWidget('axis_overlay');

    bless $self,$class;

    $self->{companalresult}=$companalresult;

    return $self;
}

sub draw {
    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my ($startbase,$endbase)=$strip->get_bounds;
    my ($x_scale,$y_scale)=$strip->scale;
    my ($x_start,$y_start)=$strip->offset;

    my @y_positions=(0.5, 0.0, 0.25);
    my @text_positions=(0.5, 0.0, 0.9);
    my @colors=('green','red');

    foreach my $strain (@{$self->{companalresult}->{strains}}) {
	if (($strain->{start}>=$startbase && $strain->{start}<=$endbase) ||
	    ($strain->{end}>=$startbase && $strain->{end}<=$endbase) ||
	    ($strain->{start}<=$startbase && $strain->{end}>=$endbase)) {
	    my $draw_position_start=($strain->{start}-$startbase)/
		($endbase-$startbase);
	    $draw_position_start=0
		if ($draw_position_start<0);

	    my $draw_position_end=($strain->{end}-$startbase)/
		($endbase-$startbase);
	    $draw_position_end=1
		if ($draw_position_end>1);

	    $paintdevice->add_rectangle($x_start+$draw_position_start*$x_scale,
					$y_start+$y_positions[$strain->{strand}+1]*$y_scale,
					($draw_position_end-$draw_position_start)*$x_scale,
					0.25*$y_scale,
					color => $colors[$strain->{essential}],
					filled => 1);
	    $paintdevice->add_rectangle($x_start+$draw_position_start*$x_scale,
					$y_start+$y_positions[$strain->{strand}+1]*$y_scale,
					($draw_position_end-$draw_position_start)*$x_scale,
					0.25*$y_scale,
					color => 'black',filled => 0);
	    $paintdevice->add_text($x_start+$x_scale*($draw_position_start+$draw_position_end)/2.0,
				   $y_start+$y_scale*$text_positions[$strain->{strand}+1],
				   $strain->{name},
				   halign => 'middle',
				   valign => 'bottom');

	}
    }
}

1
