package FeatureDataSource::XEMBLFeatureDataSource;

use strict;

use Bio::SeqIO;
use IO::String;
use SOAP::Lite;

use FindBin;

use FeatureDataSource;

@FeatureDataSource::XEMBLFeatureDataSource::ISA=qw(FeatureDataSource);

my $orb=undef;
my $database=undef;
my $EMBLNAME='XEMBL';
$FeatureDataSource::XEMBLFeatureDataSource::SERVICE='http://www.ebi.ac.uk/xembl/XEMBL.wsdl';


sub new {
    my $class=shift;
    my %params=();

    $params{start}=-1;
    $params{end}=-1;
    $params{qualifiers}=0;
    while (my $paramname=shift) {
	$params{lc $paramname}=shift;
    }
   
    my $self=_new FeatureDataSource;
    bless $self,$class;

    my $service= SOAP::Lite->service($FeatureDataSource::XEMBLFeatureDataSource::SERVICE);

    my $result=$service->getNucSeq('Bsml',$params{accessnumber});

    if ($result) {
#	my $stringio=IO::String->new($result);
#	my $seqio=Bio::SeqIO->new('-fh' => $stringio,
#				  '-format' => 'bsml');
	my $tmpdir="/tmp";
	$tmpdir=$ENV{'TMPDIR'}
	if (defined $ENV{'TMPDIR'});

	open BSMLFILE,">$tmpdir/mugen_$$";
	print BSMLFILE $result;
	close BSMLFILE;
	my $seqio=Bio::SeqIO->new('-file' => "$tmpdir/mugen_$$",
				  '-format' => 'bsml');
	my $seq= $seqio->next_seq();
	$self->FeatureDataSource::_load_features($seq);
#	unlink "$tmpdir/mugen_$$";
	
    } else {
	warn "XEMBL: could not retrieve data for access number ",
	$params{accessnumber},"\n";
	$self=undef;
    }
    return $self;
}


