package Gui::FeatureWindow;

use strict;

use PhysicalMap;

sub new {
    my $class=shift;
    my $manager=shift;
    my $self={};

    $self->{manager}=$manager;

    my $window=new Gtk::Window -toplevel;
    $window->set_usize(450,400);
    $window->set_title("Information Window");
    $window->signal_connect('delete_event',sub { $manager->quit(); });
    $window->signal_connect('destroy_event',sub { $manager->quit(); });
    $self->{window}=$window;


    my $paned=new Gtk::VPaned();
    $paned->show();
    $window->add($paned);

    my $frame=new Gtk::Frame 'Map Highlights';
    $frame->show();
    $paned->add1($frame);

    

    my $hlightscrolledwindow=new Gtk::ScrolledWindow;
    $hlightscrolledwindow->show();
    $frame->add($hlightscrolledwindow);

    my $highlights=new Gtk::Tree;
    $highlights->show();
    $self->{highlights}=$highlights;
    $hlightscrolledwindow->add_with_viewport($highlights);

    $frame=new Gtk::Frame 'Feature Qualifiers';
    $frame->show();
    $paned->add2($frame);
    
    my $qualscrolledwindow=new Gtk::ScrolledWindow;
    $qualscrolledwindow->show();
    $frame->add($qualscrolledwindow);

    my $annotationtext=new Gtk::Text;
    $annotationtext->show();
    $annotationtext->set_word_wrap(1);
    $annotationtext->set_line_wrap(1);
    $qualscrolledwindow->add($annotationtext);
    $self->{annotationtext}=$annotationtext;

    bless $self,$class;

    return $self;
}

sub reactive_zone_entered {
    my $self=shift;
    my $feature=shift;

    my $textbuffer="Feature : ".$feature->primary_tag()."\n";
    $textbuffer.="Location : ".$feature->location->to_FTstring()."\n";
    foreach my $tag ($feature->all_tags()) {
	$textbuffer.="\t/$tag = ".join(' ',$feature->each_tag_value($tag))."\n";
    }
    $self->{annotationtext}->freeze();
    my $position=0;
    $self->{annotationtext}->delete_text(0,-1);
    $self->{annotationtext}->insert_text($textbuffer,0);
    $self->{annotationtext}->set_point(0);
    $self->{annotationtext}->thaw();
}


sub show_all {
    my $self=shift;

    $self->{window}->show_all;
}

sub build_highlights {
    my $self=shift;


    my $highlights=$self->{highlights};
    $highlights->clear_items(0,-1);
    my $mapinfos=$self->{manager}->get_mapinfo();
    foreach my $mapinfo (@{$mapinfos}) {
	my $mapid=$mapinfo->get_map_id();
	my $item=new Gtk::TreeItem $mapinfo->get_name();
	$item->show();
	$highlights->append($item);
	my $subtree=new Gtk::Tree;
	$subtree->show();
	$item->set_subtree($subtree);
	my $map=$mapinfo->get_map();
	foreach my $companalid ($map->get_companal_result_display_ids()) {
	    $item=new Gtk::TreeItem $companalid;
	    $item->show();
	    $subtree->append($item);
	    my $subsubtree=new Gtk::Tree;
	    $subsubtree->show();
	    $item->set_subtree($subsubtree);
	    foreach my $highlight ($map->get_companal_highlight_names($companalid)) {
		$item=new Gtk::TreeItem $highlight;
		$item->signal_connect("select",sub { $self->highlight_selected($mapid,$companalid,$highlight)});
		$item->show();
		$subsubtree->append($item);
	    }
	}
    }
    $highlights->show_all();
}

sub highlight_selected {
    my $self=shift;
    my $mapid=shift;
    my $companalid=shift;
    my $highlight=shift;

    $self->{manager}->focus_on_highlight($mapid,$companalid,$highlight);

    return 1;

}

sub destroy {
    my $self=shift;

    $self->{window}->destroy();

}

1
