package Gui::MapListWindow;

use strict;

sub new {
 
    my $class=shift;
    my $manager=shift;

    my $self={};
    bless $self,$class;

    $self->{manager}=$manager;

    my $window=new Gtk::Window -toplevel;
    $window->set_title('Map List');
    $window->signal_connect('delete_event',sub { $manager->quit(); });
    $window->signal_connect('destroy_event',sub { $manager->quit(); });
    $self->{window}=$window;

    my $vbox=new Gtk::VBox(0);
    $window->add($vbox);
    $vbox->show();

    my $maplistframe=new Gtk::Frame 'Map Operations';
    $maplistframe->show();
    $vbox->pack_start($maplistframe,1,1,4);

    my $maplistvbox=new Gtk::VBox(0);
    $maplistvbox->show();
    $maplistframe->add($maplistvbox);

    my $mapscrwindow=new Gtk::ScrolledWindow;
    $maplistvbox->pack_start($mapscrwindow,1,1,1);
    $mapscrwindow->show();
    
    my $maplist=new Gtk::List;
    $maplist->signal_connect('selection_changed',sub { $self->maplist_selection_changed();});
    $maplist->show();
    $mapscrwindow->add_with_viewport($maplist);
    $self->{maplist}=$maplist;
    my $hbox=new Gtk::HBox(0);
    $hbox->show();
    $maplistvbox->pack_start($hbox,0,0,1);
    
    my $mapaddhbox=new Gtk::HBox(0);
    $hbox->pack_start($mapaddhbox,1,1,1);

    my $mapdatasourcelabel=new Gtk::Label('Data Source:');
    $mapdatasourcelabel->show();
    $mapaddhbox->pack_start($mapdatasourcelabel,1,1,1);

    my $mapdatasourcemenu=new Gtk::Menu;
    $mapdatasourcemenu->show();
    my $mapdatasourceitem;

    if ( eval {require FeatureDataSource::FileFeatureDataSource;
	       require FeatureDataSourceWindow::FileWindow; } ) {
	my $filewindow=new FeatureDataSourceWindow::FileWindow($manager);
	$self->{filewindow}=$filewindow;
	$mapdatasourceitem=new Gtk::MenuItem('Local File');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='Local File'; return 1});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }

    if ( eval {require FeatureDataSource::MicadoFeatureDataSource; } &&
	 eval {require FeatureDataSourceWindow::MicadoWindow; } ) {
	if (FeatureDataSource::MicadoFeatureDataSource::init()) {
	    my $micadowindow=new FeatureDataSourceWindow::MicadoWindow($manager);
	    $self->{micadowindow}=$micadowindow;
	    $mapdatasourceitem=new Gtk::MenuItem('Micado');
	    $mapdatasourceitem->show();
	    $mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='Micado'; return 1});
	    $mapdatasourcemenu->append($mapdatasourceitem);
	}
    }

    if ( eval {require FeatureDataSource::EMBLFeatureDataSource;
	       require FeatureDataSourceWindow::EMBLWindow;} ) {
	my $emblwindow=new FeatureDataSourceWindow::EMBLWindow($manager);
	$self->{emblwindow}=$emblwindow;
	$mapdatasourceitem=new Gtk::MenuItem('EMBL');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='EMBL'; return 1});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }


    if ( eval {require FeatureDataSource::XEMBLFeatureDataSource;
	       require FeatureDataSourceWindow::XEMBLWindow;} ) {
	my $xemblwindow=new FeatureDataSourceWindow::XEMBLWindow($manager);
	$self->{xemblwindow}=$xemblwindow;
	$mapdatasourceitem=new Gtk::MenuItem('XEMBL');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='XEMBL'; return 1});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }


    if ( eval {require FeatureDataSource::GenBankFeatureDataSource;
	       require FeatureDataSourceWindow::GenBankWindow;} ) {
	my $genbankwindow=new  FeatureDataSourceWindow::GenBankWindow($manager);
	$self->{genbankwindow}=$genbankwindow;
	$mapdatasourceitem=new Gtk::MenuItem('GenBank');
	$mapdatasourceitem->show();
	$mapdatasourceitem->signal_connect('activate',sub {$self->{datasourcetype}='GenBank'; return 1});
	$mapdatasourcemenu->append($mapdatasourceitem);
    }

    my $mapdatasourceoptionmenu=new Gtk::OptionMenu();
    $mapdatasourceoptionmenu->set_menu($mapdatasourcemenu);
    $mapdatasourceoptionmenu->set_history(0);
    $self->{datasourcetype}='Local File';
    $mapdatasourceoptionmenu->show();
    $mapaddhbox->pack_start($mapdatasourceoptionmenu,1,1,1);

    my $mapaddbtn=new Gtk::Button('Add');
    $mapaddbtn->signal_connect('clicked',sub { $self->add_map_from_datasource(); });
    $mapaddbtn->show();
    $mapaddhbox->pack_start($mapaddbtn,1,1,1);
    $self->{mapaddbtn}=$mapaddbtn;

    my $mapupbtn=new Gtk::Button();
    my $uparrow=new Gtk::Arrow('up','out');
    $mapupbtn->add($uparrow);
    $mapupbtn->set_sensitive(0);
    $mapupbtn->signal_connect('clicked',sub { $self->shift_map_up; });
    $mapupbtn->show();
    $hbox->pack_start($mapupbtn,1,1,1);
    $self->{mapupbtn}=$mapupbtn;

    my $mapdownbtn=new Gtk::Button();
    my $downarrow=new Gtk::Arrow('down','out');
    $mapdownbtn->add($downarrow);
    $mapdownbtn->set_sensitive(0);
    $mapdownbtn->signal_connect('clicked',sub { $self->shift_map_down; });
    $mapdownbtn->show();
    $hbox->pack_start($mapdownbtn,1,1,1);
    $self->{mapdownbtn}=$mapdownbtn;

    my $maphsbtn=new Gtk::Button('Hide/Show');
    $maphsbtn->set_sensitive(0);
    $maphsbtn->signal_connect('clicked',sub { $self->hide_show_map; });
    $maphsbtn->show();
    $hbox->pack_start($maphsbtn,1,1,1);
    $self->{maphsbtn}=$maphsbtn;

    my $mapdupbtn=new Gtk::Button('Duplicate');
    $mapdupbtn->set_sensitive(0);
    $mapdupbtn->signal_connect('clicked',sub { $self->duplicate_map; });
    $mapdupbtn->show();
    $hbox->pack_start($mapdupbtn,1,1,1);
    $self->{mapdupbtn}=$mapdupbtn;

    my $maprevcombtn=new Gtk::Button('Flip');
    $maprevcombtn->set_sensitive(0);
    $maprevcombtn->signal_connect('clicked',sub { $self->revcom_map; });
    $maprevcombtn->show();
    $hbox->pack_start($maprevcombtn,1,1,1);
    $self->{maprevcombtn}=$maprevcombtn;

    my $mapsavebtn=new Gtk::Button('Save');
    $mapsavebtn->set_sensitive(0);
    $mapsavebtn->signal_connect('clicked',sub { $self->save_map; });
    $mapsavebtn->show();
    $hbox->pack_start($mapsavebtn,1,1,1);
    $self->{mapsavebtn}=$mapsavebtn;

    my $mapremovebtn=new Gtk::Button('Remove');
    $mapremovebtn->set_sensitive(0);
    $mapremovebtn->signal_connect('clicked',sub { $self->remove_map; });
    $mapremovebtn->show();
    $hbox->pack_start($mapremovebtn,1,1,1);
    $self->{mapremovebtn}=$mapremovebtn;

    my $positionvbox=new Gtk::VBox(0,1);
    $maplistvbox->pack_start($positionvbox,0,0,0);

    my $anchorhbox=new Gtk::HBox(0,1);
    $anchorhbox->show();
    $positionvbox->pack_start($anchorhbox,1,1,1);

    my $anchorlabel=new Gtk::Label('Anchor (Position/Gene) :');
    $anchorlabel->show();
    $anchorhbox->pack_start($anchorlabel,0,0,1);
    my $anchorentry=new Gtk::Entry;
    $anchorentry->show();
    $anchorentry->signal_connect('activate',sub {$self->anchor_changed;});
    $self->{anchorentry}=$anchorentry;
    $anchorhbox->pack_start($anchorentry,1,1,1);

    my $companalframe=new Gtk::Frame 'Computational Result Operations';
    $companalframe->show();
    $vbox->pack_start($companalframe,1,1,4);

    my $companalvbox=new Gtk::VBox(0,1);
    $companalvbox->show();
    $companalframe->add($companalvbox);

    my $companalscrwindow=new Gtk::ScrolledWindow;
    $companalvbox->pack_start($companalscrwindow,1,1,1);
    $companalscrwindow->show();
    
    my $companallist=new Gtk::List;
    $companallist->show();
    $companallist->signal_connect('selection_changed',sub { $self->companallist_selection_changed();});
    $self->{companallist}=$companallist;
    $companalscrwindow->add_with_viewport($companallist);

    my $companalfileselector=new Gtk::FileSelection(' Comp. Results File Selection');
    $self->{companalfileselector}=$companalfileselector;
    $companalfileselector->ok_button->signal_connect('clicked',sub {$self->companal_file_selected();});
    $companalfileselector->cancel_button->signal_connect('clicked',sub {$self->{companalfileselector}->hide(); return 1});

    $hbox=new Gtk::HBox(0);
    $hbox->show();
    $companalvbox->pack_end($hbox,0,0,1);

    my $companaladdbtn=new Gtk::Button('Add');
    $companaladdbtn->set_sensitive(0);
    $companaladdbtn->signal_connect('clicked',sub { $self->{companalfileselector}->show(); return 1});
    $companaladdbtn->show();
    $hbox->pack_start($companaladdbtn,1,1,1);
    $self->{companaladdbtn}=$companaladdbtn;

    my $companalremovebtn=new Gtk::Button('Remove');
    $companalremovebtn->set_sensitive(0);
    $companalremovebtn->signal_connect('clicked',sub { $self->remove_companal; });
    $companalremovebtn->show();
    $hbox->pack_end($companalremovebtn,1,1,1);
    $self->{companalremovebtn}=$companalremovebtn;
    

    return $self;
}

sub add_map_from_datasource {
    my $self=shift;

    $self->{filewindow}->show()
	if ($self->{datasourcetype} eq 'Local File');
    $self->{micadowindow}->show()
	if ($self->{datasourcetype} eq 'Micado');
    $self->{emblwindow}->show()
	if ($self->{datasourcetype} eq 'EMBL');
    $self->{xemblwindow}->show()
	if ($self->{datasourcetype} eq 'XEMBL');
    $self->{genbankwindow}->show()
	if ($self->{datasourcetype} eq 'GenBank');
    return 1;
}

sub add_map {
    my $self=shift;
    my $mapinfo=shift;

    my $maplist=$self->{maplist};

    my $item=new Gtk::ListItem $mapinfo->get_name;
    $item->show();
    $maplist->append_items($item);
    $maplist->select_child($item);

    my $anchor=$mapinfo->get_anchor();
    $self->{anchorentry}->set_text($anchor->{display});
}

sub shift_map_up {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    my $position=$self->{maplist}->child_position($listitem);
    
    if ($position>0) {
	$self->{maplist}->remove_items($listitem);
	$self->{maplist}->insert_items($position-1,$listitem);
	$self->{maplist}->select_child($listitem);
    }
    

    $self->{manager}->shift_map_up($mapname);

    return 1;
}

sub shift_map_down {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    my $position=$self->{maplist}->child_position($listitem);
    
    $self->{maplist}->remove_items($listitem);
    $self->{maplist}->insert_items($position+1,$listitem);
    $self->{maplist}->select_child($listitem);

    $self->{manager}->shift_map_down($mapname);

    return 1;
}

sub hide_show_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    my $position=$self->{maplist}->child_position($listitem);
    
    my $newname=$self->{manager}->hide_show_map($mapname);

    $listitem->children->set_text($newname);

    return 1;

}

sub duplicate_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    $self->{manager}->duplicate_map($mapname);

    return 1;
}


sub revcom_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;


    my $newname=$self->{manager}->revcom_map('NAME'=>$mapname);

    $listitem->children->set_text($newname);

    my $anchor=$self->{manager}->get_mapinfo('NAME'=>$newname);

    $self->{anchorentry}->set_text($anchor->{display});

    return 1;
}


sub remove_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    $self->{manager}->remove_map($mapname);

    $self->{maplist}->unselect_item($listitem);
    $self->{maplist}->remove_items($listitem);

    return 1;
}

sub save_map {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;

    my $mapname=$listitem->children->get;

    if (!defined $self->{savewindow}) {
	my $filewindow=new Gtk::FileSelection('Save Map');
	$self->{savewindow}=$filewindow;
	$filewindow->ok_button->signal_connect('clicked',
			       sub {$self->save_map_filename_selected($mapname)});
	$filewindow->cancel_button->signal_connect('clicked',
	                       sub { $self->{savewindow}->hide(); return 1});

    }
    
    my $filename=$mapname;
    $filename =~ s/\(.*\)//g;
    $filename =~ s/\s-\sChr.*$//;
    $filename =~ tr/ /_/;
    $filename .='.gbk';
    $self->{savewindow}->set_filename($filename);
    $self->{savewindow}->show();

    return 1;
}

sub save_map_filename_selected {
    my $self=shift;
    my $mapname=shift;

    my $filename=$self->{savewindow}->get_filename();
    $self->{savewindow}->hide();
    $self->{manager}->save_map_to_file($mapname,$filename);

    return 1;
}

sub maplist_selection_changed {
    my $self=shift;

    my $widget=$self->{maplist}->selection();
    if (!defined $widget) {
	$self->{companallist}->set_sensitive(0);
	$self->{mapsavebtn}->set_sensitive(0);
	$self->{mapremovebtn}->set_sensitive(0);
	$self->{maphsbtn}->set_sensitive(0);
	$self->{mapupbtn}->set_sensitive(0);
	$self->{mapdownbtn}->set_sensitive(0);
	$self->{mapdupbtn}->set_sensitive(0);
	$self->{maprevcombtn}->set_sensitive(0);
	$self->{anchorentry}->delete_text(0,-1);
	$self->{anchorentry}->set_sensitive(0);
    } else {
	$self->{maphsbtn}->set_sensitive(1);
	$self->{mapdupbtn}->set_sensitive(1);
	$self->{maprevcombtn}->set_sensitive(1);
	$self->{companallist}->set_sensitive(1);
	$self->{anchorentry}->set_sensitive(1);
	my $mapname=$widget->children->get;
	my $mapinfo=$self->{manager}->get_mapinfo('NAME'=>$mapname);
	my $anchor=$mapinfo->get_anchor();
	$self->{anchorentry}->insert_text($anchor->{display},0);
	my @children=$self->{maplist}->children;
	$self->{mapsavebtn}->set_sensitive(1);
	if ($#children>0) {
	    $self->{mapremovebtn}->set_sensitive(1);
	    $self->{mapupbtn}->set_sensitive(1);
	    $self->{mapdownbtn}->set_sensitive(1);
	}
    }
    $self->refresh_companal_widgets($widget);

    return 1;
}

sub anchor_changed {
    my $self=shift;

    my $listitem=$self->{maplist}->selection;
    my $mapname=$listitem->children->get;
    my $newanchor=$self->{anchorentry}->get_text();
    my $mapinfo=$self->{manager}->get_mapinfo('NAME'=>$mapname);
    $self->{manager}->set_anchor('NAME'=> $mapname,$newanchor);
    my $newname=$mapinfo->get_name();
    $listitem->children->set_text($newname);
    $newanchor=$mapinfo->get_anchor()->{display};
    $self->{anchorentry}->set_text($newanchor);

    return 1;

}

sub refresh_companal_widgets {
    my $self=shift;
    my $widget=shift;

    my @companalwidgets=$self->{companallist}->children();
    $self->{companallist}->clear_items(0,$#companalwidgets);
    foreach my $companalwidget (@companalwidgets) {
	$companalwidget->destroy();
    }
    if (!defined $widget) {
	$self->{companallist}->set_sensitive(0);
	$self->{companaladdbtn}->set_sensitive(0);
	$self->{companalremovebtn}->set_sensitive(0);
    } else {
	$self->{companallist}->set_sensitive(1);
	$self->{companaladdbtn}->set_sensitive(1);
	my @children=$widget->children;
	if (defined $children[0]) {
	    my @companalnames=$self->{manager}->get_companal_names($children[0]->get);
	    my $lastitem;
	    foreach my $companalname (@companalnames) {
		my $item = new Gtk::ListItem $companalname;
		$self->{companallist}->append_items($item);
		$item->show();
		$lastitem=$item;
	    }
	    $self->{companallist}->select_child($lastitem)
		if (defined $lastitem);
	}
    }
}


sub companallist_selection_changed {
    my $self=shift;

    my $widget=$self->{companallist}->selection();
    if (!defined $widget) {
	$self->{companalremovebtn}->set_sensitive(0);
    } else {
	my @children=$self->{companallist}->children;
	$self->{companalremovebtn}->set_sensitive(1)
	    if ($#children >= 0);
    }

    return 1;
}

sub companal_file_selected {
    my $self=shift;

    my $file=$self->{companalfileselector}->get_filename();

    my $listitem=$self->{maplist}->selection;
    
    my $mapname=$listitem->children->get;    

    $self->{companalfileselector}->hide();
    $self->{manager}->add_companal_from_file($mapname,$file);

    return 1;
}

sub update_comp_anal_list {
    my $self=shift;
    my $mapname=shift;

    my @children=$self->{companallist}->children;
    foreach my $widget (@children) {
	$self->{companallist}->remove($widget);
	$widget->destroy();
    }

    my @companalnames=$self->{manager}->get_companal_names($mapname);
    foreach my $name (@companalnames) {
	my $item=new Gtk::ListItem $name;
	$self->{companallist}->append_items($item);
	$item->show();
    }
}

sub remove_companal {
    my $self=shift;

    my $widget=$self->{companallist}->selection();
    if (!defined $widget || !defined $widget->children()) {
	warn "Trying to remove non existing analysis result. ($widget,",
	$widget->children(),").";
	return 1;
    }
    my $companalname=$widget->children->get();
    my $mapname=$self->{maplist}->selection->children->get();

    $self->{manager}->remove_companal_result($mapname,$companalname);

    $self->refresh_companal_widgets($self->{maplist}->selection());

    return 1;
}

sub show_all {
    my $self=shift;

    $self->{window}->show_all();

}

sub destroy {
    my $self=shift;

    $self->{window}->destroy();
}

1
