package CompAnalResult::HistogramResult; 

use strict;

@CompAnalResult::HistogramResult::ISA=qw(CompAnalResult);


BEGIN {
    $CompAnalResultFactory::Factory{HISTOGRAM}=sub { return new CompAnalResult::HistogramResult @_};
}

sub new {
    my $class=shift;
    my $attributes=shift;

    my $self=new CompAnalResult("HISTOGRAM",$attributes->{comment});

    bless $self,$class;

    $self->{bars}=[];
    $self->{start}=1;
    $self->{end}=1;
    $self->{height}=4;
    $self->{height}=$attributes->{'height'}
    if (defined $attributes->{height});
    $self->{min}=1e38;
    $self->{min}=$attributes->{'min'}
    if (defined $attributes->{min});
    $self->{max}=-1e38;
    $self->{max}=$attributes->{'max'}
    if (defined $attributes->{max});
    $self->{barwidth}=1;
    $self->{barwidth}=$attributes->{'barwidth'}
    if (defined $attributes->{'barwidth'});
    $self->{barcolor}='black';
    $self->{barcolor}=$attributes->{'barcolor'}
    if (defined $attributes->{'barcolor'});
    $self->{filledbars}=1;
    $self->{filledbars}=0
	if ($attributes->{'filledbars'} eq 'no');
    return $self;
}

sub _start_tagged_data {

    my $self=shift;
    my $tag=shift;
    my $attributes=shift;


    if (lc $tag eq 'bar') {
	my $barstart=$self->{end}+1;
	if (defined $attributes->{'begin'}) {
	    $barstart=$attributes->{'begin'};
	}
	my $barwidth=$self->{barwidth};
	if (defined $attributes->{'width'}) {
	    $barwidth=$attributes->{'width'};
	}
	$self->{start}=$barstart
	    if ($self->{start}>$barstart);
	$self->{end}=$barstart+$barwidth-1
	    if ($self->{end}<$barstart+$barwidth+1);
	my $height=$attributes->{'height'};
	$self->{'min'}=$height
	    if ($height<$self->{'min'});
	$self->{'max'}=$height
	    if ($height>$self->{'max'});
	my $color=$self->{barcolor};
	$color=$attributes->{'color'}
	if (defined $attributes->{'color'});
	my $filled=$self->{'filledbars'};
	$filled=0
	    if ($attributes->{'filled'} eq 'no');
	my $info=$attributes->{info};
	push @{$self->{bars}},{start => $barstart,
			       width => $barwidth,
			       height => $height,
			       color => $color,
			       filled => $filled,
			       info => $info};
    }

}

sub _end_tagged_data {
}


sub _add_line {

}

1
