package CompAnalResult::LinePlotResult; 

use strict;

use CompAnalResult;

@CompAnalResult::LinePlotResult::ISA=qw(CompAnalResult);


BEGIN {
    $CompAnalResultFactory::Factory{LINEPLOTS}=sub { return new CompAnalResult::LinePlotResult @_};
}

sub new {
    my $class=shift;
    my $attributes=shift;

    my $self=new CompAnalResult("LINEPLOTS",$attributes->{comment});

    bless $self,$class;

    $self->{lineplots}=[];
    $self->{currentplot}={};
    $self->{start}=1;
    $self->{end}=1;
    $self->{min}=1e38;
    $self->{min}=$attributes->{'min'}
    if (defined $attributes->{min});
    $self->{max}=-1e38;
    $self->{max}=$attributes->{'max'}
    if (defined $attributes->{max});
    $self->{type}=$attributes->{'type'};
    $self->{smoothing}=$attributes->{'smoothing'};
    return $self;
}

sub _start_tagged_data {

    my $self=shift;
    my $tag=shift;
    my $attributes=shift;


    if (lc $tag eq 'lineplot') {
	my $frame=$attributes->{'frame'};
	$frame='none'
	    if (!defined $frame);
	my $strand=$attributes->{'strand'};
	$strand='1'
	    if (!defined $strand);
	my $color=$attributes->{'color'};
	$color='black'
	    if (!defined $color);
	my $start=$attributes->{'start'};
	$start=1
	    if (!defined $start);
	my $step=$attributes->{'step'};
	$step=1
	    if (!defined $step);
	$self->{currentplot}={ frame =>$frame,
			       strand => $strand,
			       color=>$color,
			       start=>$start,
			       step=>$step,
			       data=>[]};
    }

}

sub _end_tagged_data {
    my $self=shift;
    my $tag=shift;

    if (lc $tag eq 'lineplot' && $self->{currentplot}) {
	$self->{start}=$self->{currentplot}->{start}
	if ($self->{currentplot}->{start}<$self->{start});

	my $end=$self->{currentplot}->{start}+$self->{currentplot}->{step}*$#{$self->{currentplot}->{data}};
	$self->{end}=$end
	    if ($end>$self->{end});

	push @{$self->{lineplots}},$self->{currentplot};
	$self->{currentplot}=undef;
    }
}


sub _add_line {
    my $self=shift;
    my $value=shift;

    if (defined $self->{currentplot}) {
	push @{$self->{currentplot}->{data}},$value*1.0;
	$self->{min}=$value
	    if ($value<$self->{min});
	$self->{max}=$value
	    if ($value>$self->{max});
    }

}

1
