package CompAnalResult::LinkPlotResult; 

use strict;

@CompAnalResult::LinkPlotResult::ISA=qw(CompAnalResult);


BEGIN {
    $CompAnalResultFactory::Factory{LINKS}=sub { return new CompAnalResult::LinkPlotResult @_};
}

sub new {
    my $class=shift;
    my $attributes=shift;

    my $self=new CompAnalResult("LINKS",$attributes->{comment});

    bless $self,$class;

    $self->{links}=[];
    $self->{height}=4;
    $self->{height}=$attributes->{'height'}
    if (defined $attributes->{height});
    $self->{start}=1;
    $self->{end}=1;
    return $self;
}

sub _start_tagged_data {

    my $self=shift;
    my $tag=shift;
    my $attributes=shift;


    if (lc $tag eq 'link') {
	my $from=$attributes->{'from'};
	my $to=$attributes->{'to'};
	my $color=$attributes->{'color'};
	$color='black'
	    if (!defined $color);
	my $info=$attributes->{info};
	push @{$self->{links}},{from => $from,
				to => $to,
				color => $color,
			    info => $info};
	$self->{start}=$from
	    if ($from < $self->{start});
	$self->{end}=$from
	    if ($from > $self->{end});

	$self->{start}=$to
	    if ($to < $self->{start});
	$self->{end}=$to
	    if ($to > $self->{end});
    }

}

sub _end_tagged_data {
}


sub _add_line {

}

1
