package CompAnalResultSource;

use strict;

use CompAnalResult;

use PreferencesHandler;



sub set_preferences {
    my $mugen=$PreferencesHandler::Preferences->getDocumentElement();
    my @nodes=$mugen->getElementsByTagName('resultdatasources');
    my $rdsources=undef;
    if (scalar(@nodes)==0) {
	my $doctype=$PreferencesHandler::Preferences->getDoctype();
	$doctype->addElementDecl('resultdatasources','(origamiresults|mosaicresults)*');
	$rdsources=$PreferencesHandler::Preferences->createElement('resultdatasources');
	$mugen->appendChild($rdsources);
    }
}

BEGIN {
    PreferencesHandler::register_listener(\&set_preferences);
}

sub _new {
    my $class=shift;
    my $logwindow=shift;
    my $self={};

    $self->{companalresults}=[];
    $self->{logwindow}=$logwindow;
    bless $self,$class;

    return $self;
}

sub get_results {
    my $self=shift;
    
    return $self->{companalresults};
}

sub set_log_window {
    my $self=shift;
    $self->{logwindow}=shift;
}

1
