package CompAnalResultHandler;

use strict;
use FindBin;

sub new {
    my $class=shift;

    my $self={};

    $self->{in_companalresults}=0;
    $self->{currentinstance}=undef;
    $self->{currentcharacterline}='';
    $self->{currenthightlight}={};
    $self->{currenthightlights}=[];
    $self->{companalresult_instances}=[];

    bless $self,$class;

    return $self;

}

sub start_element {
    my $self=shift;
    my $tag=shift;
    my $attributes=$tag->{Attributes};

    if (defined $self->{currentinstance}) {
	$self->{currentinstance}->_start_tagged_data($tag->{Name},$tag->{Attributes});
    }

    
    if ($self->{in_companalresults} && !defined $self->{currentinstance} && 
	defined $CompAnalResultFactory::Factory{uc $tag->{Name}}) {
	$self->{currentinstance}=&{$CompAnalResultFactory::Factory{uc $tag->{Name}}}($tag->{Attributes});
    }

    if (lc $tag->{Name} eq 'companalresults') {
	$self->{in_companalresults}=1;
    }

    if (lc $tag->{Name} eq 'highlights') {
	$self->{currenthighlights}=[];
    }

    if (lc $tag->{Name} eq 'highlight') {
	$self->{currenthighlight}={begin => $attributes->{begin},
                                   end => $attributes->{end},
				   label => $attributes->{label}};
    }
}

sub end_element {
    my $self=shift;
    my $tag=shift;

    $self->{in_companalresults}=0
	if (lc $tag->{Name} eq 'companalresults');

    if (lc $tag->{Name} eq 'highlight') {
	push @{$self->{currenthighlights}},$self->{currenthighlight};
    }

    if (lc $tag->{Name} eq 'highlights' && defined $self->{currentinstance}) {
	$self->{currentinstance}->{highlights}=$self->{currenthighlights};
    }

    if (defined $self->{currentinstance}) {
	if (uc $tag->{Name} eq $self->{currentinstance}->id) {
	    push @{$self->{companalresult_instances}},$self->{currentinstance};
	    
	    $self->{currentinstance}=undef;
	} else {
	    $self->{currentinstance}->_end_tagged_data($tag->{Name},
						       $tag->{Attributes});
	}
    }
}


sub characters {
    my $self=shift;
    my $contents=shift;
    my $data=$contents->{Data};

    $self->{currentcharacterline}.=$data;

    if ($self->{currentcharacterline} =~ /\n/) {
	my ($before,$after)=split('\n',$self->{currentcharacterline});
	$self->{currentinstance}->_add_line($before)
	    if (length($before) && defined $self->{currentinstance});
	$self->{currentcharacterline}=$after;
    }


}

sub get_comp_anal_results {
    my $self=shift;

    return $self->{companalresult_instances};

}

package CompAnalResultFactory;

use strict;

use XML::Parser::PerlSAX;

BEGIN {
    my $subdir=$FindBin::Bin;
    %CompAnalResultFactory::Factory=();
    my @modules=<$subdir/CompAnalResult/*.pm>;

    foreach my $module (@modules) {
	eval {
	    require $module;
	}
    }
}

package CompAnalResultSource::FileResultSource;

use strict;

use CompAnalResultSource;

@CompAnalResultSource::FileResultSource::ISA=qw(CompAnalResultSource);


sub _load_results_from_file  {
    my $self=shift;
    my $filename=shift;
    if (-r $filename) {
	open XMLFILE,"<$filename";
	my $header=<XMLFILE>;
	close XMLFILE;
	if ($header =~ /^</) {
	    my $handler=new CompAnalResultHandler;
	    my $parser=new XML::Parser::PerlSAX();
	    $parser->parse(Source => {SystemId => $filename},
			   DocumentHandler => $handler,
			   ErrorHandler => $handler);
	    $self->{companalresults}=$handler->get_comp_anal_results;
	} else {
	    warn "CompAnalResult: $filename not in XML format.\n";
	}
    } else {
	warn "CompAnalResult: unable to load file $filename.\n";
    }   
}

sub new {
    my $class=shift;
    my $filename=shift;
    my $self= _new CompAnalResultSource;

    $self->{filename}=$filename;

    bless $self,$class;
    $self->_load_results_from_file($filename);

    return $self;
}

sub get_filename {
    my $self=shift;

    return $self->{filename};
}

1
