package CompAnalResultSource::GCContentSource;

use strict;

use Carp;

use Bio::Seq;
use Bio::Tools::SeqPattern;

use CompAnalResult::LinePlotResult;
use CompAnalResultSource;

@CompAnalResultSource::GCContentSource::ISA=qw(CompAnalResultSource);

sub _compute_gc_content {
    my $self=shift;
    my $seqobj=shift;
    my $windowsize=shift;
    my $step=shift;
    my $mapname=shift;

    my $sequence=$seqobj->seq();
    my $result=new CompAnalResult::LinePlotResult({'type' => 'separate',
						   'comment' => "GC Content of ".$mapname." w = $windowsize, s = $step",
						   'min' => 0,
						   'max' => 1,
						   'smoothing' => 0.01});
						  


    $result->{start}=1;
    $result->{end}=length($sequence);

    my $lineplot={};
    $lineplot->{start}=$windowsize/2;
    $lineplot->{frame}='all';
    $lineplot->{strand}='none';
    $lineplot->{step}=$step;
    $lineplot->{data}=[];
    $sequence=~ tr/CG/cg/;
    for (my $left=$windowsize/2; $left+$windowsize-1<length($sequence); $left+=$step) {
	my $window=substr $sequence,$left,$windowsize;
	my @gcs=($window =~ /[cg]/g);
	push @{$lineplot->{data}},(($#gcs+1.0)/(1.0*$windowsize));
    }

    push @{$result->{lineplots}},$lineplot;

    $lineplot={};
    $lineplot->{start}=1;
    $lineplot->{frame}='all';
    $lineplot->{strand}='none';
    $lineplot->{color}='blue';
    $lineplot->{step}=length($sequence)-1;
    $lineplot->{data}=[0.5,0.5];


    $result->{height}=11;

    push @{$result->{lineplots}},$lineplot;

  
  return $result;
}

sub new {
    my $class=shift;
    my $seqobj=shift;
    my $windowsize=shift;
    my $step=shift;
    my $mapname=shift;
    my $self=_new CompAnalResultSource;

    bless $self,$class;

    my $result=$self->_compute_gc_content($seqobj,$windowsize,$step,$mapname);

    push @{$self->{companalresults}},$result;

    return $self;
}

1;
