package CompAnalResultSource::GCSkewSource;

use strict;

use Carp;

use Bio::Seq;
use Bio::Tools::SeqPattern;

use CompAnalResult::LinePlotResult;
use CompAnalResultSource;

@CompAnalResultSource::GCSkewSource::ISA=qw(CompAnalResultSource);

sub _compute_gc_skew {
    my $self=shift;
    my $seqobj=shift;
    my $windowsize=shift;
    my $mapname=shift;

    my $sequence=$seqobj->seq();
    my $result=new CompAnalResult::LinePlotResult({'type' => 'separate',
						   'comment' => "GC skew of ".$mapname." w = $windowsize ",
						   'smoothing' => 0.01});
						  


    $result->{start}=1;
    $result->{min}=1;
    $result->{max}=-1;
    $result->{end}=length($sequence);

    my $lineplot={};
    $lineplot->{start}=$windowsize/2;
    $lineplot->{frame}='all';
    $lineplot->{strand}='none';
    $lineplot->{step}=$windowsize;
    $lineplot->{data}=[];
    $sequence=~ tr/CG/cg/;
    for (my $left=1; $left+$windowsize/2-1<length($sequence); $left+=$windowsize) {
	my $window=substr $sequence,$left,$windowsize;
	my @cs=($window =~ /c/g);
	my @gs=($window =~ /g/g);
	my $nc=$#cs+1;
	my $ng=$#gs+1;
	my $skew=0;
	
	$skew=($nc-$ng)/($nc+$ng)
	    if ($nc+$ng > 0);

	$result->{min}=$skew
	    if ($skew < $result->{min});

	$result->{max}=$skew
	    if ($skew > $result->{max});

	push @{$lineplot->{data}},$skew;
    }

    push @{$result->{lineplots}},$lineplot;

    $lineplot={};
    $lineplot->{start}=1;
    $lineplot->{frame}='all';
    $lineplot->{strand}='none';
    $lineplot->{color}='blue';
    $lineplot->{step}=length($sequence)-1;
    $lineplot->{data}=[0.0,0.0];

    push @{$result->{lineplots}},$lineplot;

    $result->{height}=11;

    return $result;
}

sub new {
    my $class=shift;
    my $seqobj=shift;
    my $windowsize=shift;
    my $mapname=shift;
    my $self=_new CompAnalResultSource;

    bless $self,$class;

    my $result=$self->_compute_gc_skew($seqobj,$windowsize,$mapname);

    push @{$self->{companalresults}},$result;

    return $self;
}

1;
