package CompAnalResultSource::MosaicResultSource::MosaicCompAnalResult;
 
use strict;
use Benchmark;

use CompAnalResult::BoxPlotResult;
use CompAnalResult::HistogramResult;
use CompAnalResult::LinkPlotResult;
use CompAnalResultSource;
use PaintDevice;


my $ColorBackbone = 'red';
my $ColorLoop = 'blue';
my $ColorLinkBackbone = 'magenta';
my $ColorLinkLoop = 'cyan';
my $ColorLoop1 = 'cyan';
my $ColorLoop2 = 'oldblue';
my $ColorLoop3 = 'blue';
my $ColorBackbone1 = 'yellow';
my $ColorBackbone2 = 'orange';
my $ColorBackbone3 = 'red';
my $ColorResult = 'white';
my $Limite1 = 6;
my $Limite2 = 20;

@CompAnalResultSource::MosaicResultSource::MosaicCompAnalResult::ISA=qw(CompAnalResultSource);

sub  new {
    my $class = shift;
    my $totalresult = shift;
    
    my $self= _new CompAnalResultSource @_;

    $self->{valign}='above';
    
    bless $self,$class;
    
    my $companalResult = undef;

    $totalresult->{critere} = "";

    #Retrieve limit
    $Limite1 = $totalresult->{limit1};
    $Limite2 = $totalresult->{limit2};


    #Select loop and backbone
   if ((  $totalresult->{selectedloop} == 1 ) && (  $totalresult->{selectedbackbone} == 1 )){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Backbone and Loop from ".$totalresult->{strain}." alignment ".$totalresult->{aliselect}." : ".$totalresult->{criteriaselect}
	}; 
	push @{$companalResult}, $self->_create_backbone_loops_boxPlot($companalResultsAttributes,$totalresult);
    }

   elsif (  $totalresult->{selectedloop} == 1 ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Loop from ".$totalresult->{strain}." alignment ".$totalresult->{aliselect}." : ".$totalresult->{criteriaselect}
	}; 
	push @{$companalResult}, $self->_create_loops_boxPlot($companalResultsAttributes,$totalresult);
    }

    elsif (  $totalresult->{selectedbackbone} == 1 ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Backbone from ".$totalresult->{strain}." alignment ".$totalresult->{aliselect}." : ".$totalresult->{criteriaselect}
	}; 
	push @{$companalResult}, $self->_create_backbone_boxPlot($companalResultsAttributes,$totalresult);
    }



    if (  $totalresult->{selectedlink} == 1 ){

	$totalresult->{critere} = "";
	if (  $totalresult->{selectedannot} == 1 ){
	    $totalresult->{critere} = " AND back_num IN (SELECT back_num FROM backbone as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND (s.coding_position <> 'non codant' OR s.feature_position <> 'sans feature'))";
	}
	if (($totalresult->{size1} ne '') &&  ($totalresult->{size2} ne '')) {
	    $totalresult->{critere} .= " AND back_num IN (SELECT back_num FROM backbone as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND length BETWEEN $totalresult->{size1} AND $totalresult->{size2})";
	}
	elsif (($totalresult->{size1} ne '') &&  ($totalresult->{size2} eq '')) {
	    $totalresult->{critere} .= " AND back_num IN (SELECT back_num FROM backbone as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND length >= $totalresult->{size1})";
	}
	if (($totalresult->{size1} eq '') &&  ($totalresult->{size2} ne '')) {
	    $totalresult->{critere} .= " AND back_num IN (SELECT back_num FROM backbone as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND length <= $totalresult->{size2})";
	}
	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Link of backbone for alignment ".$totalresult->{aliselect}." : ".$totalresult->{criteriaselect}
	}; 
	push @{$companalResult}, $self->_create_linkbackbone_linkPlot($companalResultsAttributes,$totalresult);

    }

    if (  $totalresult->{selectedlinkloop} == 1 ){

	$totalresult->{critere} = "";
	if (  $totalresult->{selectedannot} == 1 ){
	    $totalresult->{critere} = " AND loop_num IN (SELECT loop_num FROM loop as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND (s.coding_position <> 'non codant' OR s.feature_position <> 'sans feature'))";
	}
	if (($totalresult->{size1} ne '') &&  ($totalresult->{size2} ne '')) {
	    $totalresult->{critere} .= " AND loop_num IN (SELECT loop_num FROM Loop as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND length BETWEEN $totalresult->{size1} AND $totalresult->{size2})";
	}
	elsif (($totalresult->{size1} ne '') &&  ($totalresult->{size2} eq '')) {
	    $totalresult->{critere} .= " AND loop_num IN (SELECT loop_num FROM Loop as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND length >= $totalresult->{size1})";
	}
	if (($totalresult->{size1} eq '') &&  ($totalresult->{size2} ne '')) {
	    $totalresult->{critere} .= " AND loop_num IN (SELECT loop_num FROM Loop as s INNER JOIN aligned_genome as g ON s.ig_alignedgenome = g.ig_alignedgenome WHERE g.id_comparison = $totalresult->{id_comparison} AND g.ident_pct = $totalresult->{pctidentselect} AND g.min_length_loop = $totalresult->{limbouselect} AND g.min_length_back = $totalresult->{limbacselect} AND length <= $totalresult->{size2})";
	}
	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Link of loop for alignment ".$totalresult->{aliselect}." : ".$totalresult->{criteriaselect}
	}; 
	push @{$companalResult}, $self->_create_linkloop_linkPlot($companalResultsAttributes,$totalresult);

    }

    if (  $totalresult->{selectedarea} == 1 ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Area ".$totalresult->{regionsbyid}->{$totalresult->{id_genomeregion}}->{region_type}." : ".$totalresult->{regionsbyid}->{$totalresult->{id_genomeregion}}->{critere}." from ".$totalresult->{strain}." alignment ".$totalresult->{aliselect}." : ".$totalresult->{criteriaselect}
	}; 
	push @{$companalResult}, $self->_create_area_boxPlot($companalResultsAttributes,$totalresult);
    }

    foreach my $result (@{$companalResult}) {
	push @{$self->{companalresults}},$result;
    }

    return $self;
}

sub _create_linkloop_linkPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $textbuffer='';

    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getGenomesForAlignment($totalresult);
    my $rv=$sth->execute();

    my $linkplot=new CompAnalResult::LinkPlotResult($companalResultsAttributes);
    $linkplot->{height}=3;
    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Genome1\tStart\tLong\tGenome2\tStart\tLong\n";

    my $nbCol  = 3;
    my $nb = 0;
    my @ListeBackbone = ();
    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $sthd = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getLoopOfGenomesForAlignment($rowhash->{ig_alignedgenome}, $totalresult->{critere});
	my $rvd=$sthd->execute();
	while (my $rowhashd=$sthd->fetchrow_hashref()) {
	    my $numsquelette = $rowhashd->{loop_num};
	    $ListeBackbone[$numsquelette][0 + $nb] = $rowhashd->{begin_position};
	    $ListeBackbone[$numsquelette][1 + $nb] = $rowhashd->{length};
	    $ListeBackbone[$numsquelette][2 + $nb] = $rowhashd->{id_loop};
	}
	$nb += $nbCol;
    }
    for my $nbDonnees(0..$#ListeBackbone) {
	if (($ListeBackbone[$nbDonnees][0] ne '') && ($ListeBackbone[$nbDonnees][0 + $nbCol] ne '')) {
	    my($nt1) = -1;
	    my($nt2) = -1;
	    my($lg1) = $ListeBackbone[$nbDonnees][1];
	    my($lg2) = $ListeBackbone[$nbDonnees][1 + $nbCol];
	    my($lg) = $lg1;
	    if ($lg < $lg2) {$lg = $lg2;}
	    $begin=$ListeBackbone[$nbDonnees][0]
		if ($begin>$ListeBackbone[$nbDonnees][0]);
	    $end=($ListeBackbone[$nbDonnees][0] + $ListeBackbone[$nbDonnees][1])
		if ($end<($ListeBackbone[$nbDonnees][0] + $ListeBackbone[$nbDonnees][1]));

	    $textbuffer.=$ListeBackbone[$nbDonnees][2]."\t".$ListeBackbone[$nbDonnees][0]."\t".$ListeBackbone[$nbDonnees][1]."\t".
		$ListeBackbone[$nbDonnees][2 + $nbCol]."\t".$ListeBackbone[$nbDonnees][0 + $nbCol]."\t".$ListeBackbone[$nbDonnees][1 + $nbCol]."\n";

	    for my $nb(1..$lg) {
		if ($nt1 + 1 <= $ListeBackbone[$nbDonnees][1]) {$nt1++;}
		if ($nt2 + 1 <= $ListeBackbone[$nbDonnees][1 + $nbCol]) {$nt2++;}

		#Suivant la taille des boucles, on prend une couleur diffrente
		if ($ListeBackbone[$nbDonnees][1] < $Limite1) {
		    $ColorLinkLoop = $ColorLoop1;
		}
		elsif (($ListeBackbone[$nbDonnees][1] >= $Limite1) && ($ListeBackbone[$nbDonnees][1] < $Limite2)) {
		    $ColorLinkLoop = $ColorLoop2;
		}
		if ($ListeBackbone[$nbDonnees][1] >= $Limite2) {
		    $ColorLinkLoop = $ColorLoop3;
		}
		push @{$linkplot->{links}},{from => $ListeBackbone[$nbDonnees][0] + $nt1,
					    to => $ListeBackbone[$nbDonnees][0 + $nbCol] + $nt2,
					    color => $ColorLinkLoop,
					};
	    }
	}
    }
	
    $linkplot->{start}=$begin;
    $linkplot->{end}=$end;
    $self->{logwindow}->add_text($textbuffer);

    return $linkplot;
}

sub _create_linkbackbone_linkPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $textbuffer='';

    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getGenomesForAlignment($totalresult);
    my $rv=$sth->execute();

    my $linkplot=new CompAnalResult::LinkPlotResult($companalResultsAttributes);
    $linkplot->{height}=3;
    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Genome1\tStart\tLong\tGenome2\tStart\tLong\n";

    my $nbCol  = 3;
    my $nb = 0;
    my @ListeBackbone = ();
    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $sthd = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getBackboneOfGenomesForAlignment($rowhash->{ig_alignedgenome}, $totalresult->{critere});
	my $rvd=$sthd->execute();
	while (my $rowhashd=$sthd->fetchrow_hashref()) {
	    my $numsquelette = $rowhashd->{back_num};
	    $ListeBackbone[$numsquelette][0 + $nb] = $rowhashd->{begin_position};
	    $ListeBackbone[$numsquelette][1 + $nb] = $rowhashd->{length};
	    $ListeBackbone[$numsquelette][2 + $nb] = $rowhashd->{id_backbone};
	}
	$nb += $nbCol;
    }
    for my $nbDonnees(0..$#ListeBackbone) {
	if (($ListeBackbone[$nbDonnees][0] ne '') && ($ListeBackbone[$nbDonnees][0 + $nbCol] ne '')) {
	    my($nt1) = -1;
	    my($nt2) = -1;
	    my($lg1) = $ListeBackbone[$nbDonnees][1];
	    my($lg2) = $ListeBackbone[$nbDonnees][1 + $nbCol];
	    my($lg) = $lg1;
	    if ($lg < $lg2) {$lg = $lg2;}
	    $begin=$ListeBackbone[$nbDonnees][0]
		if ($begin>$ListeBackbone[$nbDonnees][0]);
	    $end=($ListeBackbone[$nbDonnees][0] + $ListeBackbone[$nbDonnees][1])
		if ($end<($ListeBackbone[$nbDonnees][0] + $ListeBackbone[$nbDonnees][1]));

	    $textbuffer.=$ListeBackbone[$nbDonnees][2]."\t".$ListeBackbone[$nbDonnees][0]."\t".$ListeBackbone[$nbDonnees][1]."\t".
		$ListeBackbone[$nbDonnees][2 + $nbCol]."\t".$ListeBackbone[$nbDonnees][0 + $nbCol]."\t".$ListeBackbone[$nbDonnees][1 + $nbCol]."\n";

	    for my $nb(1..$lg) {
		if ($nt1 + 1 <= $ListeBackbone[$nbDonnees][1]) {$nt1++;}
		if ($nt2 + 1 <= $ListeBackbone[$nbDonnees][1 + $nbCol]) {$nt2++;}
		#Suivant la taille du squelette, on prend une couleur diffrente
		if ($ListeBackbone[$nbDonnees][1] < $Limite1) {
		    $ColorLinkBackbone = $ColorBackbone1;
		}
		elsif (($ListeBackbone[$nbDonnees][1] >= $Limite1) && ($ListeBackbone[$nbDonnees][1] < $Limite2)) {
		    $ColorLinkBackbone = $ColorBackbone2;
		}
		if ($ListeBackbone[$nbDonnees][1] >= $Limite2) {
		    $ColorLinkBackbone = $ColorBackbone3;
		}
		push @{$linkplot->{links}},{from => $ListeBackbone[$nbDonnees][0] + $nt1,
					    to => $ListeBackbone[$nbDonnees][0 + $nbCol] + $nt2,
					    color => $ColorLinkBackbone,
					};
	    }
	}
    }
	
    $linkplot->{start}=$begin;
    $linkplot->{end}=$end;
    $self->{logwindow}->add_text($textbuffer);

    return $linkplot;
}

sub _create_loops_boxPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $textbuffer='';
    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getLoopsByGenomeForAlignment($totalresult);
    my $rv=$sth->execute();

    my $boxplot=new CompAnalResult::BoxPlotResult($companalResultsAttributes);

    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Loop\tStart\tStop\tLong\n";

    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $start=$rowhash->{begin_position};
	my $stop=$rowhash->{end_position};
	my $long=$rowhash->{length};
        $begin=$start
	    if ($begin>$start);
	$end=$stop
	    if ($end<$stop);
	
	$textbuffer.=$rowhash->{id_loop}."\t".$start."\t".$stop."\t".$long."\n";
	
	my $valign='above';

	#Suivant la taille des boucles, on prend une couleur diffrente
	if (($stop - $start) < $Limite1) {
	    $ColorLoop = $ColorLoop1;
	}
	elsif ((($stop - $start) >= $Limite1) && (($stop - $start) < $Limite2)) {
	    $ColorLoop = $ColorLoop2;
	}
	if (($stop - $start) >= $Limite2) {
	    $ColorLoop = $ColorLoop3;
	}
	push @{$boxplot->{boxes}},{begin => $start,
				   end => $stop,
				   color => $ColorLoop,
				   filled =>  1,
				   thickness=> 0.4,
				   strand => 1,
			           label=> $rowhash->{id_loop},
				   valign => $valign};
    }

    $boxplot->{start}=$begin;
    $boxplot->{end}=$end;
    $self->{logwindow}->add_text($textbuffer);
    return $boxplot;
}
sub _create_backbone_boxPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $textbuffer='';
    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getBackboneByGenomeForAlignment($totalresult);
    my $rv=$sth->execute();

    my $boxplot=new CompAnalResult::BoxPlotResult($companalResultsAttributes);

    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Backbone\tStart\tStop\tLong\n";

    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $start=$rowhash->{begin_position};
	my $stop=$rowhash->{end_position};
	my $long=$rowhash->{length};
        $begin=$start
	    if ($begin>$start);
	$end=$stop
	    if ($end<$stop);
	
	$textbuffer.=$rowhash->{id_backbone}."\t".$start."\t".$stop."\t".$long."\n";

	my $valign='above';

	#Suivant la taille du squelette, on prend une couleur diffrente
	if (($stop - $start) < $Limite1) {
	    $ColorBackbone = $ColorBackbone1;
	}
	elsif ((($stop - $start) >= $Limite1) && (($stop - $start) < $Limite2)) {
	    $ColorBackbone = $ColorBackbone2;
	}
	if (($stop - $start) >= $Limite2) {
	    $ColorBackbone = $ColorBackbone3;
	}
	push @{$boxplot->{boxes}},{begin => $start,
				   end => $stop,
				   color => $ColorBackbone,
				   filled =>  1,
				   thickness=> 0.4,
				   strand => 1,
			           label=> $rowhash->{id_backbone},
				   valign => $valign};
    }

    $boxplot->{start}=$begin;
    $boxplot->{end}=$end;
    $self->{logwindow}->add_text($textbuffer);
    return $boxplot;
}


sub _create_backbone_loops_boxPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $textbuffer='';
    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getBackboneLoopsByGenomeForAlignment($totalresult);
    my $rv=$sth->execute();

    my $boxplot=new CompAnalResult::BoxPlotResult($companalResultsAttributes);

    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Backbone or Loop\tStart\tStop\tLong\n";

    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $start=$rowhash->{begin_position};
	my $stop=$rowhash->{end_position};
	my $long=$rowhash->{length};
        $begin=$start
	    if ($begin>$start);
	$end=$stop
	    if ($end<$stop);
	
	$textbuffer.=$rowhash->{id_result}."\t".$start."\t".$stop."\t".$long."\n";
	
	my $valign='above';

	#Suivant la taille des boucles ou squelette, on prend une couleur diffrente
	if ($rowhash->{type} eq 'L'){
	    if (($stop - $start) < $Limite1) {
		$ColorResult = $ColorLoop1;
	    }
	    elsif ((($stop - $start) >= $Limite1) && (($stop - $start) < $Limite2)) {
		$ColorResult = $ColorLoop2;
	    }
	    if (($stop - $start) >= $Limite2) {
		$ColorResult = $ColorLoop3;
	    }
	}
	if ($rowhash->{type} eq 'B'){
	    if (($stop - $start) < $Limite1) {
		$ColorResult = $ColorBackbone1;
	    }
	    elsif ((($stop - $start) >= $Limite1) && (($stop - $start) < $Limite2)) {
		$ColorResult = $ColorBackbone2;
	    }
	    if (($stop - $start) >= $Limite2) {
		$ColorResult = $ColorBackbone3;
	    }
	}
	push @{$boxplot->{boxes}},{begin => $start,
				   end => $stop,
				   color => $ColorResult,
				   filled =>  1,
				   thickness=> 0.4,
				   strand => 1,
			           label=> $rowhash->{id_result},
				   valign => $valign};
    }

    $boxplot->{start}=$begin;
    $boxplot->{end}=$end;
    $self->{logwindow}->add_text($textbuffer);
    return $boxplot;
}

sub _create_area_boxPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $textbuffer='';
    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getAreaByGenomeForAlignment($totalresult);
    my $rv=$sth->execute();

    my $boxplot=new CompAnalResult::BoxPlotResult($companalResultsAttributes);

    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Area\tStart\tStop\tLong\n";

    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $start=$rowhash->{begin_position};
	my $stop=$rowhash->{end_position};
	my $long=$rowhash->{length};
        $begin=$start
	    if ($begin>$start);
	$end=$stop
	    if ($end<$stop);
	
	$textbuffer.=$rowhash->{id_region}."\t".$start."\t".$stop."\t".$long."\n";
	
	my $valign='above';

	push @{$boxplot->{boxes}},{begin => $start,
				   end => $stop,
				   color => $ColorBackbone3,
				   filled =>  1,
				   thickness=> 0.4,
				   strand => 1,
			           label=> $rowhash->{id_region},
				   valign => $valign};
    }

    $boxplot->{start}=$begin;
    $boxplot->{end}=$end;
    $self->{logwindow}->add_text($textbuffer);
    return $boxplot;
}

sub valign{
   my $self= shift;
   
    if(my $valign=shift){
	$self->{valign}=$valign;
    }
    return $self->{valign};
}
1;
