package CompAnalResultSource::MosaicResultSource::MosaicResultHandler;

use strict;
use DBI;
use DBD::Pg;

use CompAnalResultSource;

my $mosaicdbh=undef;

%MosaicResultHandler::resultdescriptions=();

sub set_preferences {
    my $mugen=$PreferencesHandler::Preferences->getDocumentElement();
    my @nodes=$mugen->getElementsByTagName('resultdatasources');
    my $rds=shift @nodes;
    my @nodes=$rds->getElementsByTagName('mosaicresults',0);
    if (scalar(@nodes)==0) {
	my $doctype=$PreferencesHandler::Preferences->getDoctype();
	$doctype->addElementDecl('mosaicresults','EMPTY');
	$doctype->addAttDef("mosaicresults","host","CDATA","#REQUIRED");
	$doctype->addAttDef("mosaicresults","dbname","CDATA","#REQUIRED");
	$doctype->addAttDef("mosaicresults","user","CDATA","#REQUIRED");
	$doctype->addAttDef("mosaicresults","passwd","CDATA","#REQUIRED");
	$doctype->addAttDef("mosaicresults","enabled","(yes|no)",'"no"');
	my $mosaic=$PreferencesHandler::Preferences->createElement('mosaicresults');
	$mosaic->setAttribute("host","127.0.0.1");
	$mosaic->setAttribute("dbname","unknown");
	$mosaic->setAttribute("user","unknown");
	$mosaic->setAttribute("passwd","");
	$mosaic->setAttribute("enabled","no");
	$rds->appendChild($mosaic);
    }
}


BEGIN {
    PreferencesHandler::register_listener(\&set_preferences);
}

sub init {

    my $res=0;

    if (!$mosaicdbh) {
	my @nodes=$PreferencesHandler::Preferences->getElementsByTagName('mosaicresults');
	my $mosaic=shift @nodes;
	if ($mosaic) {
	    my $host=$mosaic->getAttribute("host");
	    my $dbname=$mosaic->getAttribute("dbname");
	    my $user=$mosaic->getAttribute("user");
	    my $passwd=$mosaic->getAttribute("passwd");
	    my $enabled=$mosaic->getAttribute("enabled");
	    $mosaicdbh=DBI->connect("dbi:Pg:host=$host;dbname=$dbname",$user,$passwd)
		if ($enabled eq 'yes');
	}
	
    }

    $res=1
	if (defined $mosaicdbh);
	

    return $res;
}

sub getAllLogiciels{
    my $self=shift;
    init unless $mosaicdbh;

    my @ListeLogiciels = ();
    my $sth=$mosaicdbh->prepare("select name, id_software from software");
    my $rv=$sth->execute();
    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $Logiciel = {name => $rowhash->{name},
		    id_software => $rowhash->{id_software}};
	push @ListeLogiciels, new Logiciel($Logiciel);
    }
    my $logiciels=\@ListeLogiciels;
    return $logiciels;
} 

sub getAlignmentsOfLogiciels {
    my $self=shift;
    my $logiciels=shift;
    init unless $mosaicdbh;

    my @ListeAlignments=();
    foreach my $log (@$logiciels) {
       my $sth=$mosaicdbh->prepare("select distinct c.id_comparison, c.description, v.id_software
                           from comparison as c inner join (parametrization as p inner join val_parameter as v on p.id_valparameter = v.id_valparameter) on c.id_comparison = p.id_comparison inner join aligned_genome as ga on c.id_comparison = ga.id_comparison
                           where v.id_software = $log->{id_software}");
       my $rv=$sth->execute();
       while (my $rowhash=$sth->fetchrow_hashref()) {
	   my $Alignment = {description => $rowhash->{description},
			id_comparison => $rowhash->{id_comparison},
			id_software => $rowhash->{id_software}};
	   push @ListeAlignments, new Alignment($Alignment);
       }

    }
    my $alignments=\@ListeAlignments;
    return $alignments;
}

sub getCriteriaOfAlignments {
    my $self=shift;
    my $alignments=shift;
    init unless $mosaicdbh;
    my $i = 0;

    my @ListeCriteria=();
    foreach my $ali (@$alignments) {
       my $sth=$mosaicdbh->prepare("select distinct a.ident_pct, a.min_length_loop, a.min_length_back, a.id_comparison, v.id_software
                           from aligned_genome as a inner join (parametrization as p inner join val_parameter as v on p.id_valparameter = v.id_valparameter) on a.id_comparison = p.id_comparison 
                           where a.id_comparison = $ali->{id_comparison}");
       my $rv=$sth->execute();
       while (my $rowhash=$sth->fetchrow_hashref()) {
	   my $Criterion = {label => "$rowhash->{ident_pct} %ident - $rowhash->{min_length_loop} limit loop - $rowhash->{min_length_back} limit backbone",
	            ident_pct => $rowhash->{ident_pct},
		    min_length_loop => $rowhash->{min_length_loop},
		    min_length_back => $rowhash->{min_length_back},
		    critereid => $i,
		    id_comparison => $rowhash->{id_comparison},
		    id_software => $rowhash->{id_software}};
	   push @ListeCriteria, new Criterion($Criterion);
	   $i++;
       }
    }
    my $criteria=\@ListeCriteria;
    return $criteria;
}

sub getGenomesOfCriteria {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

    my @ListeGenomes=();
    foreach my $criterion (@$criteria) {
       my $sth=$mosaicdbh->prepare("select distinct ga.id_alignedgenome, g.id_genome, ga.id_comparison, g.strain, g.accession, a.query
                           from genome as g inner join (aligned_genome as ga inner join alignment as a on ga.id_comparison = a.id_comparison and ga.id_genome = a.id_genome) on g.id_genome = ga.id_genome
                           where ga.id_comparison = $criterion->{id_comparison} AND ga.ident_pct = $criterion->{ident_pct} AND ga.min_length_loop = $criterion->{min_length_loop} AND ga.min_length_back = $criterion->{min_length_back}");
       my $rv=$sth->execute();
       while (my $rowhash=$sth->fetchrow_hashref()) {
	   my $Genome = {id_genome => $rowhash->{id_genome},
		  strain => $rowhash->{strain},
		  accession => $rowhash->{accession},
		  query => $rowhash->{query},
		  id_alignedgenome => $rowhash->{id_alignedgenome},
		  critereid => $criterion->{critereid},
		  id_software => $criterion->{id_software},
		  id_comparison => $rowhash->{id_comparison}};
	   push @ListeGenomes, new Genome($Genome);
       }
    }
    my $genomes=\@ListeGenomes;
    return $genomes;
}

sub getRegionsOfAlignment {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

    my @ListeRegions=();
    my $sth=$mosaicdbh->prepare("select distinct id_genomeregion, region_type, raw_back, min_length_back, max_length_back, raw_loop, min_length_loop, max_length_loop, min_length_region 
                           from genome_region 
                           where id_alignedgenome = ".$criteria->{id_alignedgenome}."");
    my $rv=$sth->execute();
    while (my $rowhash=$sth->fetchrow_hashref()) {
	my $critere = "";
	if ($rowhash->{raw_back} == 1) {
	    $critere = "all backbone - ";
	}
	else {
	    if ($rowhash->{min_length_back} ne '') {
		$critere = "backbone >= ".$rowhash->{min_length_back}." ";
	    }
	    if (($rowhash->{max_length_back} ne '') && ($rowhash->{max_length_back} != 0)) {
		$critere .= "backbone <= ".$rowhash->{max_length_back}." ";
	    }
	    $critere .= "- ";
	}
	if ($rowhash->{raw_loop} == 1) {
	    $critere .= "all loops - ";
	}
	else {
	    if ($rowhash->{min_length_loop} ne '') {
		$critere .= "loops >= ".$rowhash->{min_length_loop}." ";
	    }
	    if (($rowhash->{max_length_loop} ne '') && ($rowhash->{max_length_loop} != 0)) {
		$critere .= "loops <= ".$rowhash->{max_length_loop}." ";
	    }
	    $critere .= "- ";
	}
	if ($rowhash->{min_length_region} ne '') {
	    $critere .= "area >= ".$rowhash->{min_length_region};
	}
	
	my $Region = {id_genomeregion => $rowhash->{id_genomeregion},
		      id_alignedgenome => $criteria->{id_alignedgenome},
		      region_type => $rowhash->{region_type},
		      critere => $critere};
	   push @ListeRegions, new Region($Region);
    }
    my $regions=\@ListeRegions;
    return $regions;
}

sub getLoopsByGenomeForAlignment {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

 my $critere = "";
    if ($criteria->{selectedannot} == 1) {
	$critere = " AND loop_num IN ( SELECT loop_num FROM loop as s INNER JOIN aligned_genome as g ON s.id_alignedgenome = g.id_alignedgenome WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect} AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND (s.coding_position <> 'non codant' OR s.feature_position <> 'sans feature'))";
    }
    my $criterelong = "";
    if (($criteria->{size1} ne '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length BETWEEN $criteria->{size1} AND $criteria->{size2}";
    }
    elsif (($criteria->{size1} ne '') && ($criteria->{size2} eq '')) {
	$criterelong = " AND length >= $criteria->{size1}";
    }
    elsif (($criteria->{size1} eq '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length <= $criteria->{size2}";
    }
    my $sth=$mosaicdbh->prepare("SELECT begin_position, end_position, length, id_loop 
                        FROM Loop WHERE id_alignedgenome = $criteria->{id_alignedgenome} AND empty_loop = 'false' $critere $criterelong ORDER BY begin_position, end_position");
    return $sth;
}

sub getBackboneByGenomeForAlignment {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

    my $critere = "";
    if ($criteria->{selectedannot} == 1) {
	$critere = " AND back_num IN ( SELECT back_num FROM backbone as s INNER JOIN aligned_genome as g ON s.id_alignedgenome = g.id_alignedgenome WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect} AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND (s.coding_position <> 'non codant' OR s.feature_position <> 'sans feature'))";
    }
    my $criterelong = "";
    if (($criteria->{size1} ne '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length BETWEEN $criteria->{size1} AND $criteria->{size2}";
    }
    elsif (($criteria->{size1} ne '') && ($criteria->{size2} eq '')) {
	$criterelong = " AND length >= $criteria->{size1}";
    }
    elsif (($criteria->{size1} eq '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length <= $criteria->{size2}";
    }
    my $sth=$mosaicdbh->prepare("SELECT begin_position, end_position, length, id_backbone FROM Backbone WHERE id_alignedgenome = $criteria->{id_alignedgenome} $critere $criterelong ORDER BY begin_position, end_position");
    return $sth;
}

sub getBackboneLoopsByGenomeForAlignment {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

    my $critereB = "";
    my $critereL = "";
    if ($criteria->{selectedannot} == 1) {
	$critereB = " AND back_num IN ( SELECT back_num FROM backbone as s INNER JOIN aligned_genome as g ON s.id_alignedgenome = g.id_alignedgenome WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect} AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND (s.coding_position <> 'non codant' OR s.feature_position <> 'sans feature'))";
	$critereL = " AND loop_num IN ( SELECT loop_num FROM loop as s INNER JOIN aligned_genome as g ON s.id_alignedgenome = g.id_alignedgenome WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect} AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND (s.coding_position <> 'non codant' OR s.feature_position <> 'sans feature'))";
    }
    my $criterelong = "";
    if (($criteria->{size1} ne '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length BETWEEN $criteria->{size1} AND $criteria->{size2}";
    }
    elsif (($criteria->{size1} ne '') && ($criteria->{size2} eq '')) {
	$criterelong = " AND length >= $criteria->{size1}";
    }
    elsif (($criteria->{size1} eq '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length <= $criteria->{size2}";
    }
    my $sth=$mosaicdbh->prepare("(SELECT begin_position, end_position, length, id_backbone as id_result, 'B' as type FROM Backbone WHERE id_alignedgenome = $criteria->{id_alignedgenome} $critereB) UNION (SELECT begin_position, end_position, length, id_loop as id_result, 'L' as type FROM Loop WHERE id_alignedgenome = $criteria->{id_alignedgenome} AND empty_loop = 'false' $critereL $criterelong) ORDER BY begin_position, end_position");
    return $sth;
}

sub getAreaByGenomeForAlignment {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

    my $critere = "";
    if ($criteria->{selectedannot} == 1) {
	$critere = " AND (coding_position <> 'non codant' OR feature_position <> 'sans feature')";
    }
    my $criterelong = "";
    if (($criteria->{size1} ne '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length BETWEEN $criteria->{size1} AND $criteria->{size2}";
    }
    elsif (($criteria->{size1} ne '') && ($criteria->{size2} eq '')) {
	$criterelong = " AND length >= $criteria->{size1}";
    }
    elsif (($criteria->{size1} eq '') && ($criteria->{size2} ne '')) {
	$criterelong = " AND length <= $criteria->{size2}";
    }
    my $sth=$mosaicdbh->prepare("SELECT begin_position, end_position, length, id_region FROM Region WHERE id_genomeregion = $criteria->{id_genomeregion} $critere $criterelong ORDER BY begin_position, end_position");
    return $sth;
}

sub getGenomesForAlignment {
    my $self=shift;
    my $criteria=shift;
    init unless $mosaicdbh;

#    #retrieve number of aligned genomes
#    my $sth = CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getBackboneByGenomeForAlignment($totalresult);
#    my $rv=$sth->execute();

#    my $boxplot=new CompAnalResult::BoxPlotResult($companalResultsAttributes);

#    my $begin=1e10;
#    my $end=-1;
#    $textbuffer.=scalar(localtime)."\n";
#    $textbuffer.=$companalResultsAttributes->{comment}."\n";
#    $textbuffer.="Backbone\tStart\tStop\tLong\n";

#    while (my $rowhash=$sth->fetchrow_hashref()) {
    
    my $sth=$mosaicdbh->prepare("(SELECT g.id_alignedgenome, '1' as ordreG
                       FROM aligned_genome as g inner join alignment as a on g.id_comparison = a.id_comparison and g.id_genome = a.id_genome
                       WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect}
                       AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND a.id_genome = $criteria->{id_genome})
                    UNION
                       (SELECT g.id_alignedgenome, '2' as ordreG
                       FROM aligned_genome as g inner join alignment as a on g.id_comparison = a.id_comparison and g.id_genome = a.id_genome
                       WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect}
                       AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND query = 
                       (SELECT CASE WHEN query = (SELECT count(*) - 1 FROM Alignment WHERE id_comparison = $criteria->{id_comparison}) THEN '0' ELSE query + 1 END FROM aligned_genome as g inner join alignment as a on g.id_comparison = a.id_comparison and g.id_genome = a.id_genome
                       WHERE g.id_comparison = $criteria->{id_comparison} AND g.ident_pct = $criteria->{pctidentselect}
                       AND g.min_length_loop = $criteria->{limbouselect} AND g.min_length_back = $criteria->{limbacselect} AND a.id_genome = $criteria->{id_genome})) ORDER BY OrdreG"
				);
    return $sth;
}

sub getBackboneOfGenomesForAlignment {
    my $self=shift;
    my $criteria=shift;
    my $annot=shift;
    init unless $mosaicdbh;

    my $sth=$mosaicdbh->prepare("SELECT begin_position, length, id_backbone, back_num FROM Backbone WHERE id_alignedgenome = $criteria $annot ORDER BY back_num");
    return $sth;
}

sub getLoopOfGenomesForAlignment {
    my $self=shift;
    my $criteria=shift;
    my $annot=shift;
    init unless $mosaicdbh;

    my $sth=$mosaicdbh->prepare("SELECT begin_position, length, id_loop, loop_num FROM Loop WHERE id_alignedgenome = $criteria $annot ORDER BY loop_num");
    return $sth;
}

sub getBackboneLoopsOfGenomesForAlignment {
    my $self=shift;
    my $criteria=shift;
    my $critereB=shift;
    my $critereL=shift;
    init unless $mosaicdbh;

    my $sth=$mosaicdbh->prepare("(SELECT begin_position, length, id_backbone as id_result, back_num as num_result, 'B' as type FROM Backbone WHERE id_alignedgenome = $criteria $critereB) UNION (SELECT begin_position, length, id_loop as id_result, loop_num as num_result, 'L' as type FROM Loop WHERE id_alignedgenome = $criteria $critereL) ORDER BY type,num_result");
    return $sth;
}


package Logiciel;

sub  new {
    my $class=shift;
    my $logiciel=shift;

    my $self={
	name=>$logiciel->{name},
	id_software=>$logiciel->{id_software}
	};
    bless $self,$class;
    return $self ;
}

package Alignment;

sub  new {
    my $class=shift;
    my $alignment=shift;

    my $self={
	description=>$alignment->{description},
	id_comparison=>$alignment->{id_comparison},
	id_software=>$alignment->{id_software}
	};
    bless $self,$class;
    return $self ;
}

package Criterion;

sub  new {
    my $class=shift;
    my $criterion=shift;

    my $self={
	label => $criterion->{label},
	ident_pct => $criterion->{ident_pct},
	min_length_loop => $criterion->{min_length_loop},
	min_length_back => $criterion->{min_length_back},
	critereid => $criterion->{critereid},
	id_software => $criterion->{id_software},
	id_comparison => $criterion->{id_comparison}
	};
    bless $self,$class;
    return $self ;
}
package Genome;

sub  new {
    my $class=shift;
    my $genome=shift;

    my $self={
	id_genome => $genome->{id_genome},
	strain => $genome->{strain},
	accession => $genome->{accession},
	query => $genome->{query},
	id_alignedgenome => $genome->{id_alignedgenome},
	critereid => $genome->{critereid},
	id_software => $genome->{id_software},
	id_comparison => $genome->{id_comparison}
	};
    bless $self,$class;
    return $self ;
}

package Region;

sub  new {
    my $class=shift;
    my $region=shift;

    my $self={
	id_genomeregion => $region->{id_genomeregion},
	id_alignedgenome => $region->{id_alignedgenome},
	region_type => $region->{region_type},
	critere => $region->{critere},
	};
    bless $self,$class;
    return $self ;
}



1;


