package CompAnalResultSource::OrigamiResultSource;
 
use strict;
use Benchmark;

use CompAnalResult::BoxPlotResult;
use CompAnalResult::HistogramResult;
use CompAnalResult::LinkPlotResult;
use CompAnalResultSource;
use PaintDevice;

use Resources::Origami::OrigamiHandler;

@CompAnalResultSource::OrigamiResultSource::ISA=qw(CompAnalResultSource);

sub init {
    Resources::Origami::OrigamiHandler::init();
}

sub  new {
    my $class = shift;
    my $totalresult = shift;
    
    my $self= _new CompAnalResultSource @_;

    $self->{valign}='above';
    
    bless $self,$class;
    
    my $companalResult = undef;

    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}}
	 =~ /Atypical Genes/ ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Atypical Genes from ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}
	}; 
	
	$companalResult = [$self->_create_atypical_genes_boxPlot($companalResultsAttributes,$totalresult)];
    }


    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}}
	 =~ /Gene Occurrences/ ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Gene Occurrences in ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}
	}; 
	
	$companalResult = [$self->_create_gene_occurrences_histogram($companalResultsAttributes,$totalresult)];
    }
   

    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}}
	 =~ /Unique Genes/ ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Unique Genes in ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}
	}; 
	
	$companalResult = [$self->_create_unique_genes_boxPlot($companalResultsAttributes,$totalresult)];
    }
   

    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}}
	 =~ /Small Genes/ ){

	my $companalResultsAttributes={
	    'type' =>  'overlay',
	    'comment' => "Small Genes of ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}
	}; 
	
	$companalResult = [$self->_create_small_genes_boxPlot($companalResultsAttributes,$totalresult)];
    }
   
    
    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}} =~ /Gene Context Conservation/ ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Conserved Gene Contexts ( ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}." vs ".$totalresult->{s_organism_name}."-".$totalresult->{s_element}->{type}." ".$totalresult->{s_element}->{description}.")"
	    }; 
	$companalResult = $self->_create_conserved_context_boxPlot($companalResultsAttributes,$totalresult);
    }
	

    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}} =~ /Orthology Map/ ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Orthology Map ( ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}." vs ".$totalresult->{sorganismname}."-".$totalresult->{selement}->{type}." ".$totalresult->{selement}->{description}.")"
	    }; 
	$companalResult = $self->_create_orthology_map_linkPlot($companalResultsAttributes,$totalresult);
    }

    if ( $Resources::Origami::OrigamiHandler::resultdescriptions{$totalresult->{result}->{typeId}} =~ /Genome Subtraction/ ){

	my $companalResultsAttributes={
	    'type' =>  'separate',
	    'comment' => "Genome Subtraction ( ".$totalresult->{organism}->{name}."-".$totalresult->{element}->{type}." ".$totalresult->{element}->{description}." vs ".$totalresult->{sorganismname}."-".$totalresult->{selement}->{type}." ".$totalresult->{selement}->{description}.")"
	    }; 
	$companalResult = $self->_create_genome_subtraction_boxPlot($companalResultsAttributes,$totalresult);
    }
	
    foreach my $result (@{$companalResult}) {
	push @{$self->{companalresults}},$result;
    }

    return $self;
}

sub _create_orthology_map_linkPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $linkplots=[];
    my $textbuffer='';

    my $hmap = Resources::Origami::OrigamiHandler::getOrthologyMapForElementPair($totalresult->{element},$totalresult->{selement});

    my $linkplot=new CompAnalResult::LinkPlotResult($companalResultsAttributes);
    $linkplot->{height}=20;
    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="QGene\tStart\tStop\tStrand\tSGene\tStart\tStop\tStrand\tEValue\tScore\n";

    foreach my $hpair (sort {$a->{QGene}->{start} <=> $b->{QGene}->{start}}
		       @$hmap) {

	my $qgene=$hpair->{QGene};
	my $qstart=$qgene->{start};
	my $qstop=$qgene->{stop};
	my $qstrand=$qgene->{strand};
        $begin=$qstart
	    if ($begin>$qstart);
	$end=$qstop
	    if ($end<$qstop);
	my $sgene=$hpair->{SGene};
	my $sstart=$sgene->{start};
	my $sstop=$sgene->{stop};
	my $sstrand=$sgene->{strand};
        $begin=$sstart
	    if ($begin>$sstart);
	$end=$sstop
	    if ($end<$sstop);
	
	$textbuffer.=$qgene->{name}."\t".$qstart."\t".$qstop."\t".
	    $qstrand."\t".$sgene->{name}."\t".$sstart."\t".$sstop."\t".
	    $sstrand."\t".$hpair->{evalue}."\t".$hpair->{score}."\n";
	
	my $color='green';
	$color='red'
	    if ($qstrand != $sstrand);

	push @{$linkplot->{links}},{from => int(($qstart+$qstop)/2),
				    to => int(($sstart+$sstop)/2),
				    color => $color,
				    info => $qgene->{name}." - ".$sgene->{name}. "\n\tE-value: ".$hpair->{evalue}."\n\tScore: ".$hpair->{score}};
    }

    $linkplot->{start}=$begin;
    $linkplot->{end}=$end;
    push @{$linkplots},$linkplot;
    $self->{logwindow}->add_text($textbuffer);

    return $linkplots;
}

sub _create_genome_subtraction_boxPlot {

    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $boxplots=[];
    my $textbuffer='';

    my $genes = Resources::Origami::OrigamiHandler::getGenesBySubtractionForElementPair($totalresult->{element},$totalresult->{selement});

    my $boxplot=new CompAnalResult::BoxPlotResult($companalResultsAttributes);
    my $begin=1e10;
    my $end=-1;
    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Gene\tStart\tStop\tStrand\n";

    foreach my $gene (sort {$a->{start} <=> $b->{start}} @$genes) {

	my $start=$gene->{start};
	my $stop=$gene->{stop};
	my $strand=$gene->{strand};
        $begin=$start
	    if ($begin>$start);
	$end=$stop
	    if ($end<$stop);
	
	$textbuffer.=$gene->{name}."\t".$start."\t".$stop."\t".
	    $strand."\n";
	
	my $valign='above';
	$valign='below'
	    if ($strand <0);
	push @{$boxplot->{boxes}},{begin => $start,
				   end => $stop,
				   color => 'red',
				   filled =>  1,
				   thickness=> 0.5,
				   strand => $strand,
			           label=> $gene->{name},
				   valign => $valign};
    }

    $boxplot->{start}=$begin;
    $boxplot->{end}=$end;
    push @{$boxplots},$boxplot;
    $self->{logwindow}->add_text($textbuffer);

    return $boxplots;
}

sub _create_conserved_context_boxPlot {
    
    my ($self,$companalResultsAttributes,$totalresult ) = @_;
    

    my $boxplotresults=[];
    
    PaintDevice::color_alloc("no_relation_conserved",0.2,0.5,0.2 );
    PaintDevice::color_alloc("no_relation_reversed",0.5,0.2,0.2 );
    PaintDevice::color_alloc("ortholog_conserved",0,1,0);
    PaintDevice::color_alloc("ortholog_reversed",1,0,0);
    PaintDevice::color_alloc("homolog_conserved",0,0,1);
    PaintDevice::color_alloc("homolog_reversed",0.8,0.3,0);
    PaintDevice::color_alloc("mismatch",0.4,0.4,0.4);
    PaintDevice::color_alloc("q_gap",0.9,0.9,0.9);
    PaintDevice::color_alloc("s_gap",1,1,1);

   
    my $totalalignments= undef;
    
    my $cc_params = Resources::Origami::OrigamiHandler::getConservedContextParamsForElementPair($totalresult->{element},$totalresult->{selement});
    

    my $cc_alignments =Resources::Origami::OrigamiHandler::getConservedContextAlignmentsWithParams($cc_params) ;


    my $cc_pairs = Resources::Origami::OrigamiHandler::getConservedContextAlignmentsPairsWithParams($cc_params);    

    

    my %alignment_ids=();

    my $index=0;

    foreach my $alignment (@{$cc_alignments}) {
	$alignment_ids{$alignment->{id}}=$index;
	$alignment->{display_line}=1;
	$alignment->{pair}=[];
	$alignment->{q_start}=1e38;
	$alignment->{q_stop}=-1;
	$alignment->{s_start}=1e38;
	$alignment->{s_stop}=-1;
	$index++;
    }
   
    my $align_pair = ();
    
    foreach my $pair ( @$cc_pairs ){
	if (defined $alignment_ids{$pair->{alignmentId}}) {
	    my $alignment=$cc_alignments->[$alignment_ids{$pair->{alignmentId}}];
	    push @{$alignment->{pair}},$pair;

	    $alignment->{q_start}=$pair->{QGene}->{start}
	    if ($pair->{QGene}->{start} < $alignment->{q_start});
	    $alignment->{q_stop}=$pair->{QGene}->{stop}
	    if ($pair->{QGene}->{stop} > $alignment->{q_stop});

	    $alignment->{s_start}=$pair->{SGene}->{start}
	    if ($pair->{SGene}->{start} < $alignment->{s_start});
	    $alignment->{s_stop}=$pair->{SGene}->{stop}
	    if ($pair->{SGene}->{stop} > $alignment->{s_stop});
	} else {
	    warn ("Unknown Alignment ID");
	}
    }
    

    foreach my $alignment (@{$cc_alignments}) {
	$alignment->{q_size}=$alignment->{q_stop}-$alignment->{q_start};
	$alignment->{s_size}=$alignment->{s_stop}-$alignment->{s_start};
    }
    
    my @query_lines=();
    my $textbuffer=scalar(localtime)."\n";
    
    foreach my $alignment ( sort { $b->{q_size} <=> $a->{q_size} } 
			    @{$cc_alignments} ) {
	my $display_line=1;
	my $query_pos_start = $alignment->{q_start};
	my $query_pos_end = $alignment->{q_stop};
	
	for (my $query_pos = $query_pos_start;
	     $query_pos <= $query_pos_end;
	     $query_pos++) {
	    
	    if ($query_lines[$query_pos]>$display_line) {
		$display_line=$query_lines[$query_pos];
	    }
	}
	$alignment->{display_line}=$display_line;
	for (my $query_pos= $query_pos_start;
	     $query_pos<= $query_pos_end;
	     $query_pos++) {
	    $query_lines[$query_pos]=$display_line+1;
	}
    }
 
    my $curr_line=0;

    my $min=1e8;
    my $max=-1;
    my $boxplotresult=undef;
    my $comment=$companalResultsAttributes->{comment};
    $textbuffer.=$comment."\n";

    foreach my $alignment ( sort { $a->{display_line} <=>  $b->{display_line} } 
			    @{$cc_alignments} ){
	 
	my $currentbox={};
	if ($alignment->{display_line} != $curr_line) {
	    $curr_line=$alignment->{display_line};
	    if (defined $boxplotresult) {
		push @{$boxplotresults},$boxplotresult;
	    }
	    
	    $companalResultsAttributes->{comment}=
		$comment." [line ".$alignment->{display_line}."]";
	    $boxplotresult=new CompAnalResult::BoxPlotResult($companalResultsAttributes);
	    
	}
 	    #Ecriture des boites alignements
	    
	$max=$alignment->{q_start}
	if ($alignment->{q_stop} > $max);
	$min=$alignment->{q_start}
	if ($alignment->{q_start} < $min);
	$currentbox->{begin}=$alignment->{q_start};
	$currentbox->{end}=$alignment->{q_stop};
	$currentbox->{strand}='none' ;
	
	if ($alignment->{orientationConserved}){
	    $currentbox->{color}='no_relation_conserved';
	}
	else {$currentbox->{color}='no_relation_reversed'};
	
	$currentbox->{thickness}=0.95;
	$currentbox->{filled}='no';
	$currentbox->{halign}='middle';
	$currentbox->{valign}='above';
	$currentbox->{frame} = 'none';
	push @{$boxplotresult->{boxes}},$currentbox;
	$textbuffer.="Conserved context:\n";
	$textbuffer.="\tFrom: ".(int($alignment->{q_start}/10.0)/100.0)."\n";
	$textbuffer.="\tTo: ".(int($alignment->{q_stop}/10.0)/100.0)."\n";
	$textbuffer.="\tPairs: ".$alignment->{pairs}."\n";
	$textbuffer.="\tComposition:\n";
	push @{$boxplotresult->{highlights}},{begin =>$currentbox->{begin},
					      end => $currentbox->{end},
					      label =>$alignment->{pairs} ." gene(s) ( ".(int($alignment->{q_size}/10.0)/100.0)." kb, from ".(int($alignment->{q_start}/10.0)/100)." to ".(int($alignment->{q_stop}/10.0)/100.0)." )"};
	
	foreach my $pair (@{$alignment->{pair}}){
	    
	    $textbuffer.="\t\t";
	    if ($pair->{QGene}) {
		$textbuffer.=$pair->{QGene}->{name}." ";
	    } else {
		$textbuffer.="<GAP> ";
	    }
	    $textbuffer.=" -- ";
	    if ($pair->{SGene}) {
		$textbuffer.=$pair->{SGene}->{name}." ";
	    } else {
		$textbuffer.="<GAP> ";
	    }

	    if ($pair->{QGene} && $pair->{SGene}) {
		$textbuffer.=$pair->{relation};
	    }
	    $textbuffer.="\n";
	    my $currentbox2={};
	    
	    $currentbox2->{begin}=$pair->{QGene}->{start};
	    $currentbox2->{end}=$pair->{QGene}->{stop};
	    $currentbox2->{strand}=$pair->{QGene}->{strand};
	    
	    $currentbox2->{filled}=1;
	    
	    if ( $alignment->{orientationConserved}){
		if ( $pair->{relation} eq "Ortholog"  ){
		    $currentbox2->{color} = 'ortholog_conserved';}
		elsif ( $pair->{relation} eq "Homolog" ){	
		    $currentbox2->{color}='homolog_conserved';}
		elsif ($pair->{relation} eq "Mismatch"  ){	
		    $currentbox2->{color}='mismatch';}
		elsif ($pair->{relation} eq "S_gap" ){
		    $currentbox2->{filled}='no';	
		    $currentbox2->{color}='s_gap';}
		elsif ($pair->{relation} eq "Q_gap" ){
		    $currentbox2->{filled}='no';
		    $currentbox2->{color}='q_gap';}			
	    }
	    else{
		if ( $pair->{relation} eq "Ortholog" ){
		    $currentbox2->{color} = 'ortholog_reversed';}
		elsif ( $pair->{relation} eq "Homolog" ){
		    $currentbox2->{color} = 'homolog_reversed';}
		elsif ($pair->{relation} eq "Mismatch" ){	
		    $currentbox2->{color} = 'mismatch';}
		elsif ($pair->{relation} eq "S_gap" ){
		    $currentbox2->{filled}='no';	
		    $currentbox2->{color} = 's_gap';}
		elsif ($pair->{relation} eq "Q_gap" ){
		    $currentbox2->{filled}='no';	
		    $currentbox2->{color} = 'q_gap';}
	    }
	    $currentbox2->{frame} = 'yes';
	    $currentbox2->{thickness}=0.3;
	    
	    if ($pair->{SGene}->{name}){
		$currentbox2->{label} = $pair->{SGene}->{name};
	    }
	    $currentbox2->{halign}='middle';
	    if ($self->valign eq 'above' ){
		$currentbox2->{valign}='below';
		$self->valign('below');
	    }
	    else{
		$currentbox2->{valign}='above';
		$self->valign('above');
	    }
	    $currentbox2->{frame} = 'none';
	    push @{$boxplotresult->{boxes}},$currentbox2;
	}
	$boxplotresult->{start}=$min;
	$boxplotresult->{end}=$max;
    }

    push @{$boxplotresults},$boxplotresult;
    $self->{logwindow}->add_text($textbuffer);

    return $boxplotresults;
}


sub _create_atypical_genes_boxPlot{
    my ($self,$companalResultsAttributes,$totalresult ) = @_;

    my $boxeresult = new CompAnalResult::BoxPlotResult($companalResultsAttributes);
    my $min=1e10;
    my $max=-1;
    my $genes= Resources::Origami::OrigamiHandler::getAtypicalGenesOfElement($totalresult->{element});

    my $textbuffer=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    $textbuffer.="Organism Gene Classification Satistics:\n";

    my $eltswst=Resources::Origami::OrigamiHandler::getElementStatesOfOrganism($totalresult->{organism});
    foreach my $elt (@$eltswst) {
	$textbuffer.="\t".$elt->{type}." - ".$elt->{description}."\n";
	$textbuffer.="\tRatio of Forward Strand Genes Classified As Such: ".$elt->{forwardGenesRatio}."\n";
	$textbuffer.="\tRatio of Reverse Strand Genes Classified As Such: ".$elt->{reverseGenesRatio}."\n";
	$textbuffer.="\tRatio of Atypical Genes: ".$elt->{atypicalGenesRatio}."\n";
    }
    
    $textbuffer.="Atypical Genes Details\n";
    $textbuffer.="Name\tStart\tStop\tStrand\n";
    foreach my $gene (sort { $a->{start} <=> $b->{start}} @$genes) {


	$textbuffer.=$gene->{name}."\t".
	    $gene->{start}."\t".
	    $gene->{stop}."\t".
	    $gene->{strand}."\n";
	my $currentbox={};

	$max=$gene->{stop}
	if ($gene->{stop} > $max);
	$min=$gene->{start}
	if ($gene->{start} < $min);
	$currentbox->{begin}=$gene->{start};
	$currentbox->{end}=$gene->{stop};
	$currentbox->{strand}=$gene->{strand};
	if ($gene->{strand} == 1 ){
	    $currentbox->{color}='green';
	}
	else{$currentbox->{color}='red';}
	$currentbox->{thickness}=0.3;
	$currentbox->{filled}=0;
	$currentbox->{label}=$gene->{name};
	$currentbox->{halign}='middle';
	if ($self->valign eq 'above' ){
	    $currentbox->{valign}='below';
	    $self->valign('below');
	}
	else{
	    $currentbox->{valign}='above';
	    $self->valign('above');
	}
	$currentbox->{frame} = 'none';
	push @{$boxeresult->{boxes}},$currentbox;
	push @{$boxeresult->{highlights}},{begin =>$currentbox->{begin},
					   end => $currentbox->{end},
					   label => $currentbox->{label}};
    }
    $boxeresult->{start}=$min;
    $boxeresult->{end}=$max;
    $self->{logwindow}->add_text($textbuffer);
    return $boxeresult;
}

sub _create_unique_genes_boxPlot{
    my ($self,$companalResultsAttributes,$totalresult ) = @_;

    my $boxeresult = new CompAnalResult::BoxPlotResult($companalResultsAttributes);
    my $min=1e10;
    my $max=-1;
    my $genes= Resources::Origami::OrigamiHandler::getUniqueGenesOfElement($totalresult->{element});

    $self->{logwindow}->add_text(scalar(localtime)."\n");
    $self->{logwindow}->add_text($companalResultsAttributes->{comment}."\n");
    $self->{logwindow}->add_text("Name\tStart\tStop\tStrand\n");
    foreach my $gene (sort {$a->{start} <=> $b->{start}} @$genes) {

	$self->{logwindow}->add_text($gene->{name}."\t".
				     $gene->{start}."\t".
				     $gene->{stop}."\t".
				     $gene->{strand}."\n");

	my $currentbox={};

	$max=$gene->{stop}
	if ($gene->{stop} > $max);
	$min=$gene->{start}
	if ($gene->{start} < $min);
	$currentbox->{begin}=$gene->{start};
	$currentbox->{end}=$gene->{stop};
	$currentbox->{strand}=$gene->{strand};
	if ($gene->{strand} == 1 ){
	    $currentbox->{color}='green';
	}
	else{$currentbox->{color}='red';}
	$currentbox->{thickness}=0.3;
	$currentbox->{filled}=0;
	$currentbox->{label}=$gene->{name};
	$currentbox->{halign}='middle';
	if ($self->valign eq 'above' ){
	    $currentbox->{valign}='below';
	    $self->valign('below');
	}
	else{
	    $currentbox->{valign}='above';
	    $self->valign('above');
	}
	$currentbox->{frame} = 'none';
	push @{$boxeresult->{boxes}},$currentbox;
	push @{$boxeresult->{highlights}},{begin =>$currentbox->{begin},
					   end => $currentbox->{end},
					   label => $currentbox->{label}};
    }
    $boxeresult->{start}=$min;
    $boxeresult->{end}=$max;

    return $boxeresult;
}


sub _create_small_genes_boxPlot{
    my ($self,$companalResultsAttributes,$totalresult ) = @_;

    my $boxeresult = new CompAnalResult::BoxPlotResult($companalResultsAttributes);
    my $min=1e10;
    my $max=-1;
    my $genes= Resources::Origami::OrigamiHandler::getSmallGenesOfElement($totalresult->{element});

    $self->{logwindow}->add_text(scalar(localtime)."\n");
    $self->{logwindow}->add_text($companalResultsAttributes->{comment}."\n");
    $self->{logwindow}->add_text("Name\tStart\tStop\tStrand\tProb.\tHomologies\tComment\n");
    foreach my $gene (sort {$a->{start} <=> $b->{start}} @$genes) {

	$self->{logwindow}->add_text($gene->{name}."\t".
				     $gene->{start}."\t".
				     $gene->{stop}."\t".
				     $gene->{strand}."\t".
				     $gene->{probability}."\t".
				     $gene->{homologies}."\t".
				     $gene->{comment}."\n");

	my $currentbox={};

	$max=$gene->{stop}
	if ($gene->{stop} > $max);
	$min=$gene->{start}
	if ($gene->{start} < $min);
	$currentbox->{begin}=$gene->{start};
	$currentbox->{end}=$gene->{stop};
	$currentbox->{strand}=$gene->{strand};
	$currentbox->{frame}=1+($gene->{start}-1)%3;
	$currentbox->{frame}=1+(2-($gene->{stop}-1)%3)
	    if ($gene->{strand}==-1);
	if ($gene->{strand} == 1 ){
	    $currentbox->{color}='green';
	}
	else{$currentbox->{color}='red';}
	$currentbox->{thickness}=0.7;
	$currentbox->{filled}=1;
#	$currentbox->{filled}=1
#	    if ($gene->{homologies}>0);
	$currentbox->{label}=$gene->{name};
	$currentbox->{halign}='middle';
	if ($self->valign eq 'above' ){
	    $currentbox->{valign}='below';
	    $self->valign('below');
	}
	else{
	    $currentbox->{valign}='above';
	    $self->valign('above');
	}
	$currentbox->{info}=$gene->{comment};

	push @{$boxeresult->{boxes}},$currentbox;
	push @{$boxeresult->{highlights}},{begin =>$currentbox->{begin},
					   end => $currentbox->{end},
					   label => $currentbox->{label},
					   info => $currentbox->{info}};
    }
    $boxeresult->{start}=$min;
    $boxeresult->{end}=$max;

    return $boxeresult;
}

sub _create_gene_occurrences_histogram {
    my ($self,$companalResultsAttributes,$totalresult ) = @_;

    my $historesult = new CompAnalResult::HistogramResult($companalResultsAttributes);
    my $min=1e10;
    my $max=-1;
    my $minheight=1e10;
    my $maxheight=-1;

    my $textbuffer='';

    my $geneswo= Resources::Origami::OrigamiHandler::getGeneOccurrencesOfElement($totalresult->{element});

    $textbuffer.=scalar(localtime)."\n";
    $textbuffer.=$companalResultsAttributes->{comment}."\n";
    
    $textbuffer.="Gene Occurrences Details\n";
    $textbuffer.="Name\tStart\tStop\tStrand\tOccurrences\n";
    foreach my $gene (sort { $a->{start} <=> $b->{start}} @$geneswo) {


	$textbuffer.=$gene->{name}."\t".
	    $gene->{start}."\t".
	    $gene->{stop}."\t".
	    $gene->{strand}."\t".
	    $gene->{occurrences}."\n";

	my $currentbar={};

	$max=$gene->{stop}
	if ($gene->{stop} > $max);
	$min=$gene->{start}
	if ($gene->{start} < $min);

	$minheight=$gene->{occurrences}
	if ($gene->{occurrences}<$minheight);
	$maxheight=$gene->{occurrences}
	if ($gene->{occurrences}>$maxheight);

	$currentbar->{start}=$gene->{start};
	$currentbar->{width}=$gene->{stop}-$gene->{start}+1;
	$currentbar->{height}=$gene->{occurrences};
	$currentbar->{filled}=1;
	push @{$historesult->{bars}},$currentbar;
    }
    $historesult->{start}=$min;
    $historesult->{end}=$max;
    $historesult->{min}=$minheight;
    $historesult->{max}=$maxheight;
    $historesult->{height}=10;

    $self->{logwindow}->add_text($textbuffer);

    return $historesult;
}

sub valign{
   my $self= shift;
   
    if(my $valign=shift){
	$self->{valign}=$valign;
    }
    return $self->{valign};
}
1;
