package CompAnalResultSource::PatternSearchSource;

use strict;

use Carp;

use Bio::Seq;
use Bio::Tools::SeqPattern;

use CompAnalResult::BoxPlotResult;
use CompAnalResultSource;

@CompAnalResultSource::PatternSearchSource::ISA=qw(CompAnalResultSource);

sub _search_for_pattern {
    my $self=shift;
    my $seqobj=shift;
    my $pattern=shift;
    my $fw=shift;
    my $bw=shift;

    my $seqpat=new Bio::Tools::SeqPattern(-SEQ => $pattern, -TYPE => 'Dna');
     
    my $result=new CompAnalResult::BoxPlotResult({'type' => 'sequence_overlay',
						  'comment' => "Pattern Search $pattern"});
						  
    my $sequence=$seqobj->seq();

    my $thickness=1;
    my $filled=1;
    my $vpos=0.5;
    $result->{start}=1e10;
    $result->{end}=-1;
    
    if ($fw) {
	my $perlpat=$seqpat->expand();
	while ($sequence =~ /($perlpat)/gi) {
		my $match=$1;
		my $patend=pos $sequence;
		my $patstart=$patend-length($match)+1;
		$result->{start}=$patstart
		    if ($patstart < $result->{start});
		$result->{end}=$patend
		    if ($patend > $result->{end});
		my $box={begin => $patstart,
			 end => $patend,
			 vpos => $vpos,
			 thickness => $thickness,
			 filled => $filled,
			 color => 'green',
			 strand => 1,
			 frame => 'none'};
		push @{$result->{boxes}},$box;
		my $highlight={begin => $patstart,
			       end => $patend,
			       label => "$match ($patstart)"};
		push @{$result->{highlights}},$highlight;
	    }
	
    }


    if ($bw) {
	my $revpat=$seqpat->revcom();
	my $perlpat=$revpat->expand();
	while ($sequence =~ /($perlpat)/gi) {
		my $match=$1;
		my $patend=pos $sequence;
		my $patstart=$patend-length($match)+1;
		$result->{start}=$patstart
		    if ($patstart < $result->{start});
		$result->{end}=$patend
		    if ($patend > $result->{end});
		my $box={begin => $patstart,
			 end => $patend,
			 thickness => $thickness,
			 filled => $filled,
			 strand => -1,
			 color => 'red',
			 frame => 'none'};
		push @{$result->{boxes}},$box;
		my $highlight={begin => $patstart,
			       end => $patend,
			       label => "$match ($patstart)"};
		push @{$result->{highlights}},$highlight;
	    }
	
    }

    return $result;

}

sub new {
    my $class=shift;
    my $seqobj=shift;
    my $pattern=shift;
    my $fw=shift;
    my $bw=shift;

    my $self=_new CompAnalResultSource;

    bless $self,$class;

    my $result=$self->_search_for_pattern($seqobj,$pattern,$fw,$bw);

    push @{$self->{companalresults}},$result;

    return $self;
}

1;
