package CompAnalResultSourceWindow::FileWindow;

use strict;

use CompAnalResultSourceWindow;

@CompAnalResultSourceWindow::FileWindow::ISA=qw(Gtk::FileSelection CompAnalResultSourceWindow);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::FileSelection('Results File Selection');
    
    $self->ok_button->signal_connect('clicked',sub {$self->hide(); $self->results_file_selected();});
    $self->cancel_button->signal_connect('clicked',sub {$self->hide(); return 1;});

    $self->{manager}=$manager;

    bless $self,$class;

    return $self;
}


sub results_file_selected {
    my $self=shift;

    my $filename=$self->get_filename();

    my $datasource=new CompAnalResultSource::FileResultSource($filename);

    $self->{manager}->add_results_from_source($self->{mapname},$datasource);

    return 1;
}

1
