package CompAnalResultSourceWindow::GCSkewWindow;

use strict;

use CompAnalResultSourceWindow;

@CompAnalResultSourceWindow::GCSkewWindow::ISA=qw(Gtk::Dialog CompAnalResultSourceWindow);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog();
    $self->set_title("GC Skew");

    my $dialogvbox=$self->vbox();

    my $vbox=new Gtk::VBox();
    $vbox->show();
    $dialogvbox->pack_start($vbox,1,1,0);
    
    my $hbox=new Gtk::HBox();
    $hbox->show();
    $vbox->pack_start($hbox,1,1,0);

    
    my $label=new Gtk::Label("Window size");
    $label->show();
    $hbox->pack_start($label,1,1,0);

    my $entry=new Gtk::Entry("10000");
    $entry->show();
    $hbox->pack_start($entry,1,1,0);
    $self->{windowsizeentry}=$entry;

    my $action_area=$self->action_area();

    my $btn=new Gtk::Button("OK");
    $btn->signal_connect('clicked',sub {$self->hide(); $self->ok_clicked();});
    $btn->show();
    $action_area->pack_start($btn,1,1,0);

    $btn=new Gtk::Button("Cancel");
    $btn->signal_connect('clicked',sub {$self->hide(); return 1;});
    $btn->show();
    $action_area->pack_start($btn,1,1,0);

    $self->{manager}=$manager;

    bless $self,$class;

    return $self;
}

sub ok_clicked {
    my $self=shift;

    my $windowsize=$self->{windowsizeentry}->get_text();
    my $mapinfo=$self->{manager}->get_mapinfo('NAME' => $self->{mapname});
    if (defined $mapinfo) {
	my $seqobj=$mapinfo->get_map()->get_seqobj();
	my $source=new CompAnalResultSource::GCSkewSource($seqobj,
							  $windowsize,
							  $self->{mapname});

	$self->{manager}->add_results_from_source($self->{mapname},$source);
    }
    return 1;
}
