package CompAnalResultSourceWindow::MosaicResultsWindow; 

use strict;

use CompAnalResultSourceWindow;

@CompAnalResultSourceWindow::MosaicResultsWindow::ISA=qw(Gtk::Dialog CompAnalResultSourceWindow);

my $false = 0;
my $true = 1;
my $clist_area;
my $idseqregion;

sub new{
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog();

    bless $self,$class;

    $self->signal_connect('delete_event', sub {return 1});
    $self->signal_connect('destroy_event', sub {return 1});
    $self->set_title('Results from Mosaic');
    $self->set_modal( $true );
    $self->set_default_size( 400, 400 );
    $self->set_position('center');
	
    $self->{manager}=$manager;

    $self->_load_tree_data();
    $self->_create_alignment_tree();
  
    my $tree_frame= new Gtk::Frame();
    my $tree_window = new Gtk::ScrolledWindow( undef, undef );
    $tree_window->set_usize( 30, 300 );
    $tree_window->set_policy( 'automatic', 'automatic' );
    $tree_window ->add_with_viewport( $self->{alignment_tree} );
    $tree_window ->show();
    $tree_frame->add($tree_window);
    $tree_frame ->show();
    $self->vbox->pack_start($tree_frame,$true,$true,0);

    my $check_frame= new Gtk::HBox(0);
    my $check_loop=new Gtk::CheckButton("Loop");
    $check_loop->show;
    $check_frame->add($check_loop);
    my $check_backbone=new Gtk::CheckButton("Backbone");
    $check_backbone->show;
    $check_frame->add($check_backbone);
    my $check_link=new Gtk::CheckButton("Link backbone");
    $check_link->show;
    $check_frame->add($check_link);
    my $check_linkloop=new Gtk::CheckButton("Link loop");
    $check_linkloop->show;
    $check_frame->add($check_linkloop);
    my $check_annot=new Gtk::CheckButton("Only annotation");
    $check_annot->show;
    $check_frame->add($check_annot);

    #first select
    $check_backbone->set_active(1);
    $check_loop->set_active(0);
    $check_link->set_active(0);
    $check_annot->set_active(0);

    #Limit for category
    my $category_frame= new Gtk::HBox(0);
    my $lbl_category = new Gtk::Label("Size threshold for colors : first boundary");
    $lbl_category->show;
    $category_frame->add($lbl_category);
    my $txt_limit1=new Gtk::Text(undef, undef);
    $txt_limit1->set_editable(1);
    $txt_limit1->set_usize(10,20);
    $txt_limit1->insert(undef,undef,undef,6);
    $txt_limit1->show;
    $category_frame->add($txt_limit1);
    my $lbl_category2 = new Gtk::Label("second boundary");
    $lbl_category2->show;
    $category_frame->add($lbl_category2);
    my $txt_limit2=new Gtk::Text(undef, undef);
    $txt_limit2->set_editable(1);
    $txt_limit2->set_usize(10,20);
    $txt_limit2->insert(undef,undef,undef,20);
    $txt_limit2->show;
    $category_frame->add($txt_limit2);

    #Limit for size
    my $size_frame= new Gtk::HBox(0);
    my $lbl_size = new Gtk::Label("Size selected : from");
    $lbl_size->show;
    $size_frame->add($lbl_size);
    my $txt_size1=new Gtk::Text(undef, undef);
    $txt_size1->set_editable(1);
    $txt_size1->set_usize(10,20);
    $txt_size1->show;
    $size_frame->add($txt_size1);
    my $lbl_size2 = new Gtk::Label("to");
    $lbl_size2->show;
    $size_frame->add($lbl_size2);
    my $txt_size2=new Gtk::Text(undef, undef);
    $txt_size2->set_editable(1);
    $txt_size2->set_usize(10,20);
    $txt_size2->show;
    $size_frame->add($txt_size2);

    #Limit for area
    my $area_frame= new Gtk::HBox(0);
    my $check_area=new Gtk::CheckButton("Area");
    $check_area->show;
    $area_frame->add($check_area);
    #$cliste_area defined for all the module because it is used in _genomeali_selected
    $clist_area=new Gtk::CList(3);
    $clist_area->set_column_width(0, 50);
    $clist_area->set_column_width(1, 100);
    $clist_area->set_column_width(2, 200);
    $clist_area->column_titles_show();
    $clist_area->column_titles_passive();
    $clist_area->set_column_title(0, 'ident');
    $clist_area->set_column_title(1, 'type');
    $clist_area->set_column_title(2, 'data');
    $clist_area->set_selection_mode('single');
    $clist_area->signal_connect( "select_row", \&selection_made );
    $clist_area->clear();
    $clist_area->show;
    $area_frame->add($clist_area);

    $check_frame ->show();
    $self->vbox->pack_start($check_frame,$true,$true,1);

    $category_frame ->show();
    $self->vbox->pack_start($category_frame,$true,$true,1);

    $size_frame ->show();
    $self->vbox->pack_start($size_frame,$true,$true,1);

    $area_frame ->show();
    $self->vbox->pack_start($area_frame,$true,$true,1);

    my $action_area=$self->action_area();

    my $bouton_ok=new Gtk::Button( "OK" );
    $bouton_ok->set_usize( 100, 20 );
    $bouton_ok->show();
    $bouton_ok->signal_connect('clicked',sub {$self->_load_results($check_loop->get_active(),$check_backbone->get_active(),$check_link->get_active(),$check_linkloop->get_active(),$check_annot->get_active(),$txt_limit1->get_chars(0, $txt_limit1->get_length()),$txt_limit2->get_chars(0, $txt_limit2->get_length()),$txt_size1->get_chars(0, $txt_size1->get_length()),$txt_size2->get_chars(0, $txt_size2->get_length()), $check_area->get_active())});
    $action_area->pack_start($bouton_ok,$false,$false,0);
    $self->{'button_ok'} =  $bouton_ok;
    
    my $bouton_cancel =new Gtk::Button("Cancel");
    $bouton_cancel->set_usize( 100, 20 );
    $bouton_cancel->show();
    $bouton_cancel->signal_connect( 'clicked',sub{$self->hide();return 1;});
    $action_area->pack_start($bouton_cancel,$false,$false,0);

    $idseqregion="";

    return $self;  	
} 

sub _load_tree_data {
    
    my $self=shift;

    $self->{logiciels}=CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getAllLogiciels();
    $self->{logicielsbyid}={};
    foreach my $logiciel (@{$self->{logiciels}}) {
	$self->{logicielsbyid}->{$logiciel->{id_software}}=$logiciel;
    }
    
    $self->{alignments}=CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getAlignmentsOfLogiciels($self->{logiciels});
    $self->{alignmentsbyid}={};
    foreach my $alignment (@{$self->{alignments}}) {
	$self->{alignmentsbyid}->{$alignment->{id_comparison}}=$alignment;
    }
    
    $self->{criteria}=CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getCriteriaOfAlignments($self->{alignments});
    $self->{criteriabyid}={};
    foreach my $criterion (@{$self->{criteria}}) {
	$self->{criteriabyid}->{$criterion->{critereid}}=$criterion;
    }
    
    $self->{genomes}=CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getGenomesOfCriteria($self->{criteria});
    $self->{genomesbyid}={};
    foreach my $genome (@{$self->{genomes}}) {
	$self->{genomesbyid}->{$genome->{id_alignedgenome}}=$genome;
    }

    return 1;  
}

sub _create_alignment_tree {
    
    my $self = shift;

    $self->{alignment_tree}=new Gtk::Tree();
    $self->{alignment_tree}->set_selection_mode('single');
    $self->{alignment_tree}->set_view_mode('item');
    $self->{alignment_tree}->show();  

    my $rootitem = new_with_label Gtk::TreeItem('ALignments');
    $rootitem->show();   
    $self->{alignment_tree}->append($rootitem);

    my $rootsubtree = new Gtk::Tree();
    $rootsubtree->show();
    $rootitem ->set_subtree($rootsubtree);
   
    my %logitemsbyid=();

    foreach my $logiciel (sort {$a->{nom} cmp $b->{nom}} 
			  @{$self->{logiciels}}) {
	my $logitem=new_with_label Gtk::TreeItem($logiciel->{name});
	$logitemsbyid{$logiciel->{id_software}}=$logitem;
	$logitem->show();
	$rootsubtree->append($logitem);

	my $logsubtree=new Gtk::Tree();
	$logsubtree->show();
	$logsubtree->set_view_mode('item');  
	$logitem->set_subtree($logsubtree);
    }

    my %aliitemsbyid=();

    foreach my $alignment (sort {$a->{description} cmp
				     $b->{description}}
			 @{$self->{alignments}}) {
	my $aliitem=new_with_label Gtk::TreeItem($alignment->{description});
	$aliitem->show();
	$aliitemsbyid{$alignment->{id_comparison}}=$aliitem;

	$logitemsbyid{$alignment->{id_software}}->subtree->append($aliitem);

	my $alisubtree=new Gtk::Tree();
	$alisubtree->show();
	$alisubtree->set_view_mode('item');  
	$aliitem->set_subtree($alisubtree);
    }

    my %crtitemsbyid=();

    foreach my $criterion (sort {$a->{label} cmp
				     $b->{label}}
			 @{$self->{criteria}}) {
	my $crtitem=new_with_label Gtk::TreeItem($criterion->{label});
	$crtitem->show();
	$crtitemsbyid{$criterion->{critereid}}=$crtitem;

	$aliitemsbyid{$criterion->{id_comparison}}->subtree->append($crtitem);

	my $crtsubtree=new Gtk::Tree();
	$crtsubtree->show();
	$crtsubtree->set_view_mode('item');  
	$crtitem->set_subtree($crtsubtree);
    }


    foreach my $genomeali (sort {$a->{query} cmp
				     $b->{query}}
			   @{$self->{genomes}}) {
	my $genaliitem=new_with_label Gtk::TreeItem($genomeali->{strain});
	$genaliitem->show();
	$genaliitem->{handler}=$genaliitem->signal_connect('select', 
				    sub {$self->_genomeali_selected($genaliitem)});
	$genaliitem->{genomeali}=$genomeali;

	$crtitemsbyid{$genomeali->{critereid}}->subtree->append($genaliitem);
    }

    $rootitem->expand();
}


sub selection_made   {     
    my ( $clist, $row, $column, $event, @data ) = @_;
    # retrieve the selection like a pointor
    $idseqregion=$clist_area->get_text($row, 0);       
    return;   
}

sub _genomeali_selected {
    my $self=shift;
    my $resultitem=shift;
    my @Area;
    my $totalresult=$resultitem->{genomeali};
    $self->{selectedresult}=$totalresult;

    #retrieve area for genome of alignment selected
    $clist_area->clear();
    $totalresult->{regions}=CompAnalResultSource::MosaicResultSource::MosaicResultHandler->getRegionsOfAlignment($totalresult);
    $totalresult->{regionsbyid}={};
    my $row = 0;
    foreach my $region (@{$totalresult->{regions}}) {
	$totalresult->{regionsbyid}->{$region->{id_genomeregion}}=$region;
	$Area[0] = $region->{id_genomeregion};
	$Area[1] = $region->{region_type};
	$Area[2] = $region->{critere};
	$clist_area->insert($row, @Area);
	$row++;
    }
    return 1;
}


sub _load_results  {
    my $self=shift;
    my $sel_loop=shift;
    my $sel_backbone=shift;
    my $sel_link=shift;
    my $sel_linkloop=shift;
    my $sel_annot=shift;
    my $limit1=shift;
    my $limit2=shift;
    my $size1=shift;
    my $size2=shift;
    my $sel_area=shift;

    my $totalresult=$self->{selectedresult};
    if ($totalresult->{id_comparison} ne '') {
	$totalresult->{selectedloop} = $sel_loop;
	$totalresult->{selectedbackbone} = $sel_backbone;
	$totalresult->{selectedlink} = $sel_link;
	$totalresult->{selectedlinkloop} = $sel_linkloop;
	$totalresult->{selectedannot} = $sel_annot;
	if ($idseqregion eq '') {$sel_area = 0;}
	$totalresult->{selectedarea} = $sel_area;
	$totalresult->{id_genomeregion} = $idseqregion;
	$totalresult->{aliselect} = $self->{alignmentsbyid}->{$totalresult->{id_comparison}}->{description};
	$totalresult->{criteriaselect} = $self->{criteriabyid}->{$totalresult->{critereid}}->{label};
	$totalresult->{pctidentselect} = $self->{criteriabyid}->{$totalresult->{critereid}}->{ident_pct};
	$totalresult->{limbouselect} = $self->{criteriabyid}->{$totalresult->{critereid}}->{min_length_loop};
	$totalresult->{limbacselect} = $self->{criteriabyid}->{$totalresult->{critereid}}->{min_length_back};
	if ($limit1 eq '') {
	    $totalresult->{limit1} = -1;}
        else {
	    $totalresult->{limit1} = $limit1;}
	if ($limit2 eq '') {
	    $totalresult->{limit2} = -1;}
        else {
	    $totalresult->{limit2} = $limit2;}
	$totalresult->{size1} = $size1;
	$totalresult->{size2} = $size2;

	my $mapinfo=$self->{manager}->get_mapinfo('NAME' => $self->{mapname});
	if (defined $mapinfo) {
	    my $source = new CompAnalResultSource::MosaicResultSource::MosaicCompAnalResult($totalresult,$self->{manager}->{resultlogwindow});
	    $self->{manager}->add_results_from_source($self->{mapname},$source);
	}
    }
    $self->hide();

    return 1;
}


1;

