package CompAnalResultWidget;

use strict;
use FindBin;

use CompAnalResult;

use PreferencesHandler;

sub set_preferences {
    $CompAnalResultWidget::show_highlights=1;
    my $mugen=$PreferencesHandler::Preferences->getDocumentElement();
    my @nodes=$mugen->getElementsByTagName('highlights');
    my $highlights=shift @nodes;
    if (!defined $highlights) {
	my $doctype=$PreferencesHandler::Preferences->getDoctype();
	$doctype->addElementDecl('highlights','EMPTY');
	$doctype->addAttDef('highlights','visible','(true|false)','"true"');
	$highlights=$PreferencesHandler::Preferences->createElement('highlights');
	$highlights->setAttribute('visible','true');
	$mugen->appendChild($highlights);
    } else {
	$CompAnalResultWidget::show_highlights=0
	    if ($highlights->getAttribute('visible') eq 'false');
    }
}



BEGIN {
    PreferencesHandler::register_listener(\&set_preferences);
}

sub new {
    my $class=shift;
    my $layout=shift;
    my $height=shift;

    $height=4
	unless $height>0;

    my $self={};

    $self->{height_in_lines}=$height;
    $self->{layout}=$layout;
    $self->{next_begin}=0;
    $self->{next_end}=0;
    bless $self,$class;

    return $self;
}

sub id {
    my $self=shift;
    
    return $self->{companalresult}->{id};
}

sub layout {
    my $self=shift;
    return $self->{layout};
}

sub draw {
    my $self=shift;
    my $paintdevice=shift;
    my $strip=shift;

    if ($PhysicalMapStripSet::view_mode ==
	$PhysicalMapStripSet::BIRDSEYE_VIEW) {
	my ($startbase,$endbase)=$strip->get_bounds;
	my ($x_scale,$y_scale)=$strip->scale;
	my ($x_start,$y_start)=$strip->offset;
	
	my ($leftbound,$rightbound)=($startbase,$endbase);
	($leftbound,$rightbound)=($endbase,$startbase)
	    if ($startbase>$endbase);
	my $offset=0;
	my $factor=1;
	($offset,$factor)=(1.0,-1.0)
	    if ($startbase>$endbase);
	
	my $companalresult=$self->{companalresult};

	if ($CompAnalResultWidget::show_highlights) {
	    foreach my $hlight (@{$companalresult->{highlights}}) {
		my $boxstart=$hlight->{begin};
		my $boxend=$hlight->{end};
		if (($boxstart>=$leftbound && $boxstart<=$rightbound) ||
		    ($boxend>=$leftbound && $boxend<=$rightbound) ||
		    ($boxstart<$leftbound && $boxend>$rightbound)) {
		    $boxstart=$leftbound
			if ($boxstart<$leftbound);
		    $boxend=$rightbound
			if ($boxend>$rightbound);
		    my $frame=$hlight->{frame};
		    $frame='all'
			if (!defined $frame);
		    my $strand=$hlight->{strand};
		    my $amp_factor=0.9;
		    if ($frame eq 'all') {
			$amp_factor=2.7;
			$frame=2;
		    }
		    my $hthickness=$hlight->{thickness};
		    $hthickness=1.0
			if (!defined $hlight->{thickness});
		    my $vert_pos=ScalableFeatureWidget::get_vertical_position($strand,$frame);
		    my $vert_amp=$ScalableFeatureWidget::totalthickness;
		    $vert_amp*=$amp_factor
			if (ScalableFeatureWidget::are_frames_visible());	
		    
		    my $start_x=($boxstart-$leftbound)/($rightbound-$leftbound);
		    my $width=($boxend-$boxstart)/($rightbound-$leftbound);
		    
		    my $height=$vert_amp*$hthickness;
		    my $y=$vert_pos-$height/2.0;
		    my $color=$hlight->{color};
		    $color='red'
			if (!defined $color);
		    my $filled=$hlight->{filled};
		    $filled=1
			if (!defined $filled);
		    
		    $paintdevice->add_rectangle($x_start+($offset+$factor*$start_x)*$x_scale-$x_scale*$offset*$width,
						$y_start+$y*$y_scale,
						$width*$x_scale,
						$height*$y_scale,
						color=>$color,
						filled=>$filled);
		    if (defined $hlight->{label}) {
			my $label=$hlight->{label};
			my $halign=$hlight->{halign};
			$halign='middle'
			    if (!defined $halign);
			my $valign=$hlight->{valign};
			$valign='below'
			    if (!defined $valign);
			my $labcolor=$hlight->{labelcolor};
			$labcolor='blue'
			    if (!defined $labcolor);
			my $text_y=$vert_pos;
			if ($valign eq 'above') {
			    $text_y-=$height/2.0;
			    $valign='bottom';
			}
			if ($valign eq 'below') {
			    $text_y+=$height/2.0;
			    $valign='top';
			}
			if ($valign eq 'inside') {
			    $valign='middle';
			}
			
			my $text_x=$start_x+$width/2;
			$paintdevice->add_text($x_start+($offset+$factor*$text_x)*$x_scale,
					       $y_start+$text_y*$y_scale,
					       $hlight->{label},
					       color => $labcolor,
					       halign => $halign,
					       valign => $valign,
					       depth => 10);
		    }
		}
	    }
	}
    }
}

sub height_in_lines {
    my $self=shift;
    $self->{height_in_lines};
}

package CompAnalResultWidgetFactory;

use strict;

use FindBin;

BEGIN {

    my $subdir=$FindBin::Bin;
    %CompAnalResultWidgetFactory::Factory=();
    my @modules=<$subdir/CompAnalResultWidget/*.pm>;

    foreach my $module (@modules) {
	eval {
	    require $module;
	}
    }
}

sub get_widget_instance {
    my $companal_result= shift;
    my $id=uc $companal_result->id;

    return undef
	unless defined $CompAnalResultWidgetFactory::Factory{$id};

    return &{$CompAnalResultWidgetFactory::Factory{$id}}($companal_result);
}

1

