package CompAnalResultWidget::LinkPlotWidget;

use strict;

use FeatureWidget;

@CompAnalResultWidget::LinkPlotWidget::ISA=qw(CompAnalResultWidget);

BEGIN {
    $CompAnalResultWidgetFactory::Factory{LINKS}=sub { return new CompAnalResultWidget::LinkPlotWidget @_ };
}

sub new {
    my $class = shift;
    my $companalresult=shift;
    
    my $self = new CompAnalResultWidget('interlace',$companalresult->{height});

    $self->{companalresult}=$companalresult;
    $self->{real_start}=$self->{companalresult}->{start};
    $self->{real_end}=$self->{companalresult}->{end};
    bless $self,$class;

    return $self;
}


sub draw {
    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my ($startbase,$endbase)=$strip->get_bounds;
    my ($x_scale,$y_scale)=$strip->scale;
    my ($x_start,$y_start)=$strip->offset;

    my ($leftbound,$rightbound)=($startbase,$endbase);
    ($leftbound,$rightbound)=($endbase,$startbase)
	if ($startbase>$endbase);
    my $offset=0;
    my $factor=1;
    ($offset,$factor)=(1.0,-1.0)
	if ($startbase>$endbase);

    my ($nextstartbase,$nextendbase)=($self->{next_begin},
				      $self->{next_end});
    if (!$nextstartbase || !$nextendbase) {
	($nextstartbase,$nextendbase)=($startbase,$endbase);
    }
    
    my ($nextleftbound,$nextrightbound)=($nextstartbase,$nextendbase);
    ($nextleftbound,$nextrightbound)=($nextrightbound,$nextleftbound)
	if ($nextstartbase>$nextendbase);

    my $nextoffset=0;
    my $nextfactor=1;
    ($nextoffset,$nextfactor)=(1.0,-1.0)
	if ($self->{next_begin}>$self->{next_end});
	
    my $companalresult=$self->{companalresult};
    foreach my $link (@{$companalresult->{links}}) {
	my $xbasefrom=$link->{from};
	my $xbaseto=$link->{to};
	my $color=$link->{color};
	my $yfrom=0;
	my $yto=1.0;
	my $xfrompos=($xbasefrom-$leftbound)/($rightbound-$leftbound);
	my $xtopos=($xbaseto-$nextleftbound)/($nextrightbound-$nextleftbound);
	if (($xbasefrom >= $leftbound && $xbasefrom <= $rightbound) ||
	    ($xbaseto >= $nextleftbound && $xbaseto <= $nextrightbound)) {
	    if ($xfrompos<0) {
		$yfrom=-$xfrompos/abs($xtopos-$xfrompos);
		$xfrompos=0;
	    }
	    if ($xfrompos>1) {
		$yfrom=($xfrompos-1)/abs($xtopos-$xfrompos);
		$xfrompos=1;
	    }
	    if ($xtopos<0) {
		$yto=1.0+$xtopos/abs($xtopos-$xfrompos);
		$xtopos=0;
	    }
	    if ($xtopos>1) {
		$yto=1.0-($xtopos-1)/abs($xtopos-$xfrompos);
		$xtopos=1;
	    }
	    my $xfrom=$x_start+($offset+$factor*$xfrompos)*$x_scale;
	    my $xto=$x_start+($nextoffset+$nextfactor*$xtopos)*$x_scale;
	    $yfrom=$y_start+$yfrom*$y_scale;
	    $yto=$y_start+$yto*$y_scale;
	    $paintdevice->add_line($xfrom,$yfrom,$xto,$yto,'color'=>$color);
	    if ($paintdevice->isa('PaintDevice::ReactivePaintDevice') &&
		defined $link->{info}) {
		my $rectwidth=0.005*$x_scale;
		$paintdevice->add_reactive_zone($xfrom-$rectwidth,
						$yfrom-$rectwidth,
						$xfrom+$rectwidth,
						$yfrom+$rectwidth,
						$link);
		$paintdevice->add_reactive_zone($xto-$rectwidth,
						$yto-$rectwidth,
						$xto+$rectwidth,
						$yto+$rectwidth,
						$link);
	    }
	}
    }

    $self->CompAnalResultWidget::draw($paintdevice,$strip);

}

1
