package FeatureDataSource::AgmialFeatureDataSource;

use strict;

use DBI;
use DBD::Pg;
use Bio::Seq;
use Bio::SeqFeature::Generic;

use FeatureDataSource;
use PreferencesHandler;

@FeatureDataSource::AgmialFeatureDataSource::ISA=qw(FeatureDataSource);

sub set_preferences {
    my $mugen=$PreferencesHandler::Preferences->getDocumentElement();
    my @nodes=$mugen->getElementsByTagName("featuredatasources");
    my $fds=shift @nodes;
    my @nodes=$fds->getElementsByTagName("agmial",0);
    if (scalar(@nodes)==0) {
	my $doctype=$PreferencesHandler::Preferences->getDoctype();
	$doctype->addElementDecl("agmial","EMPTY");
	$doctype->addAttDef("agmial","host","CDATA","#REQUIRED");
	$doctype->addAttDef("agmial","dbname","CDATA","#REQUIRED");
	$doctype->addAttDef("agmial","user","CDATA","#REQUIRED");
	$doctype->addAttDef("agmial","passwd","CDATA","#REQUIRED");
	$doctype->addAttDef("agmial","enabled","(yes|no)",'"no"');
	my $agmial=$PreferencesHandler::Preferences->createElement("agmial");
	$agmial->setAttribute("host","127.0.0.1");
	$agmial->setAttribute("dbname","agmial");
	$agmial->setAttribute("user","unknown");
	$agmial->setAttribute("passwd","unknown");
	$agmial->setAttribute("enabled","no");
	$fds->appendChild($agmial);
    }
}


BEGIN {
    PreferencesHandler::register_listener(\&set_preferences);
}

my $BUFFSIZE=4096;

my $dbh=undef;

my %complete_genomes=();

sub init {
    my $res=0;
    if (!$dbh) {
	my @nodes=$PreferencesHandler::Preferences->getElementsByTagName("agmial");
	my $agmial=shift @nodes;
	if ($agmial) {
	    my $host=$agmial->getAttribute("host");
	    my $dbname=$agmial->getAttribute("dbname");
	    my $user=$agmial->getAttribute("user");
	    my $passwd=$agmial->getAttribute("passwd");
	    my $enabled=$agmial->getAttribute("enabled");
	    $dbh=DBI->connect("dbi:Pg:host=$host;dbname=$dbname",$user,$passwd)
		if ($enabled eq 'yes');
	}
    }
    $res=1
	if (defined $dbh);

    return $res;

}


sub _retrieve_by_access_number {
    my $self=shift;
    my $accessnumber=shift;
    my $start=shift;
    my $end=shift;
    my $qualifiers=shift;

    my %features=();
    my $sth=undef;
    my $sth2=undef;
    my $rv=undef;
    my $rowhash=undef;

    #(posmin>=$start and posmin<=$end) or (posmax>=$start and posmax<=$end) or (posmin<$start and posmax>$end
    #AND feature_layer_name = 'EDIT'
    #retrieve all locations for given access number
    my $location_restriction='';
    $location_restriction="AND posmin>=$start AND posmin<=$end AND posmax>=$start AND posmax<=$end" 
	if ($start>0 && $end>$start);
    $sth=$dbh->prepare("SELECT agmial_id, type_feat, posmin, posmax, 1 - 2 * strand AS mstrand FROM cam_feature WHERE contig_accession = '$accessnumber' AND feature_layer_name = 'EDIT' AND deletion_date IS NULL $location_restriction");


    $rv=$sth->execute;
    while ($rowhash=$sth->fetchrow_hashref()) {
	my $startpos_begin=$rowhash->{posmin};
	my $stoppos_end=$rowhash->{posmax};
	my $strand=$rowhash->{mstrand};
	my $type_feat=$rowhash->{type_feat};
	my $agmial_id=$rowhash->{agmial_id};
	$features{$agmial_id}={
	    start=>$startpos_begin,
	    end=>$stoppos_end,
	    strand=>$strand,
	    primary=>$type_feat,
	    tags => {}
	};
	
	my $rowhash2=undef;
	if (!$qualifiers) {
	    $sth2 = $dbh->prepare("SELECT type_qual, TRIM(BOTH '\"' FROM value_qual) AS qualifier FROM cam_qualifier WHERE contig_accession = '$accessnumber' AND feature_layer_name = 'EDIT' AND agmial_id = ? AND type_qual = ? AND value_qual <> '\"\"'");
	    $rv=$sth2->execute($agmial_id, "gene");
	    while ($rowhash2=$sth2->fetchrow_hashref()) {
		$features{$agmial_id}->{tags}->{$rowhash2->{type_qual}}=$rowhash2->{qualifier};
	    }
	    $rv=$sth2->execute($agmial_id, "product");
	    while ($rowhash2=$sth2->fetchrow_hashref()) {
		$features{$agmial_id}->{tags}->{$rowhash2->{type_qual}}=$rowhash2->{qualifier};
	    }
	    $sth2->finish();
	}
	else {
	    $sth2 = $dbh->prepare("SELECT type_qual, value_qual FROM cam_qualifier WHERE contig_accession = '$accessnumber' AND feature_layer_name = 'EDIT' AND agmial_id = ?");
	    while ($rowhash2=$sth2->fetchrow_hashref()) {
		$features{$agmial_id}->{tags}->{$rowhash2->{type_qual}}=$rowhash2->{value_qual};
	    }
	    $sth2->finish();
	}
    }


    #retrieve sequence for given access number.
    my $seq='';
    my $sequences='' ;
    $sth=$dbh->prepare("select dna_sequence from cam_contig where contig_accession = '$accessnumber'");
    $rv=$sth->execute;
    
    ## Modif Helene 19/12/02 => suppression lob de agmial
    $sth->bind_columns(\$sequences);
    $sth->fetch;
    $sth->finish();
    $seq=$sequences ;
    
    $seq=new Bio::Seq(-seq => $seq,
		      -id => 'agmial_retrieved_sequence',
		      -accession_number => $accessnumber);
    
    foreach my $feature (sort keys %features) {
	my $start=$features{$feature}->{start};
	my $end=$features{$feature}->{end};
	my $strand=$features{$feature}->{strand};
	my $primary=$features{$feature}->{primary};

	my $seqfeature=new Bio::SeqFeature::Generic(
						    -start => $start,
						    -end => $end,
						    -strand => $strand,
						    -primary => $primary,
						    -tag => $features{$feature}->{tags});
	$seq->add_SeqFeature($seqfeature);
    }

    return $seq;

}

sub _retrieve_by_organism {
    my $self=shift;
    my $organism=shift;
    my $start=shift;
    my $end=shift;
    my $qualifiers=shift;

    return undef
	if (!defined $complete_genomes{$organism});

    my $accession=$complete_genomes{$organism};
    
    
    return $self->_retrieve_by_access_number($accession,$start,$end,$qualifiers);
}

sub _retrieve_complete_genome_names {
    my $sth=$dbh->prepare("select cam_project.organism,cam_contig.contig_accession from cam_project,cam_batch,cam_contig where cam_project.project_name=cam_batch.project_name  and cam_batch.project_name=cam_contig.project_name and cam_contig.batch_nb in (select  max(batch_nb) from  cam_contig) ");

    my $rv=$sth->execute();
     while (my $rowhash=$sth->fetchrow_hashref()) {
	my $species=$rowhash->{organism};
	my $accession=$rowhash->{contig_accession};
	#my $type=$rowhash->{type};
	my $species_type="$species";
	$complete_genomes{$species_type}=$accession;

    


    }
}

sub get_complete_genome_names {

    _retrieve_complete_genome_names
	if (!scalar(keys(%complete_genomes)));

    my @complete_genome_names=();
    foreach my $species_type (sort keys %complete_genomes) {
	push @complete_genome_names,$species_type;
    }

    return @complete_genome_names;

}

sub get_access_number {
    my $organism=shift;

    _retrieve_complete_genome_names
	if (!scalar(keys(%complete_genomes)));

    return $complete_genomes{$organism};
}

sub new {
    my $class=shift;
    my %params=();

    $params{start}=-1;
    $params{end}=-1;
    $params{qualifiers}=0;
    while (my $paramname=shift) {
	$params{lc $paramname}=shift;
    }

    my $self=_new FeatureDataSource;

    bless $self,$class;

    my $seqobj=undef;

    if (!defined $dbh) {
	warn "Trying to use Agmial as data source without valid database connection.\n";
	return undef;
    }

    if (defined $params{organism} && defined $params{gene}) {
	$seqobj=$self->_retrieve_by_organism_gene($params{organism},
						  $params{gene},
						  $params{start},
						  $params{end},
						  $params{qualifiers});
    } elsif (defined $params{organism} && !defined $params{gene}) {
	$seqobj=$self->_retrieve_by_organism($params{organism},
					     $params{start},
					     $params{end},
					     $params{qualifiers});
    } elsif (defined $params{accessnumber}){
	$seqobj=$self->_retrieve_by_access_number($params{accessnumber},
						  $params{start},
						  $params{end},
						  $params{qualifiers});
    }

    $self->FeatureDataSource::_load_features($seqobj)
	if (defined $seqobj);
    
    return $self;
}

END {
    $dbh->disconnect()
	if (defined $dbh);
}

1
