package FeatureDataSource::GenBankFeatureDataSource;

use strict;

use Error qw(:try);

use Bio::SeqIO;
use Bio::DB::GenBank;

use FeatureDataSource;

$Error::Debug=1;

@FeatureDataSource::GenBankFeatureDataSource::ISA=qw(FeatureDataSource);

my $genbank=undef;

sub _init_genbank {
    $genbank=new Bio::DB::GenBank;
    $genbank->request_format('genbank');
}

sub new {
    my $class=shift;
    my %params=();

    while (my $paramname=shift) {
	$params{lc $paramname}=shift;
    }
 
    my $self=_new FeatureDataSource;
    bless $self,$class;

    _init_genbank()
	unless (defined $genbank);

    my $seq=undef;

    try {
	$seq=$genbank->get_Seq_by_acc([$params{accessnumber}]);
    }
    catch Bio::Root::Exception with {
	warn "GenBankFeatureDataSource :Unable to retrieve entry with ",
	"accessnumber ",$params{accessnumber},"\n";
    };

    if (defined $seq) {
	$self->FeatureDataSource::_load_features($seq);
    } else {
	$self=undef;
    }

    return $self;
    
}

1
