package FeatureDataSource::OrigamiFeatureDataSource;
 
use strict;

use Bio::Seq;
use Bio::SeqFeature::Generic;

use Data::Dumper;

use FeatureDataSource;
use Resources::Origami::OrigamiHandler;

@FeatureDataSource::OrigamiFeatureDataSource::ISA=qw(FeatureDataSource);

sub init {
    Resources::Origami::OrigamiHandler::init();
}

sub _retrieve_entry {
    my $self=shift;
    my $entry_id=shift;

    my $seqobj=undef;

    my $element=Resources::Origami::OrigamiHandler::getElementWithId($entry_id);
    my $organism=Resources::Origami::OrigamiHandler::getOrganismWithId($element->{organismId});
    my $sequence=Resources::Origami::OrigamiHandler::getSequenceOfElement($element);

    my $features=Resources::Origami::OrigamiHandler::getFeaturesOfElement($element);

    $seqobj=new Bio::Seq(-seq => $sequence,
			 -id => $organism->{name}." ".
			 $element->{type}." ".$element->{description},
			 -accession_number => $entry_id);

    foreach my $feature (@{$features}) {
	my $start=$feature->{start};
	my $stop=$feature->{stop};
	my $strand=$feature->{strand};
	my $type=$feature->{type};
	my $qualifiers=$feature->{qualifiers};
	my $tags={};
	for my $qualifier (@$qualifiers) {
	    $tags->{$qualifier->{'key'}}=$qualifier->{'value'};
	}
	my $seqfeature=new Bio::SeqFeature::Generic(-start => $start,
						    -end => $stop,
						    -strand => $strand,
						    -primary => $type,
						    -tag => $tags);
	$seqobj->add_SeqFeature($seqfeature);
    }

    return $seqobj;
}

sub  new {
    my $class = shift;
    my %params = ();

    while (my $paramname=shift) {
	$params{lc $paramname}=shift;
    }
    my $self= _new FeatureDataSource;

    bless $self,$class;

    my $seqobj=$self->_retrieve_entry($params{accessnumber});

    $self->FeatureDataSource::_load_features($seqobj)
	if (defined $seqobj);

    return $self;

}

1;

