package FeatureDataSourceWindow::OrigamiWindow;

use strict;

use FeatureDataSource::OrigamiFeatureDataSource;
use Resources::Origami::OrigamiHandler;

@FeatureDataSourceWindow::OrigamiWindow::ISA=qw(Gtk::Dialog);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog;
    $self->set_title('Origami Retrieval Window');
    $self->{manager}=$manager;


    if (Resources::Origami::OrigamiHandler::init) {
	my $organismcombo=new Gtk::Combo();
	my $organisms=Resources::Origami::OrigamiHandler::getAllOrganisms();
	my %orgsbyid=();
	foreach my $organism (@$organisms) {
	    $orgsbyid{$organism->{id}}={ -name =>$organism->{name},
					 -elements => []};
	}
	my $elements=Resources::Origami::OrigamiHandler::getElementsOfOrganisms($organisms);

	foreach my $element (@$elements) {
	    my $orgid=$element->{organismId};
	    push@{$orgsbyid{$orgid}->{-elements}},$element;
	}

	my @organismtab=();
	$self->{elementidsbydesc}={};
	foreach my $key (sort {$orgsbyid{$a}->{-name} cmp 
					$orgsbyid{$b}->{-name}} 
			      keys %orgsbyid) {
	    foreach my $element (@{$orgsbyid{$key}->{-elements}}) {
		my $desc=$orgsbyid{$key}->{-name}." ".$element->{type}." ".$element->{description};
		push @organismtab,$desc;
		$self->{elementidsbydesc}->{$desc}=$element->{id};
	    }
	}
	$organismcombo->set_popdown_strings(@organismtab);
	$organismcombo->entry->set_editable(0);
	$organismcombo->show();
	$self->{organismcombo}=$organismcombo;
	$self->vbox->pack_start($organismcombo,1,1,1);
	
	my $okbtn=new Gtk::Button('OK');
	$okbtn->show();
	$okbtn->signal_connect('clicked',sub { $self->ok_clicked()});
	$self->action_area->pack_start($okbtn,1,1,1);
	my $cancelbtn=new Gtk::Button('Cancel');
	$cancelbtn->show();
	$cancelbtn->signal_connect('clicked',sub {$self->hide(); return 1});
	$self->action_area->pack_start($cancelbtn,1,1,1);

    } else {
	my $errorlabel=new Gtk::Label("Origami unavailable.");
	$errorlabel->show();
	$self->vbox->pack_start($errorlabel,1,1,1);
	my $proceedbtn=new Gtk::Button('Proceed');
	$proceedbtn->show();
	$proceedbtn->signal_connect('clicked',sub {$self->hide(); return 1});
	$self->action_area->pack_start($proceedbtn,1,1,1);
    }

    bless $self,$class;

    return $self;
}


sub ok_clicked {
    my $self=shift;

    $self->hide();

    my %args=(qualifiers=>1);

    my $desc=$self->{organismcombo}->entry()->get_text();
    my $id=$self->{elementidsbydesc}->{$desc};
    $args{accessnumber}=$id;
    
    my $datasource=new FeatureDataSource::OrigamiFeatureDataSource(%args);
    
    $self->{manager}->_add_map_from_datasource($datasource);
    
    return 1;
}

1
