package PaintDevice::GtkPaintDevice;

use strict;

use Gtk 0.7002;

use PaintDevice::ReactivePaintDevice;

@PaintDevice::GtkPaintDevice::ISA=qw(PaintDevice::ReactivePaintDevice);

$PaintDevice::GtkPaintDevice::SCREEN_RESOLUTION=80; 
$PaintDevice::GtkPaintDevice::GTK_INIT=0;
$PaintDevice::GtkPaintDevice::FONT_HEIGHT_POINTS=11;

sub new {
    my $class = shift;

    my $self = _new PaintDevice::ReactivePaintDevice;    

    $self->{width}=shift;
    $self->{height}=shift;
    $self->{window_width}=$self->{width};
    $self->{window_height}=$self->{height};

    $self->{parent_widget}=shift;

    $self->{current_r_zone}=undef;

    bless $self,$class;
    
    return $self;
}


sub _process_r_zones {
    my $self=shift;
    my $widget=shift;
    my ($x,$y,$w,$h,$d)=$widget->window->get_geometry();
    my ($xp,$yp)=$widget->get_pointer();
    $xp/=$w;
    $yp/=$h;
    if (!defined $self->{current_r_zone}) {
	foreach my $zone (@{$self->{r_zones}}) {
	    if ($xp >=$zone->{xmin} && $xp<=$zone->{xmax} &&
		$yp >=$zone->{ymin} && $yp<=$zone->{ymax}) {
		$self->{current_r_zone}=$zone;
		my $userdata=$zone->{userdata};
		foreach my $listener (@{$self->{enter_listeners}}) {
		    $listener->reactive_zone_entered($xp,$yp,$userdata);
		}
		last;
	    }
	}
    } else {
	my $zone=$self->{current_r_zone};
	my $userdata=$zone->{userdata};
	if ($xp >=$zone->{xmin} && $xp<=$zone->{xmax} &&
	    $yp >=$zone->{ymin} && $yp<=$zone->{ymax}) {
	    foreach my $listener (@{$self->{move_listeners}}) {
		$listener->reactive_zone_moved($xp,$yp,$userdata);
	    }
	} else {
	    $self->{current_r_zone}=undef;
	}
    }
    return 1;
}


sub _process_r_zone_selection {
    my $self=shift;
    my $widget=shift;
    my ($x,$y,$w,$h,$d)=$widget->window->get_geometry();
    my ($xp,$yp)=$widget->get_pointer();
    $xp/=$w;
    $yp/=$h;

    my $zone=$self->{current_r_zone};
    if (defined $zone) {
	my $userdata=$zone->{userdata};
	foreach my $listener (@{$self->{select_listeners}}) {
	    $listener->reactive_zone_selected($xp,$yp,$userdata);
	}
    }
    return 1;
}

sub render_core {
    my $self=shift;
    my $layout = $self->{layout};
    my $width=$self->{width};
    my $height=$self->{height};

    return
	if (!$width || !$height);

    my $layoutwindow=$layout->window;

    my (undef, undef, undef, undef, $depth) = $layoutwindow->get_geometry;
    my $pixmap = new Gtk::Gdk::Pixmap($layoutwindow,$width,$height,$depth);

    my $gc=new Gtk::Gdk::GC $pixmap;
    my $font=load Gtk::Gdk::Font "fixed";
    my $font_height=$font->ascent+$font->descent;


    my %colortab = ();

    my $colormap=$layoutwindow->get_colormap;
    foreach my $color (keys (%PaintDevice::colortab)) {
	my $red=int($PaintDevice::colortab{$color}->{red}*65535);
	my $green=int($PaintDevice::colortab{$color}->{green}*65535);
	my $blue=int($PaintDevice::colortab{$color}->{blue}*65535);
	my $gtkcolor=$colormap->color_alloc({red=>$red,
					    green=>$green,
					    blue=>$blue});
	$colortab{$color}=$gtkcolor;

    }

    $gc->set_foreground($colortab{'white'});
    $pixmap->draw_rectangle($gc,1,0,0,$width,$height);
    for (my $depth=$#{$self->{primitives}};$depth>=0;$depth--) {
	for (my $shapeno=0;$shapeno<=$#{$self->{primitives}->[$depth]};
	     $shapeno++) {
	    my $shape=$self->{primitives}->[$depth]->[$shapeno];
	    $gc->set_foreground($colortab{$shape->{color}});
	    if ($shape->{type} eq 'line') {
		$pixmap->draw_line($gc,$shape->{x1}*($width-1),
				   $shape->{y1}*($height-1),
				   $shape->{x2}*($width-1),
				   $shape->{y2}*($height-1));
	    }
	    if ($shape->{type} eq 'text') {
		my $text_x=$shape->{x}*($width-1);
		my $halign=$shape->{halign};
		if ($halign eq 'right') {
		    $text_x-=$font->string_width($shape->{text});
		}
		if ($halign eq 'middle') {
		    $text_x-=$font->string_width($shape->{text})/2;
		}
		my $text_y=$shape->{y}*($height-1);
		my $valign=$shape->{valign};
		if ($valign eq 'top') {
		    $text_y+=$font->ascent;
		}
		if ($valign eq 'middle') {
		    $text_y+=$font_height/2;
		}
		if ($valign eq 'bottom') {
		    $text_y-=$font->descent;
		}
		$pixmap->draw_string($font,$gc,$text_x,
				     $text_y,$shape->{text});
	    }
	    if ($shape->{type} eq 'rectangle') {
		my $rwidth=$shape->{width}*$width;
		$rwidth=1
		    if ($rwidth<1);
		my $rheight=$shape->{height}*$height;
		$rheight=1
		    if ($rheight<1);
		$pixmap->draw_rectangle($gc,
					$shape->{filled},
					$shape->{x}*($width-1),
					$shape->{y}*($height-1),
					$rwidth,
					$rheight);
	    }
	    if ($shape->{type} eq 'circle') {
		my $rect_x=$shape->{x}*($width-1)-$shape->{radius}*$height;
		my $rect_y=$shape->{y}*($height-1)-$shape->{radius}*$height;
		my $side_length=$shape->{radius}*$height*2;
		$pixmap->draw_arc($gc,
				  $shape->{filled},
				  $rect_x,$rect_y,
				  $side_length,$side_length,
				  0,360*64);
	    }
	    if ($shape->{type} eq 'polygon') {
		my (@draw_points);
		for (my $i=0;$i<=$#{$shape->{x}};$i++) {
		    push @draw_points,$shape->{x}->[$i]*($width-1);
		    push @draw_points,$shape->{y}->[$i]*($height-1);
		}
		$pixmap->draw_polygon($gc,
				      $shape->{filled},
				      @draw_points);
	    }
	    if ($shape->{type} eq 'polyline') {
		my (@draw_points);
		for (my $i=0;$i<=$#{$shape->{x}};$i++) {
		    push @draw_points,$shape->{x}->[$i]*($width-1);
		    push @draw_points,$shape->{y}->[$i]*($height-1);
		    if ($i>0 && $i<$#{$shape->{x}}) {
			push @draw_points,$shape->{x}->[$i]*($width-1);
			push @draw_points,$shape->{y}->[$i]*($height-1);
		    }
		}
		$pixmap->draw_segments($gc,
				       @draw_points);
	    }
	}
    }

    $self->{pixmap}=$pixmap;
}

sub render_callback {
    my $self = shift;
    my $event=shift;

    return 1
	    if ($event->{count});

    return 1
	if (!$self->{width} || !$self->{height} || !$self->{area}->window);

    if ($self->{pixmap_update}) {
	$self->render_core;
	$self->{pixmap_update}=0;
    }

    my $window=$self->{area}->window;
    $window->set_back_pixmap($self->{pixmap},0);
    $window->clear();

    return 1;

}

sub render {

    my $self = shift;

    my $call_gtk_main=0;

    $self->{pixmap_update}=1;
    if (!defined($self->{parent_widget})) {
	if ( ! $PaintDevice::GtkPaintDevice::GTK_INIT) {
	    $PaintDevice::GtkPaintDevice::GTK_INIT=1;
	  Gtk::init($ARGV);
	}	
	$self->{window}=new Gtk::Window -toplevel;
	$self->{window}->set_usize($self->{window_width},
				   $self->{window_height});
	$self->{window}->signal_connect("destroy"=>sub{Gtk::main_quit($self->{window})});
	$call_gtk_main=1;
    } else {
	$self->{window}=$self->{parent_widget};
    }

    if (defined $self->{scrolledwindow}) {
	$self->{window}->remove($self->{scrolledwindow});
    }

 
   $self->{scrolledwindow}=new Gtk::ScrolledWindow;

    $self->{window}->add($self->{scrolledwindow});
    if (!defined $self->{callback_id}) {
	$self->{callback_id}=$self->{window}->signal_connect("expose_event"=>sub{PaintDevice::GtkPaintDevice::render_callback($self)});
    }

    $self->{layout}=new Gtk::Layout(0,0);
    $self->{layout}->set_size($self->{width},$self->{height});
    $self->{scrolledwindow}->add($self->{layout});


    $self->{area}=new Gtk::DrawingArea;
    $self->{area}->size($self->{width},$self->{height});
    $self->{area}->add_events('pointer_motion_mask');
    $self->{area}->signal_connect('motion_notify_event', sub {$self->_process_r_zones($self->{area})});
    $self->{area}->add_events('button_press_mask');
    $self->{area}->signal_connect('button_press_event', sub {$self->_process_r_zone_selection($self->{area})});
    $self->{layout}->put($self->{area},0,0);

 
    $self->{scrolledwindow}->show_all;
    if ($call_gtk_main) { 
	$self->{window}->show_all;
      Gtk::main($self->{window});
    }

}

sub set_window_size {
    my $self = shift;
    my $width = shift;
    my $height= shift;
    
    ($self->{window_width},$self->{window_height})=($width,$height);
}

sub text_width {
    my $self=shift;
    my $text=shift;

    my $font=load Gtk::Gdk::Font "fixed";
    my $width=$font->string_width($text);


    return $width;
}

sub text_height {
    my $self = shift;

    return $PaintDevice::GtkPaintDevice::FONT_HEIGHT_POINTS;
}

sub destroy {
    my $self=shift;

    return;

    if (defined $self->{area}) {
	$self->{area}->destroy();
    }
    
    if (defined $self->{layout}) {
	$self->{layout}->destroy();
    }
    if (defined $self->{scrolledwindow}) {
	$self->{window}->remove($self->{scrolledwindow});
	$self->{scrolledwindow}->destroy();
    }
}

1
