package PhysicalMap;

use strict;

use Bio::SeqIO;

use FeatureDataSource;
use CompAnalResult;

sub new {
    my $class= shift;
    my $datasource=shift;
    my $self = {};
    
    $self->{datasource}=$datasource;
    $self->{companalresults}=[];

    bless $self,$class;

    return $self;

}

sub get_datasource {
    my $self=shift;

    return $self->{datasource};
}

sub get_bounds {
    my $self=shift;

    return $self->{datasource}->get_bounds();
}


sub get_organism {
    my $self=shift;
    return $self->{datasource}->get_organism();
}


sub get_chromosome {
    my $self=shift;
    return $self->{datasource}->get_chromosome();
}

sub get_seqobj {
    my $self=shift;
    
    return $self->{datasource}->get_seqobj();
}

sub extract_features {
    my $self=shift;
    my $start=shift;
    my $end=shift;
    my $minsize=shift;

    ($start,$end)=($end,$start)
	if ($start>$end);

    return $self->{datasource}->extract_features($start,$end,$minsize);
}


sub extract_companal_results {
    my $self=shift;
    my $start=shift;
    my $end=shift;
    my @companalreslist;

    ($start,$end)=($end,$start)
	if ($start>$end);

    foreach my $companalres (@{$self->{companalresults}}){
	my ($loc_start,$loc_end)=$companalres->bounds();
	if ($loc_end >=$start && $loc_start <= $end) {
	    push @companalreslist,$companalres;
	}
#	if ($loc_start>=$start && $loc_start<=$end) {
#	    push @companalreslist,$companalres;
#	} else {
#	    if ($loc_end>=$start && $loc_end<=$end) {
#		push @companalreslist,$companalres;
#	    }
#	    else {
#		if ($loc_start<=$start && $loc_end>=$end) {
#		    push @companalreslist,$companalres;
#		}
#	    }
#	}
    }
    return @companalreslist;
}

sub get_feature_location {
    my $self=shift;
    my $feature=lc shift;
    my $qualifier=lc shift;
    my $qvalue=lc shift;

    return $self->{datasource}->get_feature_location($feature,$qualifier,
						     $qvalue);
}


sub add_comp_anal_results {
    my $self=shift;
    my $results=shift;

    foreach my $companalres (@$results) {
	my $display_id=$companalres->display_id;
	my ($start,$end)=$companalres->bounds;
	my $replace_index=-1;
	for (my $i=0;$i<=$#{$self->{companalresults}};$i++) {
	    $replace_index=$i
		if ($self->{companalresults}->[$i]->display_id eq $display_id);
	}
	if ($replace_index>=0) {
	    $self->{companalresults}->[$replace_index]=$companalres;
	} else {
	    push @{$self->{companalresults}},$companalres;
	}
    }
}

sub get_companal_result_ids {
    my   $self=shift;
    my @res=();

    foreach my $companalresult (@{$self->{companalresults}}) {
	push @res,$companalresult->id;
    }

    return @res;
}


sub get_companal_result_display_ids {
    my   $self=shift;
    my @res=();

    foreach my $companalresult (@{$self->{companalresults}}) {
	    push @res,$companalresult->display_id
		if (defined $companalresult->display_id);
    }

    return @res;
}

sub remove_companal_result_with_id {
    my $self=shift;
    my $id=shift;
    my @newres=();

    foreach my $companalresult (@{$self->{companalresults}}) {
	push @newres,$companalresult
	    if ($companalresult->id ne $id);
    }
    $self->{companalresults}=\@newres;
}


sub remove_companal_result_with_display_id {
    my $self=shift;
    my $display_id=shift;
    my @newres=();

    foreach my $companalresult (@{$self->{companalresults}}) {
	push @newres,$companalresult
	    if ($companalresult->display_id ne $display_id);
    }
    $self->{companalresults}=\@newres;
}

sub move_companal_result_with_display_id_up {

    my $self=shift;
    my $display_id=shift;

    my $index=-1;
    for (my $i=0;$i <= $#{$self->{companalresults}}; $i++) {
	$index=$i
	    if ($self->{companalresults}->[$i]->display_id eq $display_id);
    }

    if ($index>0 && defined) {
	($self->{companalresults}->[$index],$self->{companalresults}->[$index-1])=($self->{companalresults}->[$index-1],$self->{companalresults}->[$index]);
    }
}
sub move_companal_result_with_display_id_down {

    my $self=shift;
    my $display_id=shift;

    my $index=-1;
    for (my $i=0;$i <= $#{$self->{companalresults}}; $i++) {
	$index=$i
	    if ($self->{companalresults}->[$i]->display_id eq $display_id);
    }

    if ($index>=0 && defined $self->{companalresults}->[$index+1]) {
	($self->{companalresults}->[$index],$self->{companalresults}->[$index+1])=($self->{companalresults}->[$index+1],$self->{companalresults}->[$index]);
    }
}

sub get_companal_highlight_names {
    my   $self=shift;
    my   $display_id=shift;
    my @res=();

    foreach my $companalresult (@{$self->{companalresults}}) {
	    if  (defined $companalresult->display_id &&
		 $companalresult->display_id eq $display_id) {
		my $hlights=$companalresult->highlights;
		foreach my $hlight (@{$hlights}) {
		    push @res,$hlight->{label};
		}
	    }
    }
    return @res;
}

sub get_companal_highlight_bounds {
    my $self=shift;
    my $display_id=shift;
    my $highlight=shift;
    my @bounds=(-1,-1);

    foreach my $companalresult (@{$self->{companalresults}}) {
	    if  (defined $companalresult->display_id &&
		 $companalresult->display_id eq $display_id) {
		my $hlights=$companalresult->highlights;
		foreach my $hlight (@{$hlights}) {
		    if ($hlight->{label} eq $highlight) {
			@bounds=($hlight->{begin},$hlight->{end});
		    }
		}
	    }
    }
    return @bounds;
}

1
