package PreferencesHandler;

use strict;

use IO::File;
use XML::DOM;
use XML::Twig;

BEGIN {
    XML::DOM::ignoreReadOnly(1);
    my $doc=new XML::DOM::Document;
    my $decl=$doc->createXMLDecl("1.0","ISO-8859-1","yes");
    $doc->setXMLDecl($decl);
    my $doctype=$doc->createDocumentType("mugen");
    $doctype->addElementDecl("mugen","(featuredatasources|resultdatasources|mapdisplay|features|thresholds|highlights|links|browser)*");
    $doc->setDoctype($doctype);
    my $mugen=$doc->createElement("mugen");
      
    $doc->appendChild($mugen);
    $PreferencesHandler::Preferences=$doc;
    @PreferencesHandler::listeners=();
}


sub register_listener {
    my $listener=shift;
    push @PreferencesHandler::listeners,$listener;
    &$listener();
}

sub set_preferences_file {
    my $prefsfile=shift;
    $PreferencesHandler::PrefsFile=$prefsfile;
}

sub load_preferences {

    if (-r "$PreferencesHandler::PrefsFile") {
	my $parser=new XML::DOM::Parser;
	$PreferencesHandler::Preferences=$parser->parsefile($PreferencesHandler::PrefsFile);
    } else {
	warn ("Unable to load preferences from file $PreferencesHandler::PrefsFile. Application defaults will be used.\n");
    }

    foreach my $listener (@PreferencesHandler::listeners) {
	&$listener();
    }
}


sub save_preferences {
    
    my $twig=XML::Twig->new(pretty_print => 'indented');
    $twig->parse($PreferencesHandler::Preferences->toString());
    
    my $fh=new IO::File(">$PreferencesHandler::PrefsFile");
    $twig->flush($fh, Update_DTD =>1);
    $fh->close();
}

1;

