package CompAnalResult;

use strict;

sub new {
    my $class=shift;
    my $id=shift;
    my $comment=shift;
    my $self= {};
    bless $self,$class;
    $self->{id}=$id;
    $self->{comment}=$comment;
    $self->{start}=1e10;
    $self->{end}=-1;
    $self->{highlights}=[];
    $self->{type}='unknown';
    $self->{map}=undef;
    return $self;
}

sub bounds {
    my $self=shift;
    return ($self->{start},$self->{end});
}

sub id {
    my $self=shift;
    return $self->{id};
}

sub display_id {
    my $self=shift;
    return $self->{comment};
}

sub type {
    my $self=shift;
    return $self->{type};
}

sub set_type {
    my $self=shift;
    my $type=shift;

    $self->{type}=lc $type;
}

sub highlights {
    my $self=shift;
    return $self->{highlights};
}

sub _start_tagged_data {
}

sub _add_line {
}

sub _end_tagged_data {
}

1
