package CompAnalResultSource::CumulatedGCSkewSource;

use strict;

use Carp;

use Bio::Seq;
use Bio::Tools::SeqPattern;

use CompAnalResult::LinePlotResult;
use CompAnalResultSource;

@CompAnalResultSource::CumulatedGCSkewSource::ISA=qw(CompAnalResultSource);

sub _compute_gc_skew {
    my $self=shift;
    my $seqobj=shift;
    my $windowsize=shift;
    my $end=shift;
    my $mapname=shift;

    my $sequence=$seqobj->seq();
    my $seqlen=length $sequence;

    my $result=new CompAnalResult::LinePlotResult({'type' => 'separate',
						   'comment' => "GC skew of ".$mapname." w = $windowsize, endpoint = ".$end,
						   'smoothing' => 0.01});
						  



    $result->{start}=1;
    $result->{end}=$end;

    my $lineplot={};
    $lineplot->{start}=$windowsize/2;
    $lineplot->{frame}='all';
    $lineplot->{strand}='none';
    $lineplot->{step}=$windowsize;
    $lineplot->{data}=[];
    $sequence=~ tr/CG/cg/;
    my $skew=0;
    for (my $left=0; $left+$windowsize/2<$end; $left+=$windowsize) {
	my $window=substr $sequence,$left,$windowsize;
	my @cs = ($window =~ /c/g);
	my $nc=$#cs+1;
	my @gs = ($window =~ /g/g);
	my $ng=$#gs+1;

	my $skewpt=0;
	$skewpt=($ng-$nc)/($nc+$ng)
	    if ($nc+$ng > 0);
	$skew+=$skewpt;

	$result->{min}=$skew
	    if ($skew < $result->{min});

	$result->{max}=$skew
	    if ($skew > $result->{max});
	
	push @{$lineplot->{data}},$skew;
    }

    $result->{height}=11;

    push @{$result->{lineplots}},$lineplot;

    $lineplot={};
    $lineplot->{start}=$windowsize/2;
    $lineplot->{frame}='all';
    $lineplot->{strand}='none';
    $lineplot->{color}='blue';
    $lineplot->{step}=$end+$windowsize/2-1;
    $lineplot->{data}=[0.0,0.0];

    push @{$result->{lineplots}},$lineplot;

    return $result;
}

sub new {
    my $class=shift;
    my $seqobj=shift;
    my $windowsize=shift;
    my $end=shift;
    my $mapname=shift;
    my $self=_new CompAnalResultSource;

    bless $self,$class;

    my $result=$self->_compute_gc_skew($seqobj,$windowsize,$end,$mapname);

    push @{$self->{companalresults}},$result;

    return $self;
}

1;
