package CompAnalResultSourceWindow::OrigamiResultsWindow; 

use strict;

use CompAnalResultSourceWindow;
use Resources::Origami::OrigamiHandler;

@CompAnalResultSourceWindow::OrigamiResultsWindow::ISA=qw(Gtk::Dialog CompAnalResultSourceWindow);

my $false = 0;
my $true = 1;

sub new{
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog();

    bless $self,$class;

    $self->signal_connect('delete_event', sub {return 1});
    $self->signal_connect('destroy_event', sub {return 1});
    $self->set_title('Results from Origami');
    $self->set_modal( $true );
    $self->set_default_size( 400, 400 );
    $self->set_position('center');
	
    $self->{manager}=$manager;

    $self->_load_tree_data();

    $self->_create_organism_tree();
    $self->_create_result_tree();

  
      
    my $notebook = new Gtk::Notebook();
    $self->vbox->pack_start($notebook,$true,$true,0);

    my $tree_frame= new Gtk::Frame();
    my $tree_window = new Gtk::ScrolledWindow( undef, undef );
    $tree_window->set_usize( 30, 300 );
    $tree_window->set_policy( 'automatic', 'automatic' );
    $tree_window ->add_with_viewport( $self->{organism_tree} );
    $tree_window ->show();
    $tree_frame->add($tree_window);
    $tree_frame ->show();
    $notebook->append_page( $tree_frame ,new Gtk::Label("Origami by Organisms" ) );

    my $tree_frame= new Gtk::Frame();
    my $tree_window = new Gtk::ScrolledWindow( undef, undef );
    $tree_window->set_usize( 30, 300 );
    $tree_window->set_policy( 'automatic', 'automatic' );   
    $tree_window ->add_with_viewport(  $self->{result_tree} );
    $tree_window ->show();
    $tree_frame->add($tree_window);
    $tree_frame ->show();
    $notebook->append_page( $tree_frame ,new Gtk::Label("Origami by Results" ) );
    
    $notebook->set_page( 0 );
    $notebook->show();
    
    my $action_area=$self->action_area();
    
    my $bouton_ok=new Gtk::Button( "OK" );
    $bouton_ok->set_usize( 100, 20 );
    $bouton_ok->show();
    $bouton_ok->signal_connect('clicked',sub {$self->_load_results()});
    $action_area->pack_start($bouton_ok,$false,$false,0);
    $self->{'button_ok'} =  $bouton_ok;
    
    my $bouton_cancel =new Gtk::Button("Cancel");
    $bouton_cancel->set_usize( 100, 20 );
    $bouton_cancel->show();
    $bouton_cancel->signal_connect( 'clicked',sub{$self->hide();return 1;});
    $action_area->pack_start($bouton_cancel,$false,$false,0);

    return $self;  	
}

sub _load_tree_data {
    
    my $self=shift;

    $self->{organisms}=Resources::Origami::OrigamiHandler::getAllOrganisms();
    $self->{organismsbyid}={};
    foreach my $organism (@{$self->{organisms}}) {
	$self->{organismsbyid}->{$organism->{id}}=$organism;
    }
    
    $self->{elements}=Resources::Origami::OrigamiHandler::getElementsOfOrganisms($self->{organisms});
    $self->{elementsbyid}={};
    foreach my $element (@{$self->{elements}}) {
	$self->{elementsbyid}->{$element->{id}}=$element;
    }
    
    $self->{resulttypes}=Resources::Origami::OrigamiHandler::getResultTypes();	
    $self->{resulttypesbyid}={};
    foreach my $resulttype (@{$self->{resulttypes}}) {
	$self->{resulttypesbyid}->{$resulttype->{id}}=$resulttype;
    }

    my $results=Resources::Origami::OrigamiHandler::getResultsOfElements($self->{elements});
    my @tmptotalresults=();
    foreach my $result (@$results) {
	push @tmptotalresults,{result => $result,
			       organism => $self->{organismsbyid}->
			       {$result->{organismId}},
				   element => $self->{elementsbyid}->
			       {$result->{elementId}},
			       };
    }

    @{$self->{totalresults}}=
	sort {$a->{organism}->{name} cmp $b->{organism}->{name}}
    @tmptotalresults;

    return 1;  
}

sub _create_organism_tree {
    
    my $self = shift;

    $self->{organism_tree}=new Gtk::Tree();
    $self->{organism_tree}->set_selection_mode('single');
    $self->{organism_tree}->set_view_mode('item');
    $self->{organism_tree}->show();  

    my $rootitem = new_with_label Gtk::TreeItem('Organisms');
    $rootitem->show();   
    $self->{organism_tree}->append($rootitem);

    my $rootsubtree = new Gtk::Tree();
    $rootsubtree->show();
    $rootitem ->set_subtree($rootsubtree);
   
    my %orgitemsbyid=();

    foreach my $organism (sort {$a->{name} cmp $b->{name}} 
			  @{$self->{organisms}}) {
	my $orgitem=new_with_label Gtk::TreeItem($organism->{name});
	$orgitemsbyid{$organism->{id}}=$orgitem;
	$orgitem->show();
	$rootsubtree->append($orgitem);

	my $orgsubtree=new Gtk::Tree();
	$orgsubtree->show();
	$orgsubtree->set_view_mode('item');  
	$orgitem->set_subtree($orgsubtree);
    }

    my %eltitemsbyid=();

    foreach my $element (sort {$a->{type}." ".$a->{description} cmp
				   $b->{type}." ".$b->{description}}
			 @{$self->{elements}}) {
	my $eltitem=new_with_label Gtk::TreeItem($element->{type}." ".
						 $element->{description});
	$eltitem->show();
	$eltitemsbyid{$element->{id}}=$eltitem;
	$orgitemsbyid{$element->{organismId}}->subtree->append($eltitem);

	my $eltsubtree=new Gtk::Tree();
	$eltsubtree->show();
	$eltsubtree->set_view_mode('item');  
	$eltitem->set_subtree($eltsubtree);
    }


    foreach my $totalresult (@{$self->{totalresults}}) {
	my $result=$totalresult->{result};
	my $resulttype=$self->{resulttypesbyid}->{$result->{typeId}};

	my $resultitem=new_with_label Gtk::TreeItem($resulttype->{description});
	$resultitem->show();
	$resultitem->{handler}=$resultitem->signal_connect('select', 
				    sub {$self->_result_selected($resultitem)});
	$resultitem->{totalresult}=$totalresult;

	my $eltitem=$eltitemsbyid{$totalresult->{element}->{id}};
	$eltitem->subtree->append($resultitem);
    }

    $rootitem->expand();
}


sub _create_result_tree {
    
    my $self = shift;

    $self->{result_tree}=new Gtk::Tree();
    $self->{result_tree}->set_selection_mode('single');
    $self->{result_tree}->set_view_mode('item');
    $self->{result_tree}->show();  

    my $rootitem = new_with_label Gtk::TreeItem('Results');
    $rootitem->show();   
    $self->{result_tree}->append($rootitem);

    my $rootsubtree = new Gtk::Tree();
    $rootsubtree->show();
    $rootitem ->set_subtree($rootsubtree);
   
    my %resultitemsbyid=();

    foreach my $resulttype (@{$self->{resulttypes}}) {
	my $resultitem=new_with_label Gtk::TreeItem($resulttype->{description});
	$resultitemsbyid{$resulttype->{id}}=$resultitem;
	$resultitem->show();
	$rootsubtree->append($resultitem);

	my $resultsubtree=new Gtk::Tree();
	$resultsubtree->show();
	$resultsubtree->set_view_mode('item');
	$resultitem->set_subtree($resultsubtree);
	$resultitem->{orgitems}={};
    }


    foreach my $totalresult (sort {

	my $orga=$a->{organism};
	my $elta=$a->{element};
	my $stringa=$orga->{name}." ".$elta->{type}." ".$elta->{description};

	my $orgb=$b->{organism};
	my $eltb=$b->{element};
	my $stringb=$orgb->{name}." ".$eltb->{type}." ".$eltb->{description};

	return $stringa cmp $stringb

    }@{$self->{totalresults}}) {
	my $result=$totalresult->{result};
	my $organism=$totalresult->{organism};
	my $element=$totalresult->{element};

	my $resultitem=$resultitemsbyid{$result->{typeId}};
	my $orgitem=$resultitem->{orgitems}->{$organism->{id}};
	if (!defined $orgitem) {
	    $orgitem=new_with_label Gtk::TreeItem($organism->{name});
	    $orgitem->show();
	    $resultitem->{orgitems}->{$organism->{id}}=$orgitem;
	    $resultitem->subtree->append($orgitem);
	    $orgitem->{eltitems}={};

	    my $orgsubtree=new Gtk::Tree();
	    $orgsubtree->show();
	    $orgsubtree->set_view_mode('item');  
	    $orgitem->set_subtree($orgsubtree);
	}

	my $eltitem=$orgitem->{eltitems}->{$element->{id}};
	if (!defined $eltitem) {
	    $eltitem=new_with_label Gtk::TreeItem($element->{type}." - ".
						  $element->{description});
	    $eltitem->show();
	    $eltitem->{totalresult}=$totalresult;
	    $eltitem->signal_connect('select',
				    sub {$self->_result_selected($eltitem)});	    $orgitem->subtree->append($eltitem);
	    $orgitem->{eltitems}->{$element->{id}}=$eltitem;
	}

    }

    $rootitem->expand();
}

sub _result_selected {
    my $self=shift;
    my $resultitem=shift;
    
    my $totalresult=$resultitem->{totalresult};
    my $result=$totalresult->{result};
    my $resulttype=$self->{resulttypesbyid}->{$result->{typeId}};

    my $description=$resulttype->{description};

    if (($description =~ /Gene Context Conservation/ ||
	$description =~ /Orthology Map/ ||
	$description =~ /Genome Subtraction/) &&
	!defined $totalresult->{selement}) {
	$self->_load_related_elements($resultitem);
	$resultitem->signal_disconnect($resultitem->{handler});
    } else {
	$self->{selectedresult}=$totalresult;
    }

    return 1;
}


sub _load_results  {
    my $self=shift;
    my $totalresult=$self->{selectedresult};

    my $mapinfo=$self->{manager}->get_mapinfo('NAME' => $self->{mapname});
    if (defined $mapinfo) {
	my $source = new CompAnalResultSource::OrigamiResultSource($totalresult,$self->{manager}->{resultlogwindow});
	$self->{manager}->add_results_from_source($self->{mapname},$source);
    }

    $self->hide();

    return 1;
}

sub _load_related_elements {
    my $self=shift;
    my $resultitem=shift;

    my $totalresult=$resultitem->{totalresult};

    my $selementsubtree=new Gtk::Tree();
    $selementsubtree->set_view_mode('item');  
    $selementsubtree->show();

    $resultitem->set_subtree($selementsubtree);

    my $selements = Resources::Origami::OrigamiHandler::getRelatedElementsOfResult($totalresult->{result});
	    
    foreach my $selement (sort {
	my $asorganism=$self->{organismsbyid}->{$a->{organismId}};
	my $astring=$asorganism->{name}." / ".$a->{type}." ".$a->{description};
	my $bsorganism=$self->{organismsbyid}->{$b->{organismId}};
	my $bstring=$bsorganism->{name}." / ".$b->{type}." ".$b->{description};
	return $astring cmp $bstring;
    }@$selements){
	my $newtotalresult={};
	foreach my $key (keys %$totalresult) {
	    $newtotalresult->{$key}=$totalresult->{$key};
	}
	my $sorganism=$self->{organismsbyid}->{$selement->{organismId}};
	my $selementitem=new_with_label Gtk::TreeItem($sorganism->{name}." / ".$selement->{type}." ".$selement->{description});
	$selementitem->{handler}=$selementitem->signal_connect('select',sub {$self->_result_selected($selementitem)});
	$selementitem->show();
	$newtotalresult->{selement}=$selement;
	$newtotalresult->{sorganismname}=$self->{organismsbyid}->{$selement->{organismId}}->{name};
	$selementitem->{totalresult}=$newtotalresult;
	$resultitem->subtree->append($selementitem);
    }
    $resultitem->expand();
}

1;

