package CompAnalResultSourceWindow::PatternSearchWindow;

use strict;

use CompAnalResultSourceWindow;

@CompAnalResultSourceWindow::PatternSearchWindow::ISA=qw(Gtk::Dialog CompAnalResultSourceWindow);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog();
    $self->set_title("Pattern Search");

    my $vbox=$self->vbox();
    
    my $hbox=new Gtk::HBox();
    $hbox->show();
    $vbox->pack_start($hbox,1,1,0);

    
    my $label=new Gtk::Label("Pattern");
    $label->show();
    $hbox->pack_start($label,1,1,0);

    my $entry=new Gtk::Entry();
    $entry->show();
    $hbox->pack_start($entry,1,1,0);
    $self->{patternentry}=$entry;

    my $strandbox=new Gtk::VBox();
    $strandbox->show();
    $vbox->pack_start($strandbox,1,1,0);
    my $chkbtn=new Gtk::CheckButton("Forward strand");
    $chkbtn->show();
    $chkbtn->set_active(1);
    $strandbox->pack_start($chkbtn,1,1,0);
    $self->{fwbtn}=$chkbtn;

    $chkbtn=new Gtk::CheckButton("Reverse strand");
    $chkbtn->show();
    $chkbtn->set_active(1);
    $strandbox->pack_start($chkbtn,1,1,0);
    $self->{bwbtn}=$chkbtn;

    my $action_area=$self->action_area();

    my $btn=new Gtk::Button("OK");
    $btn->signal_connect('clicked',sub {$self->hide(); $self->ok_clicked();});
    $btn->show();
    $action_area->pack_start($btn,1,1,0);

    my $btn=new Gtk::Button("Cancel");
    $btn->signal_connect('clicked',sub {$self->hide(); return 1;});
    $btn->show();
    $action_area->pack_start($btn,1,1,0);

    $self->{manager}=$manager;

    bless $self,$class;

    return $self;
}

sub ok_clicked {
    my $self=shift;

    my $pattern=$self->{patternentry}->get_text();
    my $fw=$self->{fwbtn}->get_active();
    my $bw=$self->{bwbtn}->get_active();

    my $mapinfo=$self->{manager}->get_mapinfo('NAME' => $self->{mapname});
    if (defined $mapinfo) {
	my $seqobj=$mapinfo->get_map()->get_seqobj();
	my $source=new CompAnalResultSource::PatternSearchSource($seqobj,
							     $pattern,$fw,$bw);

	$self->{manager}->add_results_from_source($self->{mapname},$source);
    }
    return 1;
}
