package CompAnalResultWidget::BoxPlotWidget;

use strict;

use FeatureWidget;
use PhysicalMapStrip;

@CompAnalResultWidget::BoxPlotWidget::ISA=qw(CompAnalResultWidget);

BEGIN {
    $CompAnalResultWidgetFactory::Factory{BOXPLOT}=sub { return new CompAnalResultWidget::BoxPlotWidget @_ };
}

sub new {
    my $class = shift;
    my $companalresult=shift;
    
    my $widgettype=$companalresult->{type};
    $widgettype='interlace'
	if ($widgettype eq 'separate');
    my $self = new CompAnalResultWidget($widgettype);

    $self->{companalresult}=$companalresult;
    bless $self,$class;

    return $self;
}

sub draw {

    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my ($startbase,$endbase)=$strip->get_bounds;

    my ($x_scale,$y_scale)=$strip->scale;
    my ($x_start,$y_start)=$strip->offset;

    my ($leftbound,$rightbound)=($startbase,$endbase);
    ($leftbound,$rightbound)=($endbase,$startbase)
	if ($startbase>$endbase);
    my $offset=0;
    my $factor=1;
    ($offset,$factor)=(1.0,-1.0)
	if ($startbase>$endbase);

    my $companalresult=$self->{companalresult};


   foreach my $box (@{$companalresult->{boxes}}) {
	my $boxstart=$box->{begin};
	my $boxend=$box->{end};
	if (($boxstart>=$leftbound && $boxstart<=$rightbound) ||
	    ($boxend>=$leftbound && $boxend<=$rightbound) ||
	    ($boxstart<$leftbound && $boxend>$rightbound)) {
	    $boxstart=$leftbound
		if ($boxstart<$leftbound);
	    $boxend=$rightbound
		if ($boxend>$rightbound);
	    my $frame=$box->{frame};
	    $frame=undef
		if ($frame eq 'none');
	    my $strand=$box->{strand};
	    my $vert_amp=1;
	    my $vert_pos=0.5;
	    if ($self->{layout} eq 'overlay' ||
		$self->{layout} eq 'feature_overlay') {
		my $amp_factor=0.9;
		if ($frame eq 'all') {
		    $amp_factor=2.7;
		    $frame=2;
		}

		$vert_amp=$ScalableFeatureWidget::totalthickness;
		$vert_amp*=$amp_factor
		    if (ScalableFeatureWidget::are_frames_visible());	
		$vert_pos=ScalableFeatureWidget::get_vertical_position($strand,$frame);	    
	    }
	    if ($self->{layout} eq 'sequence_overlay') {
		if ($PhysicalMapStripSet::view_mode == 
		    $PhysicalMapStripSet::SEQUENCE_VIEW) {
		    $vert_amp=0.25;
		    $vert_pos=$AxisStrip::Y_SEQ_FWD-$vert_amp*$box->{thickness}/2
			if ($strand>=0);
		    $vert_pos=$AxisStrip::Y_SEQ_REV-$vert_amp*$box->{thickness}/2
			if ($strand==-1);
		} else {
		    $vert_amp=0.5;
		    $vert_pos=$AxisStrip::AXIS_POS-$vert_amp*$box->{thickness}/2
			if ($strand>=0);
		    $vert_pos=$AxisStrip::AXIS_POS+$vert_amp*$box->{thickness}/2
			if ($strand==-1);
		}
	    }
	    my $start_x=($boxstart-$leftbound)/($rightbound-$leftbound);
	    my $width=abs($boxend-$boxstart)/($rightbound-$leftbound);
	    
	    my $height=$vert_amp*$box->{thickness};

	    my $y=$vert_pos-$height/2;

	    $paintdevice->add_rectangle($x_start+($offset+$factor*$start_x-$offset*$width)*$x_scale,
					$y_start+$y*$y_scale,
					$width*$x_scale,
					$height*$y_scale,
					color=>$box->{color},
					filled=>$box->{filled});

	    
	    if ($paintdevice->isa('PaintDevice::ReactivePaintDevice') &&
		(defined $box->{info} || defined $box->{link})) {
		my $xmin=$x_start+($offset+$factor*$start_x-$offset*$width)*$x_scale;
		my $xmax=$xmin+$width*$x_scale;
		my $ymin=$y_start+$y*$y_scale;
		my $ymax=$ymin+$height*$y_scale;
		$paintdevice->add_reactive_zone($xmin,$ymin,$xmax,$ymax,$box);
	    }

	    if (defined $box->{label} &&
		$PhysicalMapStripSet::view_mode !=
		$PhysicalMapStripSet::BIRDSEYE_VIEW &&
		$width > $ScalableFeatureWidget::display_threshold) {
		my $label=$box->{label};
		my $halign=$box->{halign};
		my $valign=$box->{valign};
		my $labcolor=$box->{labelcolor};
		my $text_y=$vert_pos;
		if ($valign eq 'above') {
		    $text_y-=$height/2.0;
		    $valign='bottom';
		}
		if ($valign eq 'below') {
		    $text_y+=$height/2.0;
		    $valign='top';
		}
		if ($valign eq 'inside') {
		    $valign='middle';
		}

		my $text_x=$start_x+$width/2;
		if (($halign eq 'left' && $factor==1) ||
		    ($halign eq 'right' && $factor==-1)) {
		    $text_x=$start_x;
		}
		if (($halign eq 'right' && $factor==1)||
		    ($halign eq 'left' && $factor==-1)){
		    $text_x=$start_x+$width;
		}
		$paintdevice->add_text($x_start+($offset+$factor*$text_x)*$x_scale,
				       $y_start+$text_y*$y_scale,
				       $box->{label},
				       color => $labcolor,
				       halign => $halign,
				       valign => $valign,
				       depth => 10);
	    }
	}
    }
    

    $self->CompAnalResultWidget::draw($paintdevice,$strip);

}


1
