package CompAnalResultWidget::HistogramWidget;

use strict;

@CompAnalResultWidget::HistogramWidget::ISA=qw(CompAnalResultWidget);

BEGIN {
    $CompAnalResultWidgetFactory::Factory{HISTOGRAM}=sub { return new CompAnalResultWidget::HistogramWidget @_ };
}

sub new {
    my $class = shift;
    my $companalresult=shift;
    
    my $height=$companalresult->{height};
    my $self = new CompAnalResultWidget('interlace',$height);

    $self->{companalresult}=$companalresult;
    bless $self,$class;

    return $self;
}

sub draw {
    my $self = shift;
    my $paintdevice = shift;
    my $strip = shift;

    my ($startbase,$endbase)=$strip->get_bounds;
    my ($x_scale,$y_scale)=$strip->scale;
    my ($x_start,$y_start)=$strip->offset;

    my ($leftbound,$rightbound)=($startbase,$endbase);
    ($leftbound,$rightbound)=($endbase,$startbase)
	if ($startbase>$endbase);
    my $offset=0;
    my $factor=1;
    ($offset,$factor)=(1.0,-1.0)
	if ($startbase>$endbase);

    my $companalresult=$self->{companalresult};
    my $maxval=$companalresult->{max};
    foreach my $bar (@{$companalresult->{bars}}) {
	my $barstart=$bar->{start};
	my $barend=$barstart+$bar->{width}-1;
	if (($barstart>=$leftbound && $barstart<=$rightbound) ||
	    ($barend>=$leftbound && $barend<=$rightbound) ||
	    ($barstart<$leftbound && $barend>$rightbound)) {
	    $barstart=$leftbound
		if ($barstart<$leftbound);
	    $barend=$rightbound
		if ($barend>$rightbound);

	    my $start_x=($barstart-$leftbound)/($rightbound-$leftbound);
	    my $width=abs($barend-$barstart)/($rightbound-$leftbound);
	    
	    my $height=$bar->{height}/$maxval;

	    $paintdevice->add_rectangle($x_start+($offset+$factor*$start_x-$offset*$width)*$x_scale,
					$y_start+(1-$height)*$y_scale,
					$width*$x_scale,
					$height*$y_scale,
					color=>$bar->{color},
					filled=>$bar->{filled});

	    if ($paintdevice->isa('PaintDevice::ReactivePaintDevice') &&
		defined $bar->{info}) {
		my $xmin=$x_start+($offset+$factor*$start_x-$offset*$width)*$x_scale;
		my $xmax=$xmin+$width*$x_scale;
		my $ymin=$y_start+(1-$height)*$y_scale;
		my $ymax=$ymin+$height*$y_scale;
		$paintdevice->add_reactive_zone($xmin,$ymin,$xmax,$ymax,$bar);
	    }



	}
    }

    $self->CompAnalResultWidget::draw($paintdevice,$strip);

}


1
