package ExternalViewerLinker;

use PreferencesHandler;

sub set_preferences {

    my $mugen=$PreferencesHandler::Preferences->getDocumentElement();
    my $doctype=$PreferencesHandler::Preferences->getDoctype();
    my @nodes=$mugen->getElementsByTagName('links');
    my $links=shift @nodes;
    if (!defined $links) {
	$doctype->addElementDecl('links','(link*)');
	$doctype->addElementDecl('link','EMPTY');
	$doctype->addAttDef('link','id','CDATA','#REQUIRED');
	$doctype->addAttDef('link','name','CDATA','#REQUIRED');
	$doctype->addAttDef('link','url','CDATA','#REQUIRED');
	
	$links=$PreferencesHandler::Preferences->createElement('links');
	$mugen->appendChild($links);

	%ExternalViewerLinker::dbLinks=(
					'GI' => 
					{ name =>'GenPept', url => "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=Protein&dopt=GenPept&list_uids="},
					'taxon' => 
					{ name => 'Taxonomy', url => "http://www.ncbi.nlm.nih.gov/htbin-post/Taxonomy/wgetorg?mode=Info&id="},
					'SWISS-PROT' => { name => 'SwissProt', url => 'http://us.expasy.org/cgi-bin/niceprot.pl?'}
					);
	foreach my $linkid (sort keys %ExternalViewerLinker::dbLinks) {
	    my $name=$ExternalViewerLinker::dbLinks{$linkid}->{name};
	    my $url=$ExternalViewerLinker::dbLinks{$linkid}->{url};
	    my $link=$PreferencesHandler::Preferences->createElement('link');
	    $link->setAttribute('id',$linkid);
	    $link->setAttribute('name',$name);
	    $link->setAttribute('url',$url);
	    $links->appendChild($link);
	}
    } else {
	%ExternalViewerLinker::dbLinks=();
	my @nodes=$links->getElementsByTagName('link');
	foreach my $link (@nodes) {
	    my $id=$link->getAttribute('id');
	    my $name=$link->getAttribute('name');
	    my $url=$link->getAttribute('url');
	    $ExternalViewerLinker::dbLinks{$id}={name => $name, url => $url};
	    
	}
    }

    @nodes=$mugen->getElementsByTagName('browser');
    my $browser=shift @nodes;
    if (!defined $browser) {
	$ExternalViewerLinker::browser_command="mozilla -remote 'openURL(_URL_)' || mozilla \"_URL_\" ";
	$doctype->addElementDecl('browser','EMPTY');
	$doctype->addAttDef('browser','command','CDATA','#REQUIRED');
	$browser=$PreferencesHandler::Preferences->createElement('browser');
	$browser->setAttribute('command',$ExternalViewerLinker::browser_command);
	$mugen->appendChild($browser);
    } else {
	$ExternalViewerLinker::browser_command=$browser->getAttribute('command');
    }
}


BEGIN {
    PreferencesHandler::register_listener(\&set_preferences);
}

sub new {
    my $class=shift;
    my $self={};

    bless $self,$class;

    return $self;
    
}

sub reactive_zone_selected {
    my $self=shift;
    my ($x,$y)=(shift,shift);
    my $userdata=shift;

    my $menu=new Gtk::Menu;
    my $menuitem;
    my $items=0;
    if (UNIVERSAL::isa($userdata,'UNIVERSAL') &&
	$userdata->isa('Bio::SeqFeatureI') && $userdata->has_tag('db_xref')) {
	foreach my $xref ($userdata->each_tag_value('db_xref')) {
	    my ($db,$id)=split(':',$xref);
	    if (defined $ExternalViewerLinker::dbLinks{$db}) {
		my $url=undef;
		my $urlname=undef;
#		if ($db eq 'PID') {
#		    if ($id =~ /(\w)(\d+)/) {
#			my ($subdb,$subid) = ($1,$2);
#			if (defined $dbIDs{'PID'}->{$subdb}) {
#			    $url= $dbIDs{'PID'}->{$subdb}->{url}."$subid";
#			    $urlname= $dbIDs{'PID'}->{$subdb}->{name};
#			}
#		    }
#		} else {
		    $url=$ExternalViewerLinker::dbLinks{$db}->{url}."$id";
		    $urlname=$ExternalViewerLinker::dbLinks{$db}->{name};
#		}

		if (defined $url && defined $urlname) {
		    if ($items==0) {
			$menuitem=new Gtk::MenuItem("External Database Links");
			$menuitem->show();
			$menu->append($menuitem);
			$menuitem=new Gtk::MenuItem;
			$menuitem->show();
			$menu->append($menuitem);
		    }
		    $menuitem=new Gtk::MenuItem("$urlname");
		    $menuitem->signal_connect('activate',sub { $self->view_link($url)});
		    $menuitem->show();
		
		    $menu->append($menuitem);
		    $items++;
		}

	    }
	}
    }

    if ($items == 0) {
	$menuitem=new Gtk::MenuItem ("No External Links Available");
	$menuitem->set_sensitive(0);
	$menu->append($menuitem);
	$menuitem->show();
    }

    $menu->popup(0,0,1,0);
}

sub view_link {
    my $self=shift;
    my $url=shift;
    
    my $command=$ExternalViewerLinker::browser_command;

    $command=~ s/_URL_/$url/g;

    system("$command &");

    return 1;
}

1
