package FeatureDataSource::EMBLFeatureDataSource;

use strict;

use Error qw(:try);

use Bio::SeqIO;
use Bio::DB::EMBL;

use FeatureDataSource;

$Error::Debug=1;

@FeatureDataSource::EMBLFeatureDataSource::ISA=qw(FeatureDataSource);

my $embl=undef;

sub _init_embl {
    $embl=new Bio::DB::EMBL;
    $embl->request_format('embl');
}

sub new {
    my $class=shift;
    my %params=();

    while (my $paramname=shift) {
	$params{lc $paramname}=shift;
    }
 
    my $self=_new FeatureDataSource;
    bless $self,$class;

    _init_embl()
	unless (defined $embl);

    my $seq=undef;

    try {
	$seq=$embl->get_Seq_by_acc([$params{accessnumber}]);
    }
    catch Bio::Root::Exception with {
	warn "EMBLFeatureDataSource :Unable to retrieve entry with ",
	"accessnumber ",$params{accessnumber},"\n";
    };

    if (defined $seq) {
	$self->FeatureDataSource::_load_features($seq);
    } else {
	$self=undef;
    }

    return $self;
    
}

1
