package FeatureDataSource::FileFeatureDataSource;

use strict;

use Error qw(:try);

use Bio::Root::Exception;
use Bio::SeqIO;

use FeatureDataSource;

$Error::Debug=1;

@FeatureDataSource::FileFeatureDataSource::ISA=qw(FeatureDataSource);

sub _load_features {
    my $self=shift;
    my $filename=shift;

    my $res=0;

    if ( -r $filename) {	
	try {
	    my $in;
	    if ($filename =~ /\.(gbk)$/i) {
		$in=new Bio::SeqIO('-file'=>$filename,-format=>'genbank');
	    } else {
		$in=new Bio::SeqIO('-file'=>$filename);
	    }
	    
	    my $seq = $in->next_seq;
	    $self->FeatureDataSource::_load_features($seq);
	}
	catch Bio::Root::Exception with {
	    $res=-1;
	    warn "FileFeatureDataSource: $filename format unrecognized.\n";
	};
    } else {
	$res=-1;
	warn "FileFeatureDataSource: unable to load file $filename.\n";
    }
    return $res;
}

sub new {
    my $class=shift;
    my $filename=shift;

    my $self=_new FeatureDataSource;

    bless $self,$class;

    $self->{filename}=$filename;

    my $res=$self->_load_features($filename);
    if ($res<0) {
	$self=undef;
    }

    return $self;
}


sub get_filename {
    my $self=shift;

    return $self->{filename};
}

1
