package FeatureDataSourceWindow::SeqDBWindow;

use strict;

use FeatureDataSource::SeqDBFeatureDataSource;

@FeatureDataSourceWindow::SeqDBWindow::ISA=qw(Gtk::Dialog);

sub new {
    my $class=shift;
    my $manager=shift;

    my $self=new Gtk::Dialog;
    $self->set_title('SeqDB Retrieval Window');
    $self->{manager}=$manager;


    if (FeatureDataSource::SeqDBFeatureDataSource::init) {
	my $entrycombo=new Gtk::Combo();
	my @entrytab=FeatureDataSource::SeqDBFeatureDataSource::get_entry_descriptions();
	$entrycombo->set_popdown_strings(@entrytab);
	$entrycombo->entry->set_editable(0);
	$entrycombo->entry->signal_connect('changed',sub {$self->refresh_entry()});
	$entrycombo->show();
	$self->{entrycombo}=$entrycombo;
	$self->vbox->pack_start($entrycombo,1,1,1);
	
	my $accesshbox=new Gtk::HBox(0);
	$accesshbox->show();
	$self->vbox->pack_start($accesshbox,1,1,1);
	my $accesslabel=new Gtk::Label('Access Number');
	$accesslabel->show();
	$accesshbox->pack_start($accesslabel,1,1,1);
	my $accessentry=new Gtk::Entry;
	$accessentry->show();
	$self->{accessentry}=$accessentry;
	$accesshbox->pack_start($accessentry,1,1,1);
	
	
	my $okbtn=new Gtk::Button('OK');
	$okbtn->show();
	$okbtn->signal_connect('clicked',sub { $self->ok_clicked()});
	$self->action_area->pack_start($okbtn,1,1,1);
	my $cancelbtn=new Gtk::Button('Cancel');
	$cancelbtn->show();
	$cancelbtn->signal_connect('clicked',sub {$self->hide(); return 1});
	$self->action_area->pack_start($cancelbtn,1,1,1);

    } else {
	my $errorlabel=new Gtk::Label("SeqDB connection unavailable.");
	$errorlabel->show();
	$self->vbox->pack_start($errorlabel,1,1,1);
	my $proceedbtn=new Gtk::Button('Proceed');
	$proceedbtn->show();
	$proceedbtn->signal_connect('clicked',sub {$self->hide(); return 1});
	$self->action_area->pack_start($proceedbtn,1,1,1);
    }

    bless $self,$class;

    return $self;
}


sub refresh_entry {
    my $self=shift;

    my $description=$self->{entrycombo}->entry->get_text;
    my $accessnumber=FeatureDataSource::SeqDBFeatureDataSource::get_access_number($description);

    $self->{accessentry}->set_text($accessnumber);

    return 1;
}

sub ok_clicked {
    my $self=shift;

    $self->hide();
    my $cursor=new Gtk::Gdk::Cursor(26);
    while (Gtk::events_pending($self)) {
	Gtk::main_iteration($self);
      }

     my %args=(qualifiers=>1);

    my $accessnumber=$self->{accessentry}->get_text();
    if ($accessnumber =~ /\w{2}\d+/) {
	$args{accessnumber}=$accessnumber;
    } else {
	my $organism=$self->{entrycombo}->entry->get_text();
	$args{organism}=$organism;
    }

    my $datasource=new FeatureDataSource::SeqDBFeatureDataSource(%args);

    $self->{manager}->_add_map_from_datasource($datasource);

    return 1;
}

1
