package Gui::ResultLogWindow;

use strict;

sub new {
    my $class=shift;
    my $manager=shift;

    my $self={};
    bless $self,$class;

    $self->{manager}=$manager;

    my $window=new Gtk::Window -toplevel;
    $window->set_title('Result Information');
    $window->set_usize(640,200);
    $window->signal_connect('delete_event',sub { $self->{manager}->change_window_visibility('resultlogwindow',1); return 1});
    $window->signal_connect('destroy_event',sub { $self->{manager}->change_window_visibility('resultlogwindow',1); return 1});
    $window->show();
    $self->{window}=$window;

    my $vbox=new Gtk::VBox(0);
    $vbox->show();
    $window->add($vbox);
    my $scrolledwindow=new Gtk::ScrolledWindow;
    $scrolledwindow->show();
    $vbox->pack_start($scrolledwindow,1,1,1);
    $self->{scrolledwindow}=$scrolledwindow;
    my $resultlog=new Gtk::Text;
    $resultlog->show();
    $self->{resultlog}=$resultlog;
    $scrolledwindow->add($resultlog);

    my $btnbox=new Gtk::HBox(0);
    $btnbox->show();
    $vbox->pack_start($btnbox,0,0,1);
    my $savebtn=new Gtk::Button ('Save Window Contents');
    $savebtn->signal_connect('clicked', sub { $self->save_to_file() });
    $savebtn->show();
    $btnbox->pack_start($savebtn,1,1,1);
    $self->{savebtn}=$savebtn;
    my $clearbtn=new Gtk::Button ('Clear Window');
    $clearbtn->signal_connect('clicked', sub { $self->clear_log() });
    $clearbtn->show();
    $btnbox->pack_start($clearbtn,1,1,1);
    $self->{clearbtn}=$clearbtn;

    bless $self,$class;

    return $self;
}


sub add_text {
    my $self=shift;
    my $text=shift;

    $self->{resultlog}->insert_text($text);
    
}

sub clear_log {
    my $self=shift;
    
    $self->{resultlog}->freeze();
    $self->{resultlog}->delete_text(0,-1);
    $self->{resultlog}->thaw();

    return 1;
    
}

sub save_to_file {
    my $self=shift;

    my $dialog = new Gtk::FileSelection("Save Result Information");
    $dialog->set_filename("results.txt");
    $dialog->ok_button->signal_connect("clicked",sub {$self->_write_result_log($dialog)});
    $dialog->ok_button->signal_connect("clicked",sub {$dialog->destroy(); 
						      return 1});
    $dialog->cancel_button->signal_connect("clicked",sub {$dialog->destroy();
							  return 1});
    
    $dialog->show();
    return 1;
}

sub _write_result_log {
    my $self=shift;
    my $dialog = shift;

    my $filename=$dialog->get_filename;

    open RESULTLOG,">$filename";
    print RESULTLOG $self->{resultlog}->get_chars(0,-1);
    close RESULTLOG;
    
}

1
