package PaintDevice::ImageMapPaintDevice;

use strict;

use PaintDevice::ReactivePaintDevice;
use PaintDevice::PNGPaintDevice;

use GD;

@PaintDevice::ImageMapPaintDevice::ISA=qw(PaintDevice::PNGPaintDevice PaintDevice::ReactivePaintDevice);

sub new {
    my $class=shift;

    my $mapfilename=shift;
    my $width=shift;
    my $height=shift;
    my $self= new PaintDevice::PNGPaintDevice($mapfilename, $width, $height);

    $self->{urlprefix}=shift;
    $self->{anchortarget}=shift;

    bless $self,$class;

    return $self;
}

sub render {
    my $self = shift;

    $self->PaintDevice::PNGPaintDevice::render();

    print << "EOHTML";
<map name="physicalmap">
EOHTML
    foreach my $r_zone (@{$self->{r_zones}}) {
	my $xmin=int($r_zone->{xmin}*$self->{width});
	my $ymin=int($r_zone->{ymin}*$self->{height});
	my $xmax=int($r_zone->{xmax}*$self->{width});
	my $ymax=int($r_zone->{ymax}*$self->{height});
	my $userdata=$r_zone->{userdata};
	if (ref($userdata) eq 'HASH') {
	    my $box=$userdata;
	    print << "EOHTML";
    <area alt="$box->{label}" title="$box->{label}" coords="$xmin,$ymin,$xmax,$ymax" target="$box->{target}" href="$box->{link}">\n
EOHTML
	} else {
	    my $feature=$userdata;
	    my $tag=$feature->primary_tag();
	    my $namestring='';
	    if (lc $tag eq 'gene' || $feature->has_tag('gene')) {
		my ($name,@dummy)=$feature->each_tag_value('gene');
		$namestring=$name;
	    }
	    my $start=$feature->start();
	    my $end=$feature->end();
	    my $strand=$feature->strand();
	    
	print << "EOHTML";
	<area alt="$namestring" title="$namestring" coords="$xmin,$ymin,$xmax,$ymax" target="$self->{anchortarget}" href="$self->{urlprefix}tag=$tag&name=$namestring&start=$start&end=$end&strand=$strand">\n
EOHTML

        }
    }
	print << "EOHTML";
</map>
EOHTML
}

1
