package Resources::Origami::OrigamiHandler;

use strict;
use SOAP::Lite;
#use SOAP::Lite +trace;
use FeatureDataSource;
use CompAnalResultSource;
use PreferencesHandler;

my $ORGANISMSSVC='OrganismsSVC';
my $RESULTSSVC='ResultsSVC';

my $TARGETNS='urn:OrigamiTargetNS';
my $TYPESNS='urn:OrigamiTypeNS';

my $TIMEOUT=300;

my $orgservice=undef;
my $resultservice=undef;

%Resources::Origami::OrigamiHandler::resultdescriptions=();

sub set_preferences {
    my $mugen=$PreferencesHandler::Preferences->getDocumentElement();
    my @nodes=$mugen->getElementsByTagName('resultdatasources');
    my $rds=shift @nodes;
    @nodes=$rds->getElementsByTagName('origamiresults',0);
    if (scalar(@nodes)==0) {
	my $doctype=$PreferencesHandler::Preferences->getDoctype();
	$doctype->addElementDecl('origamiresults','EMPTY');
	$doctype->addAttDef('origamiresults','url','CDATA','#REQUIRED');
	$doctype->addAttDef('origamiresults','enabled','(yes|no)','"no"');
	my $origami=$PreferencesHandler::Preferences->createElement('origamiresults');
	$origami->setAttribute('url','http://genome.jouy.inra.fr/Origami');
	$origami->setAttribute('enabled','no');
	$rds->appendChild($origami);
    }
    @nodes=$mugen->getElementsByTagName('featuredatasources');
    $rds=shift @nodes;
    @nodes=$rds->getElementsByTagName('origami',0);
    if (scalar(@nodes)==0) {
	my $doctype=$PreferencesHandler::Preferences->getDoctype();
	$doctype->addElementDecl('origami','EMPTY');
	$doctype->addAttDef('origami','url','CDATA','#REQUIRED');
	$doctype->addAttDef('origami','enabled','(yes|no)','"no"');
	my $origami=$PreferencesHandler::Preferences->createElement('origami');
	$origami->setAttribute('url','http://genome.jouy.inra.fr/Origami');	$origami->setAttribute('enabled','no');
	$rds->appendChild($origami);
    }
}

BEGIN {
    PreferencesHandler::register_listener(\&set_preferences);
}

sub init {

    my $res=0;

    if (!$orgservice ) {
	my @nodes=$PreferencesHandler::Preferences->getElementsByTagName('origami');
	my $origami=shift @nodes;
	if ($origami) {
	    my $enabled=$origami->getAttribute('enabled');
	    my $url=$origami->getAttribute('url');
	    if ($enabled eq 'yes') {
		eval { 
		    $orgservice=SOAP::Lite->service("$url/$ORGANISMSSVC?WSDL");
		    $orgservice->transport()->timeout($TIMEOUT);
		};
	    }
	    return 0
		if (!$orgservice);
	}
    }
    
    if (!$resultservice) {
	my @nodes=$PreferencesHandler::Preferences->getElementsByTagName('origamiresults');
	my $origami=shift @nodes;
	if ($origami) {
	    my $enabled=$origami->getAttribute('enabled');
	    my $url=$origami->getAttribute('url');
	    if ($enabled eq 'yes') {
		eval { 
		    $resultservice=SOAP::Lite->service("$url/$RESULTSSVC?WSDL");
		    $resultservice->transport()->timeout($TIMEOUT);
		};
	    }
	    return 0
		if (!$resultservice);
	}
    }
    
    
    $orgservice->serializer(new AlphaSerializer());
    $orgservice->maptype->{ArrayOfstring}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{Organism}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{ArrayOfOrganism}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{Element}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{ArrayOfElement}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{Gene}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{ArrayOfGene}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{Feature}=$TYPESNS.$ORGANISMSSVC;
    $orgservice->maptype->{ArrayOfFeature}=$TYPESNS.$ORGANISMSSVC;
    
    $resultservice->serializer(new AlphaSerializer());
    $resultservice->maptype->{Element}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ArrayOfElement}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{Result}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ArrayOfResult}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ResultType}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ArrayOfResultType}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ConservedContextAlignment}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ConservedContextParams}=$TYPESNS.$RESULTSSVC;
    $resultservice->maptype->{ArrayOfstring}=$TYPESNS.$RESULTSSVC;
    
    my $resulttypes=$resultservice->getResultTypes();
    foreach my $resulttype (@$resulttypes) {
	$Resources::Origami::OrigamiHandler::resultdescriptions{$resulttype->{id}}=$resulttype->{description};
    }
    
    $res=1
	if ($orgservice && $resultservice);
    
    return $res;
}

sub getAllOrganisms{
    my $organisms=$orgservice->getAllOrganisms();
    return $organisms;
} 

sub getOrganismWithId {
    my $id=shift;
    return $orgservice->getOrganismWithId($id);
}

sub getElementsOfOrganisms {
    my $organisms=shift;
    my @organismstab=();
   foreach my $org (@$organisms) {
       push @organismstab, new Organism($org);
    }
    my $SOAPorgtab=SOAP::Data->type('ArrayOfOrganism')->value(\@organismstab);
    my $elements=$orgservice->getElementsOfOrganisms($SOAPorgtab);
    return $elements;
}

sub getElementWithId {
    my $id=shift;
    return $orgservice->getElementWithId($id);
}

sub getSequenceOfElement {
    my $element=shift;
    my $SOAPelement=new Element($element);
    return $orgservice->getSequenceOfElement($SOAPelement);
}


sub getFeaturesOfElement {
    my $element=shift;
    my $SOAPelement=new Element($element);
    return $orgservice->getFeaturesOfElement($SOAPelement);
}

sub getResultTypes {
    my $results=undef;
    $results = $resultservice->getResultTypes();
    return $results;
}

sub getResultsOfElements {
    my $elements=shift;
    my $results=undef;
    my @elementstab=();
    
    foreach my $elt (@$elements) {
       push @elementstab, new Element($elt);
    }
    
    my $SOAPelttab=SOAP::Data->type('ArrayOfElement')->value(\@elementstab);

    $results = $resultservice->getResultsOfElements($SOAPelttab);
    
    return $results;

}

sub getAtypicalGenesOfElement {
    my $element=shift;
    my $SOAPelement=new Element($element);
    my $genesWS = $resultservice->getAtypicalGenesOfElement($SOAPelement);
    return $genesWS;
}


sub getElementStatesOfOrganism {
    my $organism=shift;
    my $SOAPorganism=new Organism($organism);
    my $eltsWS = $resultservice->getElementStatesOfOrganism($SOAPorganism);
    return $eltsWS;
}

sub getUniqueGenesOfElement {
    my $element=shift;
    my $SOAPelement=new Element($element);
    my $genes = $resultservice->getUniqueGenesOfElement($SOAPelement);
    return $genes;
}

sub getSmallGenesOfElement {
    my $element=shift;
    my $SOAPelement=new Element($element);
    my $genes = $resultservice->getSmallGenesOfElement($SOAPelement);
    return $genes;
}

sub getGeneOccurrencesOfElement {
    my $element=shift;
    my $SOAPelement=new Element($element);
    my $geneswo = $resultservice->getGeneOccurrencesOfElement($SOAPelement);
    return $geneswo;
}

sub getOrthologyMapForElementPair {
    my $qelement=shift;
    my $selement=shift;
    my $SOAPqelement=new Element($qelement);
    my $SOAPselement=new Element($selement);
    my $homologPairs= $resultservice->getOrthologyMapForElementPair(
				   $SOAPqelement,$SOAPselement);
    return $homologPairs;


}

sub getGenesBySubtractionForElementPair {
    my $qelement=shift;
    my $selement=shift;
    my $SOAPqelement=new Element($qelement);
    my $SOAPselement=new Element($selement);
    my $genes= $resultservice->getGenesBySubtractionForElementPair(
				   $SOAPqelement,$SOAPselement);
    return $genes;
}

sub getRelatedElementsOfResult {
    my $result=shift;
    my $SOAPresult=new Result($result);
    my $eltsSubj = $resultservice->getRelatedElementsOfResult($SOAPresult);
    return $eltsSubj;
}


sub getConservedContextParamsForElementPair{
    my $q_element=shift;
    my $s_element=shift;
    my $SOAPq_element = new Element($q_element); 
    my $SOAPs_element = new Element($s_element);
    my $ccParams = $resultservice->getConservedContextParamsForElementPair($SOAPq_element,$SOAPs_element);
    return $ccParams;
}

sub getConservedContextAlignmentsWithParams{
    my $ccParams=shift;
    my $SOAPccParams = new ConservedContextParams($ccParams);
    my $ccAlignments = $resultservice->getConservedContextAlignmentsWithParams($SOAPccParams);
    return $ccAlignments;
}

sub getConservedContextAlignmentsPairsWithParams{
    my $ccParams=shift;
    my $SOAPccParams = new ConservedContextParams($ccParams);
    my $ccAPairs = $resultservice->getConservedContextPairsWithParams($SOAPccParams);
    return $ccAPairs;
}

sub getConservedContextAlignmentsPairsByAlignment{
    my $ccAlignment=shift;
    my $SOAPccAlignment = new ConservedContextParams($ccAlignment);
    my $ccAPairs = $resultservice->getConservedContextPairsOfAlignment($SOAPccAlignment);
    return $ccAPairs;
}

###Alphaserializer####################################################################
#####################################################################################
package AlphaSerializer;

@AlphaSerializer::ISA='SOAP::Serializer';


# Mthodes de srialization.
# Pour les instances des autres classes  srialiser, il suffit de recopier le contenu
# de cette mthode dans une mthode appele :
#              as_MachinChose
# Pour des classes dans des sous-packages (ex.: MonPackage::MaClasse), il faut remplacer
# les :: par des __, ce qui donnerait :
#              as_MonPackage__MaClasse
sub _alphamapper{
    my $self=shift;
    my ($value, $name, $type, $attr) = @_;

    return [
	    $name || $self->SUPER::gen_name(),
	    {%$attr, 'xsi:type' => $self->maptypetouri($type)},
	    [map {$self->encode_object($value->{$_}, $_)} sort { $a cmp $b } keys %$value ],
	    $self->gen_id($value)
	    ];
}
sub as_Organism {
    return (_alphamapper( @_ ) );
}

sub as_Element {
    return (_alphamapper( @_ ) );
   
}

sub as_Feature  {
    return (_alphamapper( @_ ) );

}

sub as_Gene {
    return (_alphamapper( @_ ) );
   
}



sub as_Result {
    return (_alphamapper( @_ ) );
   
}
sub as_ResultType {
    return (_alphamapper( @_ ) );
   
}

sub as_GeneWithState {
    return (_alphamapper( @_ ) );

}


sub as_SmallGene {
    return (_alphamapper( @_ ) );

}

sub as_GeneWithOccurrences {
    return (_alphamapper( @_ ) );

}

sub as_ElementWithState {
    return (_alphamapper( @_ ) );

}
 
sub as_ConservedContextParams  {
    return (_alphamapper( @_ ) );

}

sub as_ConservedContextAlignment  {
    return (_alphamapper( @_ ) );

}

sub as_ConservedContextPair  {
    return (_alphamapper( @_ ) );

}

sub as_HomologPair  {
    return (_alphamapper( @_ ) );

}

#######Empequatage SOAP#######################################################################
#############################################################################################
package Organism;

sub  new {
    my $class=shift;
    my $organism=shift;
   
    my $self={
	name=>SOAP::Data->type('string')->value($organism->{name}),
	id=>SOAP::Data->type('string')->value($organism->{id}),	
	shortName=>SOAP::Data->type('string')->value($organism->{shortName})
	};
    bless $self,$class;
    return $self ;
}

package Element;

sub new {
    my $class=shift;
    my $element=shift;
   
    my $self={
	accession=>SOAP::Data->type('string')->value($element->{accession}),
	description=>SOAP::Data->type('string')->value($element->{description}),
	id=>SOAP::Data->type('string')->value($element->{id}),
	organismId=>SOAP::Data->type('string')->value($element->{organismId}),
	size=>SOAP::Data->type('string')->value($element->{size}),
	type=>SOAP::Data->type('string')->value($element->{type})
	};
    return bless $self,$class;
}

package ElementWithState;

sub new {
    my $class=shift;
    my $element=shift;
   
    my $self={
	accession=>SOAP::Data->type('string')->value($element->{accession}),
	description=>SOAP::Data->type('string')->value($element->{description}),
	id=>SOAP::Data->type('string')->value($element->{id}),
	organismId=>SOAP::Data->type('string')->value($element->{organismId}),
	size=>SOAP::Data->type('string')->value($element->{size}),
	type=>SOAP::Data->type('string')->value($element->{type}),
	atypicalGenesRatio=>SOAP::Data->type('float')->value($element->{atypicalGenesRatio}),
	forwardGenesRatio=>SOAP::Data->type('float')->value($element->{forwardGenesRatio}),
	reverseGenesRatio=>SOAP::Data->type('float')->value($element->{reverseGenesRatio})
	};
    return bless $self,$class;
}

package Gene;

sub new {
    my $class=shift;
    my $gene=shift;
    
    my $self={	
	id=>SOAP::Data->type('string')->value($gene->{id}),
	elementId=>SOAP::Data->type('string')->value($gene->{elementId}),
	name=>SOAP::Data->type('string')->value($gene->{name}),
	start=>SOAP::Data->type('int')->value($gene->{start}),
	stop=>SOAP::Data->type('int')->value($gene->{stop}),
	strand=>SOAP::Data->type('int')->value($gene->{strand})
    };
    return bless $self,$class;
}

package GeneWithState;

sub new {
    my $class=shift; 
    my $gene=shift;
    
    my $self={	
	id=>SOAP::Data->type('string')->value($gene->{id}),
	elementId=>SOAP::Data->type('string')->value($gene->{elementId}),
	name=>SOAP::Data->type('string')->value($gene->{name}),
	start=>SOAP::Data->type('int')->value($gene->{start}),
	stop=>SOAP::Data->type('int')->value($gene->{stop}),
	strand=>SOAP::Data->type('int')->value($gene->{strand}),
	state=>SOAP::Data->type('string')->value($gene->{state})
    };
    return bless $self,$class;
}


package SmallGene;

sub new {
    my $class=shift; 
    my $gene=shift;
    
    my $self={	
	id=>SOAP::Data->type('string')->value($gene->{id}),
	elementId=>SOAP::Data->type('string')->value($gene->{elementId}),
	name=>SOAP::Data->type('string')->value($gene->{name}),
	start=>SOAP::Data->type('int')->value($gene->{start}),
	stop=>SOAP::Data->type('int')->value($gene->{stop}),
	strand=>SOAP::Data->type('int')->value($gene->{strand}),
	probability=>SOAP::Data->type('float')->value($gene->{probability}),
	homologs=>SOAP::Data->type('int')->value($gene->{homologs}),
	comment=>SOAP::Data->type('string')->value($gene->{comment})
    };	
    return bless $self,$class;
}

package GeneWithOccurrences;

sub new {
    my $class=shift; 
    my $gene=shift;
    
    my $self={	
	id=>SOAP::Data->type('string')->value($gene->{id}),
	elementId=>SOAP::Data->type('string')->value($gene->{elementId}),
	name=>SOAP::Data->type('string')->value($gene->{name}),
	start=>SOAP::Data->type('int')->value($gene->{start}),
	stop=>SOAP::Data->type('int')->value($gene->{stop}),
	strand=>SOAP::Data->type('int')->value($gene->{strand}),
	occurrences=>SOAP::Data->type('int')->value($gene->{occurrences})
    };
    return bless $self,$class;
}

package Feature;

sub new {
    my $class=shift;
    my $feature=shift;
    
    my $self={	
	type=>SOAP::Data->type('string')->value($feature->{type}),
	start=>SOAP::Data->type('int')->value($feature->{start}),
	stop=>SOAP::Data->type('int')->value($feature->{stop}),
	strand=>SOAP::Data->type('int')->value($feature->{strand})
    };
    return bless $self,$class;
}

package Result;

sub new {
    my $class=shift; 
    my $result=shift;

    my $self={		
	elementId=>SOAP::Data->type('string')->value($result->{elementId}),
	organismId=>SOAP::Data->type('string')->value($result->{organismId}),
	typeId=>SOAP::Data->type('string')->value($result->{typeId})
    };
    return bless $self,$class;
}

package ResultType;

sub new {
    my $class=shift; 
    my $result=shift;
    
    my $self={	
	description=>SOAP::Data->type('string')->value($result->{description}),
	id=>SOAP::Data->type('string')->value($result->{id})
    };
    return bless $self,$class;
}

package ConservedContextParams;
    
    sub new {
    my $class=shift; 
    my $result=shift;
    my $self={		
	id => SOAP::Data->type('string')->value($result->{id}),
	description => SOAP::Data->type('string')->value($result->{description}),
	gapCreationPenalty => SOAP::Data->type('double')->value($result->{gapCreationPenalty}),
	gapExtensionPenalty => SOAP::Data->type('double')->value($result->{gapExtensionPenalty}), 
        homoScore => SOAP::Data->type('double')->value($result->{ homoScore }),
        minAlignSize => SOAP::Data->type('int')->value($result->{minAlignSize}), 
	minScore => SOAP::Data->type('double')->value($result->{minScore}),
        mismatchPenalty => SOAP::Data->type('double')->value($result->{mismatchPenalty}), 
        orthoScore => SOAP::Data->type('double')->value($result->{orthoScore}), 
	QElementId => SOAP::Data->type('string')->value($result->{QElementId}),
	SElementId => SOAP::Data->type('string')->value($result->{SElementId})
    };
    return bless $self,$class;
}

package ConservedContextAlignment;
    
    sub new {
    my $class=shift; 
    my $result=shift;
    my $self={		
	id => SOAP::Data->type('string')->value($result->{id}),
	alignmentParamId => SOAP::Data->type('string')->value($result->{alignmentParamId}),
	gaps => SOAP::Data->type('int')->value($result->{gaps}),
	homologs => SOAP::Data->type('int')->value($result->{homologs}),
	mismatches => SOAP::Data->type('int')->value($result->{mismatches}),
	orientationConserved => SOAP::Data->type('boolean')->value($result->{orientationConserved}), 
	orthologs => SOAP::Data->type('int')->value($result->{orthologs}),
	pairs => SOAP::Data->type('int')->value($result->{pairs}),
	QContextStart => SOAP::Data->type('int')->value($result->{QContextStart}),
	QContextStop => SOAP::Data->type('int')->value($result->{QContextStop}),
	SContextStart => SOAP::Data->type('int')->value($result->{SContextStart}),
	SContextStop=> SOAP::Data->type('int')->value($result->{SContextStop})
    };
    return bless $self,$class;
}

package ConservedContextPair;
    
    sub new {
    my $class=shift; 
    my $result=shift;
    my $self={		
	alignmentId => SOAP::Data->type('string')->value($result->{alignmentId}),
	QGene=> SOAP::Data->type('tns:Gene')->value($result->{QGene}),
	SGene=> SOAP::Data->type('tns:Gene')->value($result->{SGene}),
	relation => SOAP::Data->type('string')->value($result->{relation}),
    };
    return bless $self,$class;
}

package HomologPair;
    
sub new {
    my $class=shift; 
    my $result=shift;
    my $self={		
	QGene=> SOAP::Data->type('tns:Gene')->value($result->{QGene}),
	SGene=> SOAP::Data->type('tns:Gene')->value($result->{SGene}),
	score => SOAP::Data->type('float')->value($result->{score}),
	evalue => SOAP::Data->type('float')->value($result->{evalue}),
    };
    return bless $self,$class;
}

1;


