use strict;


print "Checking for avalaible modules.\n";

my %modules = (
	       'SOAP::Lite' => {type => 'optional',
				functionality => 'SeqDB results access',
				version => 0.55},
	       'DBI' => {type => 'optional', 
			 functionality => 'Micado/SeqDB access',
			 version => 1.20},
	       'DBD::Pg' => {type => 'optional',
			     functionality => 'Micado/SeqDB access',
			     version=> 1.01},
	       'Error' => {type => 'required',
		       version => 0.15},
	       'GD' => {type => 'required',
			version => 1.38},
	       'Getopt::Long' => {type=> 'required',
				  version => 2.23},
	       'Gtk' => {type => 'optional',
			 functionality => 'Interactive viewing with mugenv',
			 version => 0.7008},
	       'HTTP::Request' => {type => 'optional',
				   functionality => 'EMBL access',
				   version => 1.30},
	       'IO::File' => {type => 'required',
			      version => 1.08},
	       'IO::String' => {type => 'required',
				version => 1.01},
	       'LWP::UserAgent' =>  {type => 'optional',
				     functionality => 'GenBank/EMBL access',
				     version => 2.001},
	       'Pod::Parser' => {type => 'required',
				 version => 1.12},
	       'Pod::Usage' => {type => 'required',
				version => 1.12},
	       'XML::DOM' => {type => 'required',
			      version => 1.42},
	       'XML::Parser::PerlSAX' => {type => 'required',
					  version => 0.07 },
	       'XML::Writer' => {type => 'required',
				 version => 0.4},
	       'XML::Twig' => {type => 'required',
			       version => 3.09},
	       'Bio::DB::GenBank' => {type => 'required'},
	       'Bio::Seq' => {type => 'required'},
	       'Bio::SeqIO' => {type => 'required'},
	       'Bio::SeqFeature::Generic' => {type => 'required'},
	       'Bio::Tools::CodonTable' => {type => 'required'},
	       );

foreach my $module (keys %modules) {
    $|=1;
    my $version=$modules{$module}->{version};
    if (defined $version) {
	print "\t$module (>= $version) ...";
    } else {
	print "\t$module ... ";
    }
	
    if ( eval  "use $module $version; return 1"  ) {
	print "ok.\n";
    } else {
	print "not found.\n";
	print "Error message : \n\t$@\n";
	if ($modules{$module}->{type} eq 'required') {
	    print "MuGeN WILL NOT WORK AT ALL !\n";
	    exit -1;
	} else {
	    print "\t",$modules{$module}->{functionality}," will not work.\n";
	}
    }
    $|=0;
}

my $DEFAULTPERLPATH="PERLPATH";
my $REALPERLPATH=`which perl`;
chomp($REALPERLPATH);
my $INSTPATH='INSTPATH';
my $PWD=$ENV{'PWD'};


print "Substituting site specific path information.\n";

$DEFAULTPERLPATH=~ s/\//\\\//g;
$REALPERLPATH=~ s/\//\\\//g;
$PWD=~ s/\//\\\//g;

my @scripts=qw(mugenb mugenv) ;

foreach my $script (@scripts) {
    $|=1;
    print "\t$script...";
    `perl -i -pe 's/$DEFAULTPERLPATH/$REALPERLPATH/' $script`;
    `perl -i -pe 's/$INSTPATH/$PWD/' $script`;
    print "done.\n";
    $|=0;
}

`ln -s mugenv mugen`
__END__

=head1 NAME

MuGeN

=head1 SYNOPSIS


The Multi-Genome Navigator, or MuGeN, is a bioinformatics software package providing tools for exploring multiple annotated genomes along with in silico analysis results. It offers two distinct programs, one for interactive vizualization and navigation and another for the generation of images in various formats. Both programs can load annotated sequence data from a local file or retrieve it from databases across the network. Most of the parameters governing the way annotations and analysis results are displayed are customizable, either through the graphical user interface or with command-line parameters. The following sections show how to install and to use MuGeN before describing how to format home-made analysis results in order to integrate them in MuGeN.


=head1 USAGE

B<Options common to mugenb and mugenv>

=over

=item B<-d source:id>

Specifies a resource from which to load annotated genome maps. Each resource consists of two parts, a source and an id. The source can be one of file, genbank, embl, xembl or origami (for publicly accessible sources) or micado, seqdb, mosaic or agmial (for sources needing a valid login and password). When no source is specified, file is taken as default. The id points to the specific map in the source. When the latter is a file, the id is simply the filename (in GenBank, EMBL, BSML or fasta format). When the source is a database (genbank, embl, xembl, origami, micado, seqdb, mosaic, agmial) the id is the access number of the database entry. Maps will be displayed from top to bottom in the order they are entered on the command line. If the id start with a "!" the map will be flipped.


=item B<-f firstbase>

Specifies the starting point of the image to build. In the absence of any reference points, this is the first base of the map that will be located in the upper left corner of the image. If a reference point is given, the upper left corner will be the reference point offset by the amount specified by this option.


=item B<-l lastbase>

Specifies the ending point of the image to build. In the absence of any reference points, this is the last base of the map that will be located in the upper lower right corner of the image. If a reference point is given, the lower right corner will be the reference point offset by the amount specified by this option.


=item B<-s step>

Specifies the number of bases per display line.


=item B<-r refpos>

Specifies a reference position or anchor for a genome map. If the reference position is an integer, the start of the displayed image will be computed by adding the value of the -f option to the integer. If the reference position is a string, MuGeN will look for a CDS feature having a gene qualifier whose value equals the given string. If such a CDS is found, it's start base will be used to compute the start of de displayed image as explained above. Moreover, if the gene is on the reverse strand, the map will be flipped. The genome map for which the reference position is defined is determined by the index of the -r option wrt. the -d option (i.e. the first -r option will be applied to the map defined by the first -doption, the second -r applies to the second -d and so on).


=item B<-c filename[,index]>

Specifies a computational analysis results file to display with a genome map. If a comma and an index are appended to the filename, the result will be applied to the genome map of the corresponding index. Index 1 is the genome map loaded by the first -d option, index 2 the map corresponding to the second -d and so on.


=item B<-e filename>

Specifes a file containing a color scheme to apply to displayed features.


=item B<-w n>

Specifes the width in pixels of the drawing area


=item B<-p filename>

Specifes the preferences file to load. If no -p option is given, the preferenes file will be set to ${HOME}/.mugenrc.


=back


B<Options specific to mugenb>

=over

=item B<-o format>

Specifies the output format of the image file to be generated. Valid formats are : PNG, IMAP, PS, EPS, XFIG.


=item B<-m mediatype>

Specifies the media type, for PS or EPS output files. Valid types are : a7, a6, a5, a4, a3, a2, a1, a0, b7, b6, b7, b4, b3, b2, b1, b0, lettern legal, executive, ledger.


=item B<-u urlprefix>

Specifies the root URL for client-side image maps in IMAP format. Parameters relative to dislayed features will be appended to this root URL. For instance, given a root URL of http://www.somewhere.org/cgi-bin/myscript.pl?myid=xyz&, and an image containing a CDS feature, whose name is abcX positioned from base 1234 to base 5678, the URL generated for it's clickable area will be http://www.somewhere.org/cgi-bin/myscript.pl?myid=xyz&tag=CDS&name=abcX&start=1234&end=5678.


=item B<-t anchortarget>

Sets the target frame of map links in IMAP format. Default is: _self.


=back



=head1 CONTACT

Mark Hoebeke (mhoebeke{at}genopole{dot}cnrs{dot}fr)
