#!/usr/bin/perl

use strict;

use IO::File;
use XML::Writer;

my $inputfilename=shift;

my $outputfilename=shift;

my $output=new IO::File(">$outputfilename");

my $writer=new XML::Writer(OUTPUT => $output,
			   NEWLINES => 1,
			   DATA_INDENT => 1);

$writer->xmlDecl('UTF-8','yes');
$writer->startTag('companalresults');

$writer->startTag('boxplot',
		  'type' => 'overlay',
		  'comment' => 'GETORF output');

open SYCOFILE,"$inputfilename";

my $in_plot=0;

my %colors = ( -1 => 'red',
	       -2 => 'green',
	       -3 => 'yellow',
	       1 => 'red',
	       2 => 'green',
	       3 => 'yellow');

my @minlengths=(1e10,1e10,1e10,1e10);
my @maxlengths=(-1,-1,-1,-1,-1);
my %minstarts=();
my %minends=();
my %maxstarts=();
my %maxends=();

my $thickness=0.37;


while (my $line=<SYCOFILE>) {
    chomp($line);
    if ($line =~ /\[(\d+)\s+-\s+(\d+)\]/) {
	my $start=$1;
	my $end=$2;
	my $frame=(($start-1) % 3)+1;
	my $strand=1;
	if ($start>$end) {
	    $strand=-1;
	    $frame=4-$frame;
	    ($end,$start)=($start,$end);
	}
	my $length=$end-$start+1;
	if ($length<$minlengths[0]) {
	    $minlengths[0]=$length;
	    @minlengths=sort@minlengths;
	    $minstarts{$length}=$start;
	    $minends{$length}=$end;
	}
	if ($length>$maxlengths[0]) {
	    $maxlengths[0]=$length;
	    @maxlengths=sort { $a <=> $b } @maxlengths;
	    $maxstarts{$length}=$start;
	    $maxends{$length}=$end;
	}

	$writer->emptyTag('box',
			  'begin' => $start,
			  'end' => $end,
			  'strand' => $strand,
			  'frame' => $frame,
			  'thickness' => $thickness,
			  'filled' => 'yes',
			  'color' => $colors{$frame});
    }
}


close SYCOFILE;

$writer->startTag('highlights');
my $index=1;
foreach my $length (reverse @maxlengths) {
    $writer->emptyTag('highlight',
		      'label' => "Largest ORF ".$index." ($length b.)",
		      'begin' => $maxstarts{$length},
		      'end' => $maxends{$length});
    $index++;

}
my $index=1;
foreach my $length (@minlengths) {
    $writer->emptyTag('highlight',
		      'label' => "Smallest ORF ".$index." ($length b.)",
		      'begin' => $minstarts{$length},
		      'end' => $minends{$length});
    $index++;

}
$writer->endTag('highlights');

$writer->endTag('boxplot');

$writer->endTag('companalresults');


$writer->end();

$output->close();
