function [err] = comparResult(fileSave1, fileSave2, nmod)
% Compare the results contained in files fileSave1 and fileSave2
% INPUT
% fileSave1, fileSave2: relative or absolute pathnames
% nmod : number of models (2 if models comparison, 1 otherwise)
% RETURN
% 0 if identical results , error message and 1, otherwise
% NOTE
% In the messages,
% results on file  fileSave1 are denoted 'reference'
% results on file  fileSave2  are denoted 'actual' 
%% =====================================================
if ~exist( fileSave1, 'file')
    errordlg(['File ', fileSave1, 'does not exist']);
    return
end
if ~exist( fileSave2, 'file')
    errordlg(['File ', fileSave2, 'does not exist']);
    return
end

load(fileSave1); % charge la structure 'data' contenue dans le fichier
data1=data;
load(fileSave2);
data2= data;
clear data;

err=0;



%% Le modèle: fatal si différents
for imod=1:nmod
    if nmod==1
        nom= 'modelepop';
    else
        nom=['modelepop' num2str(imod)];
    end
    if data1.(nom) ~= data2.(nom)
        disp(['Model in reference structure: ' data1.(nom)])
        disp(['Model in actual structure: ' nom '=' data2.(nom)])
        err=1;
        return
    end
end % fin imod


%% Les CV sont-ils estimés? fatal si différent
if isfield(data1, 'cvinparam_in') && isfield(data2, 'cvinparam_in')
    if  data1.cvinparam_in ~= data2.cvinparam_in
        disp(['CV estimate in reference structure: ' data1.cvinparam_in])
        disp(['CV estimate in actual  structure: ' data2.cvinparam_in])
        err=1;
        return
    end
end

%% Les nombres et noms des paramètres: fatal si différent
for imod=1:nmod
    if nmod==1
        nom= 'nomparam';
    else
        nom=['nomparam' num2str(imod)];
    end

    if length(data1.(nom)) ~= length(data2.(nom))
        disp(['Number of parameters in the reference structure of the model: ' ,...
            num2str(imod), ...
            ' :', num2str(length(data1.(nom)))])
        disp(['Number of parameters in the actual structure of the model: ' ,...
            num2str(imod), ...
            ' :', num2str(length(data2.(nom)))])
        err=1;
    else
        for i=1: length(data1.(nom))
            if strcmp(data1.(nom)(i), data2.(nom)(i)) ~=1
                disp(['Parameter  ', i 'in the reference structure: '  data1.(nom)(i)])
                disp(['Parameter  ', i 'in the actual structure: '  data2.(nom)(i)])
                err=1;
                return
            end
        end
    end
end % fin imod


%% Les paramètres estimés
a=fieldnames(data1);
b=fieldnames(data2);
if any(strcmp(a, 'optima'))
    % il s'agit de resultats de simulation de stratégie optimale
    if ~any(strcmp(b, 'optima'))
        disp('In the reference structure, there is a component optima and not in the actual structure');
        err=1;
        return
    end
    if length(data1.optima)~= length(data2.optima)
        disp(['There are ', num2str(length(data1.optima)), ...
            ' optima in the reference structure ', ...
            'and ' , num2str(length(data2.optima)), ...
            ' in the actual structure.']);
        err=1;
        return
    end
    if ~any(data1.optima == data2.optima)
        disp('Optima in reference structure: ')
        disp(data1.optima)
        disp('Optima in actual structure: ')
        disp(data2.optima)
        err=1;
        return
    end
    %% Fin du cas de la  simulation de stratégie optimale   
    
    
else
    %% il s'agit de resultats d'estimation ou comparaison de modeles
    
    
    
    for imod=1:nmod
        if nmod==1
            nom= 'paramfin';
            nomparamfin= 'nomparam';
        else
            nom=['paramfin' num2str(imod)];
            nomparamfin= ['nomparam' num2str(imod)];
        end
        aa=any(strcmp(a, nom));
        bb=any(strcmp(b, nom));
        
        if aa && ~bb
            disp(['In the reference structure, there is a component: ' nom ...
                'It does not exist in the actual structure.'])
            err=1;
            return
        end
        if bb && ~aa
            disp(['In the actual structure, there is a component: ' nom ...
                'It does not exist in the reference structure.'])
            err=1;
            return
        end
        
        if length(data1.(nom))~= length(data2.(nom))
            disp(['There are ', num2str(length(data1.(nom))), ...
                ' estimated parameters (paramfin) in the model ', num2str(imod) , ...
                ' of the reference structure ', ...
                'and ' , num2str(length(data2.(nom))), ...
                ' in the model ',  num2str(imod) , ...
                ' of the actual structure.']);
             err=1;
            return
        end % fin if length(data1.(nom))
        paramfin1=data1.(nom);
        paramfin2=data2.(nom);
        
        for unp=1:length(data1.(nomparamfin))
            % Pour compararer a X decimales près
            a=num2str(paramfin1(unp), 10);
            b=num2str(paramfin2(unp), 10);
            
            if ~strcmp(a(unp), b(unp))
                disp(  ['Parameter ' num2str(unp) , ...
                    ' of the model ', num2str(imod) , ...
                    ' equals in the reference structure : ', a(unp), ...
                    ' while it equals in the actual structure: ', b(unp)]);
                
                 err=1;
                %    return
            end
            
        end
    end % fin imod
    
    %% Y a t-il eu étude de stabilité: fatal si différent
    if (data1.stab_nombre_dynamique ~= data2.stab_nombre_dynamique)
        disp(['Stability study mode in reference structure : ' data1.stab_nombre_dynamique])
        disp(['Stability study mode in  actual structure : ' data2.stab_nombre_dynamique])
        err=1;
        return
    end
    
    %% Comparaison des résultats de l'étude de stabilité:
    if (data1.stab_nombre_dynamique>0)
        %% Comparaison des panels d'étude de stabilite
        if ~isequal(size(data1.stab_res), size(data2.stab_res))
            disp(['Size of stability study results in reference structure : ' size(data1.stab_res)])
            disp(['Size of stability study results in   actual structure : ' size(data2.stab_res)])
            err=1;
            return
        end
        taille = size(data1.stab_res);
        for i=1: taille(1)
            if ~isequal(data1.stab_res(i,:), data2.stab_res(i,:))
                err=1;
            end
        end
        if (err==1)
            disp('Results of stability study in reference structure : ');
            disp(data1.stab_res)
            disp('Results of stability study in actual structure : ');
            disp(data2.stab_res)
        end
    end
    
end
end % fin comparResult
