function testCompar
% Compare actual to previously stored results of the task
% Models Comparison
%% ===========================================
% Customize: the references files
filedir = '../EXAMPLES/PROJECTS/MODEL_COMPARISON/';
filepattern = 'test';
listefic = dir(filedir);
fileTests ={};

for i=1:length(listefic)
    if (~isempty(strfind(listefic(i).name, filepattern)))
        fileTests{end+1} = listefic(i).name;
    end
end % end for

% See testEstim for more comments

choix =10; % task Models Comparison
   disp('******** TESTS BEGIN *************');
   for i=1:length(fileTests)
       fileIn = [filedir fileTests{i}];
       %exécution et sauvegarde des résultats
       fileSave = exec1Test(fileIn, choix);
       err= comparResult(fileIn,    fileSave, 2);
       if (err ~=0)
           disp(['CAREFUL: ', fileIn, ...
               ' NOT EQUAL ',  fileSave]);
       else
           disp(['OK: ', fileIn, ...
               ' = ',  fileSave]);
       end
       errfin(i)=err;
       disp('-------------'); % between two tests
   end % fin i
   disp('******** END TESTS ******** ');
   
   if any(errfin)
       disp('TEST ERROR');
   end

end % end testCompar
