function testIdentification
% Compare actual to previously stored results of the task
% Parametric Identification
%% ===========================================
% Customize: the references files
filedir = '../EXAMPLES/PROJECTS/IDENTIFICATION/';
filepattern = 'test';
listefic = dir(filedir);
fileTests ={};

for i=1:length(listefic)
    if (~isempty(strfind(listefic(i).name, filepattern)))
        fileTests{end+1} = listefic(i).name;
    end
end % end for


% The reference files will be restored. 
% Then, execution will be launched from the input panel.
% The output will be compared with the ones stored in the reference files.

choix =9; % choice for the task Parametric Identification
   disp('******** TESTS BEGIN *************');
   for i=1:length(fileTests)
       fileIn =  [filedir fileTests{i}];
       %execution and saving of the results
       fileSave = exec1Test(fileIn, choix);
       err = comparResult(fileIn,    fileSave, 1);
       if (err ~=0)
           disp(['CAREFUL: ', fileIn, ...
               ' NOT EQUAL ',  fileSave]);
       else
           disp(['OK: ', fileIn, ...
               ' = ',  fileSave]);
       end
       errfin(i)=err;
       disp('-------------'); % between two tests
   end % fin i
   disp('******** END TESTS ******** ');
   
   if any(errfin)
       disp('TEST ERROR');
   end

end % end testIdentification
