function dataout=etudestab(nombre_dynamique, indice_panel, nbparammodel, ...
    nomparam, RESULTAT)
%etudestab Etude de stabilité
%% ======================================================
data=guidata(1);
m=floor(nbparammodel./2);
if mod(nbparammodel,2)
    m=m+1;
end

% Fait-on des histos?
nombre_dynamique_histo=10; % nombre de dynamiques au dela duquel on fait des histo
if nombre_dynamique >= nombre_dynamique_histo
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_tag'];
    titre=['PARAMETER HISTOGRAMS', ' (',...
        num2str(nombre_dynamique), ' dynamics)' ];
    hp2=uipanel('parent',data.hpanel_work,...
        'tag',tag,...
        'title', titre, ...
        'TitlePosition', 'centertop', ...
        'BorderType', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Position',[0 .02 1 0.98]);
    
end % fin nombre_dynamique >= nombre_dynamique_histo
for j=1:nbparammodel;
    AC=[];
    for r=1:nombre_dynamique
        AC=[AC;RESULTAT{r}(j)];
    end
    
    
    if nombre_dynamique >= nombre_dynamique_histo
        histostab(j, m, nombre_dynamique, nomparam, AC, ...
		  data.Basemodeles.type,  hp2 );
        data.(tag) = hp2; % 29/1/14
    end % histo
end % fin nbparammodel
if nombre_dynamique >= nombre_dynamique_histo
    data.AC=AC; % pour sauvegarde/restauration
end


%Etude de stabilite
indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_tag'];
% Pour cacher le titre de l'eventuel panel précédent: un titre
% blanc suffisamment long
letitre='                                                                                  ';

hp2=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BackgroundColor',[1 1 1],...
    'BorderType', 'none', ...
    'title', letitre, ...
    'TitlePosition', 'centertop', ...
    'Position',[0 .02 1 0.98]);
data.(tag) = hp2; % 29/1/14

switch data.level_stab
    case 1
        niveau=90;
    case 2
        niveau=95;
    case 3
        niveau=99;
    otherwise
        errordlg(['INTERNAL ERROR: (etudestab) confidence level ', num2str(data.level_stab), ' unrecognized'])
end
nomfonction={'Parameters','Min','Max','Mean','STD', ...
    ['Statistical CI (', num2str(niveau), '%)']};
valfonction={'','min','max','mean','std','tinv'};

pasx=0.8/length(nomfonction); % largeur de colonne
debutx=0.05; % marge gauche
taille=length(nomfonction);
for i=1:taille-1
    var_tag=['stab_gourpebutton' num2str(i) '_tag'];
    hp=uibuttongroup('Parent', hp2,...
        'tag',var_tag,...
        'backgroundcolor',[1 1 1],...
        'Position',[debutx .1 pasx .8]);
    debutx=debutx+pasx;
    data.(var_tag) = hp; % 29/1/14
end
i=taille;
pasx=pasx+0.1; % colonne plus large pour les CI
var_tag=['stab_gourpebutton' num2str(i) '_tag'];
data.(var_tag)= uibuttongroup('Parent', hp2,...
    'tag',var_tag,...
    'backgroundcolor',[1 1 1],...
    'Position',[debutx .1 pasx .8]);
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(1);
for i=1:taille
    var_tag=eval(['data.stab_gourpebutton' num2str(i) '_tag']);
    
    uicontrol('parent',var_tag,...
        'units','normalized',...
        'fontsize',13,...
        'position',[0 .95 1 .04],...
        'backgroundcolor',[1 1 1],...
        'foregroundcolor','k',...
        'style','text',...
        'string',nomfonction{i});
end
pasy=0.94/nbparammodel; %hauteur pour chaque parametre
debuty = 0.94; % distance par rapport au bas du panel
for j=1:nbparammodel;
    debuty=debuty - pasy;
    uicontrol('parent',data.stab_gourpebutton1_tag,...
        'units','normalized',...
        'fontsize',13,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',traduc_nom(nomparam{j}, data.Basemodeles.type)});
    AC=[];
    for r=1:nombre_dynamique
        AC=[AC;RESULTAT{r}(j)];
    end
    
    for i=2:taille-1        
        res=eval([valfonction{i},'(AC)']);        
        var_tag=eval(['data.stab_gourpebutton' num2str(i) '_tag']);
        uicontrol('parent',var_tag,...
            'units','normalized',...
            'fontsize',13,...
            'position',[0 debuty 1 pasy],...
            'style','text',...
            'string',{'',num2str(res,4)});        
    end
    % IC
    res1=tinv(niveau/100,nombre_dynamique-1);
    res2=std(AC)/sqrt(nombre_dynamique);
    res=res1*res2;
    var_tag=eval(['data.stab_gourpebutton' num2str(taille) '_tag']);
    uicontrol('parent',var_tag,...
        'units','normalized',...
        'fontsize',13,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',['['   num2str(mean(AC)-res,4),';',num2str(mean(AC)+res,4) ']']});
    
    
end

% effacer les messages qui apparaissent duarnt le déroulement
set(data.com_tab_tag, 'String', '');
if nombre_dynamique >= nombre_dynamique_histo
    % ecrire les indices des panels en bas
    data=put_indices_panels(data, indice_panel, data.hpanel_work);
end
dataout=data;
end % fin etudestab
